/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.kernel.basic;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.lifecycle.LifecycleAdapter;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;
import org.apache.geronimo.kernel.lifecycle.LifecycleMonitor;

public class BasicDependencyManager
implements DependencyManager {
    private final LifecycleMonitor lifecycleMonitor;
    private final LifecycleListener lifecycleListener = new DependencyManagerLifecycleListener();
    private final Map childToParentMap = new HashMap();
    private final Map parentToChildMap = new HashMap();
    private final Map startHoldsMap = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public BasicDependencyManager(LifecycleMonitor lifecycleMonitor) throws Exception {
        if (!$assertionsDisabled && lifecycleMonitor == null) {
            throw new AssertionError();
        }
        this.lifecycleMonitor = lifecycleMonitor;
        lifecycleMonitor.addLifecycleListener(this.lifecycleListener, new ObjectName("*:*"));
    }

    public synchronized void close() {
        this.lifecycleMonitor.removeLifecycleListener(this.lifecycleListener);
        this.childToParentMap.clear();
        this.parentToChildMap.clear();
        this.startHoldsMap.clear();
    }

    public synchronized void addDependency(ObjectName child, ObjectName parent) {
        HashSet<ObjectName> parents = (HashSet<ObjectName>)this.childToParentMap.get(child);
        if (parents == null) {
            parents = new HashSet<ObjectName>();
            this.childToParentMap.put(child, parents);
        }
        parents.add(parent);
        HashSet<ObjectName> children = (HashSet<ObjectName>)this.parentToChildMap.get(parent);
        if (children == null) {
            children = new HashSet<ObjectName>();
            this.parentToChildMap.put(parent, children);
        }
        children.add(child);
    }

    public synchronized void removeDependency(ObjectName child, ObjectName parent) {
        Set children;
        Set parents = (Set)this.childToParentMap.get(child);
        if (parents != null) {
            parents.remove(parent);
        }
        if ((children = (Set)this.parentToChildMap.get(parent)) != null) {
            children.remove(child);
        }
    }

    public synchronized void removeAllDependencies(ObjectName child) {
        Set parents = (Set)this.childToParentMap.remove(child);
        if (parents == null) {
            return;
        }
        Iterator iterator = parents.iterator();
        while (iterator.hasNext()) {
            ObjectName parent = (ObjectName)iterator.next();
            Set children = (Set)this.parentToChildMap.get(parent);
            if (children == null) continue;
            children.remove(child);
        }
    }

    public synchronized void addDependencies(ObjectName child, Set parents) {
        HashSet existingParents = (HashSet)this.childToParentMap.get(child);
        if (existingParents == null) {
            existingParents = new HashSet(parents);
            this.childToParentMap.put(child, existingParents);
        } else {
            existingParents.addAll(parents);
        }
        Iterator i = parents.iterator();
        while (i.hasNext()) {
            Object startParent = i.next();
            HashSet<ObjectName> children = (HashSet<ObjectName>)this.parentToChildMap.get(startParent);
            if (children == null) {
                children = new HashSet<ObjectName>();
                this.parentToChildMap.put(startParent, children);
            }
            children.add(child);
        }
    }

    public synchronized Set getParents(ObjectName child) {
        Set parents = (Set)this.childToParentMap.get(child);
        if (parents == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(parents);
    }

    public synchronized Set getChildren(ObjectName parent) {
        Set children = (Set)this.parentToChildMap.get(parent);
        if (children == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(children);
    }

    public synchronized void addStartHolds(ObjectName objectName, Collection holds) {
        LinkedList currentHolds = (LinkedList)this.startHoldsMap.get(objectName);
        if (currentHolds == null) {
            currentHolds = new LinkedList(holds);
            this.startHoldsMap.put(objectName, currentHolds);
        } else {
            currentHolds.addAll(holds);
        }
    }

    public synchronized void removeStartHolds(ObjectName objectName, Collection holds) {
        Collection currentHolds = (Collection)this.startHoldsMap.get(objectName);
        if (currentHolds != null) {
            currentHolds.removeAll(holds);
        }
    }

    public synchronized void removeAllStartHolds(ObjectName objectName) {
        this.startHoldsMap.remove(objectName);
    }

    public synchronized ObjectName checkBlocker(ObjectName objectName) {
        Iterator iterator = this.startHoldsMap.keySet().iterator();
        while (iterator.hasNext()) {
            ObjectName blocker = (ObjectName)iterator.next();
            List holds = (List)this.startHoldsMap.get(blocker);
            Iterator holdsIterator = holds.iterator();
            while (holdsIterator.hasNext()) {
                ObjectName pattern = (ObjectName)holdsIterator.next();
                if (!pattern.apply(objectName)) continue;
                return blocker;
            }
        }
        return null;
    }

    static {
        $assertionsDisabled = !BasicDependencyManager.class.desiredAssertionStatus();
    }

    private class DependencyManagerLifecycleListener
    extends LifecycleAdapter {
        private DependencyManagerLifecycleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unloaded(ObjectName objectName) {
            BasicDependencyManager basicDependencyManager = BasicDependencyManager.this;
            synchronized (basicDependencyManager) {
                BasicDependencyManager.this.removeAllDependencies(objectName);
                BasicDependencyManager.this.removeAllStartHolds(objectName);
            }
        }
    }
}

