/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.runtime;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.runtime.FastMethodInvoker;
import org.apache.geronimo.gbean.runtime.GBeanInstance;
import org.apache.geronimo.gbean.runtime.GBeanReference;
import org.apache.geronimo.gbean.runtime.MethodInvoker;
import org.apache.geronimo.kernel.ClassLoading;
import org.apache.geronimo.kernel.DependencyManager;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.lifecycle.LifecycleListener;

public abstract class AbstractGBeanReference
implements GBeanReference {
    private final String name;
    private final Class referenceType;
    private final Class proxyType;
    private final GBeanInstance gbeanInstance;
    private final MethodInvoker setInvoker;
    private Set patterns = Collections.EMPTY_SET;
    private final LifecycleListener listener;
    private final Set targets = new HashSet();
    private final GReferenceInfo referenceInfo;
    private final Kernel kernel;
    private final DependencyManager dependencyManager;
    private Object proxy;
    private boolean isOnline = false;

    public AbstractGBeanReference(GBeanInstance gbeanInstance, GReferenceInfo referenceInfo, Kernel kernel, DependencyManager dependencyManager) throws InvalidConfigurationException {
        this.gbeanInstance = gbeanInstance;
        this.referenceInfo = referenceInfo;
        this.kernel = kernel;
        this.dependencyManager = dependencyManager;
        this.name = referenceInfo.getName();
        try {
            this.referenceType = ClassLoading.loadClass(referenceInfo.getReferenceType(), gbeanInstance.getType().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load Reference Type: " + this.getDescription());
        }
        if (Modifier.isFinal(this.referenceType.getModifiers())) {
            throw new IllegalArgumentException("Proxy interface cannot be a final class: " + this.referenceType.getName());
        }
        try {
            this.proxyType = ClassLoading.loadClass(referenceInfo.getProxyType(), gbeanInstance.getType().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load Proxy Type:" + this.getDescription());
        }
        if (referenceInfo.getSetterName() != null) {
            try {
                String setterName = referenceInfo.getSetterName();
                Method setterMethod = gbeanInstance.getType().getMethod(setterName, this.proxyType);
                this.setInvoker = new FastMethodInvoker(setterMethod);
            }
            catch (NoSuchMethodException e) {
                throw new InvalidConfigurationException("Setter method not found " + this.getDescription());
            }
        } else {
            this.setInvoker = null;
        }
        this.listener = this.createLifecycleListener();
    }

    protected abstract LifecycleListener createLifecycleListener();

    protected abstract void targetAdded(ObjectName var1);

    protected abstract void targetRemoved(ObjectName var1);

    protected final Kernel getKernel() {
        return this.kernel;
    }

    protected final DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public final GBeanInstance getGBeanInstance() {
        return this.gbeanInstance;
    }

    public final String getName() {
        return this.name;
    }

    public final GReferenceInfo getReferenceInfo() {
        return this.referenceInfo;
    }

    public final Class getReferenceType() {
        return this.referenceType;
    }

    public final Class getProxyType() {
        return this.proxyType;
    }

    public final Object getProxy() {
        return this.proxy;
    }

    protected final void setProxy(Object proxy) {
        this.proxy = proxy;
    }

    public final Set getPatterns() {
        return this.patterns;
    }

    public final void setPatterns(Set patterns) {
        if (this.isOnline) {
            throw new IllegalStateException("Pattern set can not be modified while online");
        }
        if (patterns == null || patterns.isEmpty() || patterns.size() == 1 && patterns.iterator().next() == null) {
            this.patterns = Collections.EMPTY_SET;
        } else {
            patterns = new HashSet(patterns);
            Iterator iterator = this.patterns.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
                break;
            }
            this.patterns = Collections.unmodifiableSet(patterns);
        }
    }

    public final synchronized void online() {
        Set gbeans = this.kernel.listGBeans(this.patterns);
        Iterator objectNameIterator = gbeans.iterator();
        while (objectNameIterator.hasNext()) {
            ObjectName target = (ObjectName)objectNameIterator.next();
            if (this.targets.contains(target) || !this.isRunning(this.kernel, target)) continue;
            this.targets.add(target);
        }
        this.kernel.getLifecycleMonitor().addLifecycleListener(this.listener, this.patterns);
        this.isOnline = true;
    }

    public final synchronized void offline() {
        this.stop();
        this.kernel.getLifecycleMonitor().removeLifecycleListener(this.listener);
        this.targets.clear();
        this.isOnline = false;
    }

    protected final Set getTargets() {
        return this.targets;
    }

    protected final void addTarget(ObjectName objectName) {
        if (!this.targets.contains(objectName)) {
            this.targets.add(objectName);
            this.targetAdded(objectName);
        }
    }

    protected final void removeTarget(ObjectName objectName) {
        boolean wasTarget = this.targets.remove(objectName);
        if (wasTarget) {
            this.targetRemoved(objectName);
        }
    }

    public final synchronized void inject(Object target) throws Exception {
        if (this.setInvoker != null && this.patterns.size() > 0) {
            this.setInvoker.invoke(target, new Object[]{this.getProxy()});
        }
    }

    private boolean isRunning(Kernel kernel, ObjectName objectName) {
        try {
            int state = kernel.getGBeanState(objectName);
            return state == 1;
        }
        catch (GBeanNotFoundException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected final String getDescription() {
        return "\n    GBeanInstance: " + this.gbeanInstance.getName() + "\n    Reference Name: " + this.getName() + "\n    Reference Type: " + this.referenceInfo.getReferenceType() + "\n    Proxy Type: " + this.referenceInfo.getProxyType();
    }
}

