/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.jar.JarFile;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.xmlbeans.XmlObject;

public abstract class Module {
    private final boolean standAlone;
    private final String name;
    private final URI configId;
    private final List parentId;
    private final URI moduleURI;
    private final JarFile moduleFile;
    private final String targetPath;
    private final URI targetPathURI;
    private final XmlObject specDD;
    private final XmlObject vendorDD;
    private final String originalSpecDD;
    private final String namespace;
    private URI uniqueModuleLocation;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Module(boolean standAlone, URI configId, List parentId, JarFile moduleFile, String targetPath, XmlObject specDD, XmlObject vendorDD, String originalSpecDD, String namespace) {
        if (!$assertionsDisabled && targetPath == null) {
            throw new AssertionError((Object)"targetPath is null");
        }
        this.standAlone = standAlone;
        this.configId = configId;
        this.parentId = parentId;
        this.moduleFile = moduleFile;
        this.targetPath = targetPath;
        this.specDD = specDD;
        this.vendorDD = vendorDD;
        this.originalSpecDD = originalSpecDD;
        this.namespace = namespace;
        if (standAlone) {
            this.name = configId.toString();
            this.moduleURI = URI.create("");
        } else {
            this.name = targetPath;
            this.moduleURI = URI.create(targetPath);
        }
        this.targetPathURI = URI.create(targetPath + "/");
    }

    public abstract ConfigurationModuleType getType();

    public String getName() {
        return this.name;
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public URI getConfigId() {
        return this.configId;
    }

    public List getParentId() {
        return this.parentId;
    }

    public URI getModuleURI() {
        return this.moduleURI;
    }

    public JarFile getModuleFile() {
        return this.moduleFile;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public URI getTargetPathURI() {
        return this.targetPathURI;
    }

    public XmlObject getSpecDD() {
        return this.specDD;
    }

    public XmlObject getVendorDD() {
        return this.vendorDD;
    }

    public String getOriginalSpecDD() {
        return this.originalSpecDD;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Module) {
            Module module = (Module)obj;
            return this.name.equals(module.name);
        }
        return false;
    }

    public void close() {
        DeploymentUtil.close((JarFile)this.moduleFile);
    }

    public void addClass(String fqcn, byte[] bytes, DeploymentContext context) throws IOException, URISyntaxException {
        URI location = this.getUniqueModuleLocation(context);
        this.addClass(location, fqcn, bytes, context);
    }

    private URI getUniqueModuleLocation(DeploymentContext context) {
        if (this.uniqueModuleLocation == null) {
            URI candidateURI;
            File candidateFile;
            String suffix = "";
            int i = 1;
            do {
                candidateURI = URI.create(this.targetPath + "-generated" + suffix + "/");
                candidateFile = context.getTargetFile(candidateURI);
                suffix = "" + i++;
            } while (candidateFile.exists());
            candidateFile.mkdirs();
            this.uniqueModuleLocation = candidateURI;
        }
        return this.uniqueModuleLocation;
    }

    public abstract void addClass(URI var1, String var2, byte[] var3, DeploymentContext var4) throws IOException, URISyntaxException;

    static {
        $assertionsDisabled = !Module.class.desiredAssertionStatus();
    }
}

