/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.j2ee.deployment.NamingContext;
import org.apache.geronimo.j2ee.deployment.RefContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContextImpl;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.security.deployment.SecurityConfiguration;

public class EARContext
extends DeploymentContext
implements NamingContext {
    private final ObjectName domainObjectName;
    private final ObjectName serverObjectName;
    private final ObjectName applicationObjectName;
    private final ObjectName transactionContextManagerObjectName;
    private final ObjectName connectionTrackerObjectName;
    private final ObjectName transactedTimerName;
    private final ObjectName nonTransactedTimerName;
    private final ObjectName corbaGBeanObjectName;
    private final RefContext refContext;
    private final J2eeContext j2eeContext;
    private final Map contextIDToPermissionsMap = new HashMap();
    private ObjectName jaccManagerName;
    private SecurityConfiguration securityConfiguration;

    public EARContext(File baseDir, URI id, ConfigurationModuleType moduleType, List parentID, Kernel kernel, String j2eeApplicationName, ObjectName transactionContextManagerObjectName, ObjectName connectionTrackerObjectName, ObjectName transactedTimerName, ObjectName nonTransactedTimerName, ObjectName corbaGBeanObjectName, RefContext refContext) throws MalformedObjectNameException, DeploymentException {
        super(baseDir, id, moduleType, parentID, kernel);
        this.j2eeContext = new J2eeContextImpl(this.getDomain(), this.getServer(), j2eeApplicationName == null ? "null" : j2eeApplicationName, "J2EEModule", "null", null, null);
        this.domainObjectName = NameFactory.getDomainName(null, (J2eeContext)this.j2eeContext);
        this.serverObjectName = NameFactory.getServerName(null, null, (J2eeContext)this.j2eeContext);
        this.applicationObjectName = j2eeApplicationName != null ? NameFactory.getApplicationName(null, null, null, (J2eeContext)this.j2eeContext) : null;
        this.transactionContextManagerObjectName = transactionContextManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.transactedTimerName = transactedTimerName;
        this.nonTransactedTimerName = nonTransactedTimerName;
        this.corbaGBeanObjectName = corbaGBeanObjectName;
        this.refContext = refContext;
    }

    public String getJ2EEDomainName() {
        return this.j2eeContext.getJ2eeDomainName();
    }

    public String getJ2EEServerName() {
        return this.j2eeContext.getJ2eeServerName();
    }

    public String getJ2EEApplicationName() {
        return this.j2eeContext.getJ2eeApplicationName();
    }

    public ObjectName getDomainObjectName() {
        return this.domainObjectName;
    }

    public ObjectName getServerObjectName() {
        return this.serverObjectName;
    }

    public ObjectName getApplicationObjectName() {
        return this.applicationObjectName;
    }

    public ObjectName getTransactionContextManagerObjectName() {
        return this.transactionContextManagerObjectName;
    }

    public ObjectName getConnectionTrackerObjectName() {
        return this.connectionTrackerObjectName;
    }

    public ObjectName getTransactedTimerName() {
        return this.transactedTimerName;
    }

    public ObjectName getNonTransactedTimerName() {
        return this.nonTransactedTimerName;
    }

    public ObjectName getCORBAGBeanObjectName() {
        return this.corbaGBeanObjectName;
    }

    public RefContext getRefContext() {
        return this.refContext;
    }

    public J2eeContext getJ2eeContext() {
        return this.j2eeContext;
    }

    public Map getContextIDToPermissionsMap() {
        return this.contextIDToPermissionsMap;
    }

    public void addSecurityContext(String contextID, Object componentPermissions) throws DeploymentException {
        Object old = this.contextIDToPermissionsMap.put(contextID, componentPermissions);
        if (old != null) {
            throw new DeploymentException("Duplicate contextID registered! " + contextID);
        }
    }

    public void setJaccManagerName(ObjectName jaccManagerName) {
        this.jaccManagerName = jaccManagerName;
    }

    public ObjectName getJaccManagerName() {
        return this.jaccManagerName;
    }

    public void setSecurityConfiguration(SecurityConfiguration securityConfiguration) throws DeploymentException {
        if (this.securityConfiguration != null) {
            throw new DeploymentException("Only one security configuration allowed per application");
        }
        this.securityConfiguration = securityConfiguration;
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }
}

