/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.local;

import java.net.URI;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.apache.geronimo.deployment.plugin.local.CommandSupport;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.InvalidConfigException;

public class StopCommand
extends CommandSupport {
    private final Kernel kernel;
    private final TargetModuleID[] modules;

    public StopCommand(Kernel kernel, TargetModuleID[] modules) {
        super(CommandType.STOP);
        this.kernel = kernel;
        this.modules = modules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)this.kernel);
            try {
                for (int i = 0; i < this.modules.length; ++i) {
                    TargetModuleID module = this.modules[i];
                    URI moduleID = URI.create(module.getModuleID());
                    try {
                        configurationManager.stop(moduleID);
                    }
                    catch (InvalidConfigException e) {
                        this.updateStatus("Module " + moduleID + " is not running.");
                        continue;
                    }
                    configurationManager.unload(moduleID);
                    this.addModule(module);
                }
            }
            finally {
                ConfigurationUtil.releaseConfigurationManager((Kernel)this.kernel, (ConfigurationManager)configurationManager);
            }
            if (this.getModuleCount() < this.modules.length) {
                this.fail("Some modules could not be stopped");
            } else {
                this.complete("Completed");
            }
        }
        catch (Exception e) {
            this.doFail(e);
        }
    }
}

