/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.core.service.Invocation;
import org.apache.geronimo.core.service.InvocationResult;
import org.apache.geronimo.core.service.SimpleInvocationResult;
import org.apache.geronimo.proxy.ProxyInvocation;

public class ReflexiveInterceptor
implements Interceptor {
    Object target;

    public ReflexiveInterceptor(Object target) {
        this.target = target;
    }

    public InvocationResult invoke(Invocation invocation) throws Throwable {
        try {
            Method m = ProxyInvocation.getMethod(invocation);
            Object[] args = ProxyInvocation.getArguments(invocation);
            Object rc = m.invoke(this.target, args);
            return new SimpleInvocationResult(true, rc);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof Exception && !(t instanceof RuntimeException)) {
                return new SimpleInvocationResult(false, (Exception)t);
            }
            throw t;
        }
    }
}

