/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.geronimo.core.service.Interceptor;
import org.apache.geronimo.core.service.InvocationResult;
import org.apache.geronimo.proxy.ProxyInvocation;
import org.apache.geronimo.proxy.SimpleRPCContainer;

public class ProxyContainer
extends SimpleRPCContainer
implements InvocationHandler {
    public ProxyContainer(Interceptor firstInterceptor) {
        super(firstInterceptor);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ProxyInvocation invocation = new ProxyInvocation();
        ProxyInvocation.putMethod(invocation, method);
        ProxyInvocation.putArguments(invocation, args);
        ProxyInvocation.putProxy(invocation, proxy);
        InvocationResult result = this.invoke(invocation);
        if (result.isException()) {
            throw result.getException();
        }
        return result.getResult();
    }

    public Object createProxy(ClassLoader cl, Class[] interfaces) {
        return Proxy.newProxyInstance(cl, interfaces, (InvocationHandler)this);
    }

    public static ProxyContainer getContainer(Object proxy) {
        if (Proxy.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException("Not a proxy.");
        }
        return (ProxyContainer)Proxy.getInvocationHandler(proxy);
    }
}

