/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.deployment;

import [Ljava.net.URI;;
import java.beans.Introspector;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Reference;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;
import org.apache.geronimo.connector.ActivationSpecWrapperGBean;
import org.apache.geronimo.connector.AdminObjectWrapperGBean;
import org.apache.geronimo.connector.JCAResourceImplGBean;
import org.apache.geronimo.connector.ResourceAdapterImplGBean;
import org.apache.geronimo.connector.ResourceAdapterModuleImplGBean;
import org.apache.geronimo.connector.ResourceAdapterWrapperGBean;
import org.apache.geronimo.connector.deployment.ConnectorPlanRectifier;
import org.apache.geronimo.connector.outbound.JCAConnectionFactoryImplGBean;
import org.apache.geronimo.connector.outbound.ManagedConnectionFactoryWrapperGBean;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.LocalTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.SinglePool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionLog;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.XATransactions;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.service.ServiceConfigBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.xbeans.ClassFilterType;
import org.apache.geronimo.deployment.xbeans.DependencyType;
import org.apache.geronimo.deployment.xbeans.GbeanType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.DynamicGAttributeInfo;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.j2ee.deployment.ConnectorModule;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.ResourceReferenceBuilder;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContextImpl;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.naming.reference.ResourceReference;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.geronimo.GerAdminobjectInstanceType;
import org.apache.geronimo.xbeans.geronimo.GerAdminobjectType;
import org.apache.geronimo.xbeans.geronimo.GerConfigPropertySettingType;
import org.apache.geronimo.xbeans.geronimo.GerConnectionDefinitionType;
import org.apache.geronimo.xbeans.geronimo.GerConnectiondefinitionInstanceType;
import org.apache.geronimo.xbeans.geronimo.GerConnectionmanagerType;
import org.apache.geronimo.xbeans.geronimo.GerConnectorDocument;
import org.apache.geronimo.xbeans.geronimo.GerConnectorType;
import org.apache.geronimo.xbeans.geronimo.GerResourceadapterType;
import org.apache.geronimo.xbeans.geronimo.GerSinglepoolType;
import org.apache.geronimo.xbeans.geronimo.naming.GerGbeanLocatorType;
import org.apache.geronimo.xbeans.j2ee.ActivationspecType;
import org.apache.geronimo.xbeans.j2ee.AdminobjectType;
import org.apache.geronimo.xbeans.j2ee.ConfigPropertyType;
import org.apache.geronimo.xbeans.j2ee.ConnectionDefinitionType;
import org.apache.geronimo.xbeans.j2ee.ConnectorDocument;
import org.apache.geronimo.xbeans.j2ee.ConnectorType;
import org.apache.geronimo.xbeans.j2ee.MessagelistenerType;
import org.apache.geronimo.xbeans.j2ee.ResourceadapterType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class ConnectorModuleBuilder
implements ModuleBuilder,
ResourceReferenceBuilder {
    private final int defaultMaxSize;
    private final int defaultMinSize;
    private final int defaultBlockingTimeoutMilliseconds;
    private final int defaultIdleTimeoutMinutes;
    private final boolean defaultXATransactionCaching;
    private final boolean defaultXAThreadCaching;
    private final List defaultParentId;
    private final Repository repository;
    private final Kernel kernel;
    private static QName CONNECTOR_QNAME;
    static final String GERCONNECTOR_NAMESPACE;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$apache$geronimo$connector$ActivationSpecWrapperGBean;
    static /* synthetic */ Class class$org$apache$geronimo$connector$outbound$ManagedConnectionFactoryWrapper;
    static /* synthetic */ Class class$org$apache$geronimo$connector$AdminObjectWrapper;

    public ConnectorModuleBuilder(URI[] defaultParentId, int defaultMaxSize, int defaultMinSize, int defaultBlockingTimeoutMilliseconds, int defaultIdleTimeoutMinutes, boolean defaultXATransactionCaching, boolean defaultXAThreadCaching, Repository repository, Kernel kernel) {
        if (!$assertionsDisabled && repository == null) {
            throw new AssertionError();
        }
        this.defaultParentId = defaultParentId == null ? Collections.EMPTY_LIST : Arrays.asList(defaultParentId);
        this.defaultMaxSize = defaultMaxSize;
        this.defaultMinSize = defaultMinSize;
        this.defaultBlockingTimeoutMilliseconds = defaultBlockingTimeoutMilliseconds;
        this.defaultIdleTimeoutMinutes = defaultIdleTimeoutMinutes;
        this.defaultXATransactionCaching = defaultXATransactionCaching;
        this.defaultXAThreadCaching = defaultXAThreadCaching;
        this.repository = repository;
        this.kernel = kernel;
    }

    public Module createModule(File plan, JarFile moduleFile) throws DeploymentException {
        return this.createModule(plan, moduleFile, "rar", null, true);
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, URI earConfigId, Object moduleContextInfo) throws DeploymentException {
        return this.createModule(plan, moduleFile, targetPath, specDDUrl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, boolean standAlone) throws DeploymentException {
        ConnectorType connector;
        String specDD;
        if (!$assertionsDisabled && moduleFile == null) {
            throw new AssertionError((Object)"moduleFile is null");
        }
        if (!$assertionsDisabled && targetPath == null) {
            throw new AssertionError((Object)"targetPath is null");
        }
        if (!$assertionsDisabled && targetPath.endsWith("/")) {
            throw new AssertionError((Object)"targetPath must not end with a '/'");
        }
        try {
            if (specDDUrl == null) {
                specDDUrl = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"META-INF/ra.xml");
            }
            specDD = DeploymentUtil.readAll((URL)specDDUrl);
        }
        catch (Exception e) {
            return null;
        }
        try {
            XmlObject xmlObject = XmlBeansUtil.parse((String)specDD);
            ConnectorDocument connectorDoc = SchemaConversionUtils.convertToConnectorSchema((XmlObject)xmlObject);
            connector = connectorDoc.getConnector();
        }
        catch (XmlException e) {
            throw new DeploymentException("Could not parse ra.xml descriptor", (Throwable)e);
        }
        GerConnectorType gerConnector = null;
        try {
            try {
                if (plan instanceof XmlObject) {
                    gerConnector = (GerConnectorType)SchemaConversionUtils.getNestedObjectAsType((XmlObject)((XmlObject)plan), (QName)CONNECTOR_QNAME, (SchemaType)GerConnectorType.type);
                } else {
                    GerConnectorDocument gerConnectorDoc = null;
                    ArrayList errors = new ArrayList();
                    if (plan != null) {
                        gerConnectorDoc = GerConnectorDocument.Factory.parse((File)plan, XmlBeansUtil.createXmlOptions(errors));
                    } else {
                        URL path = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"META-INF/geronimo-ra.xml");
                        gerConnectorDoc = GerConnectorDocument.Factory.parse(path, XmlBeansUtil.createXmlOptions(errors));
                    }
                    if (errors.size() > 0) {
                        throw new DeploymentException("Could not parse connector doc: " + errors);
                    }
                    if (gerConnectorDoc != null) {
                        gerConnector = gerConnectorDoc.getConnector();
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (gerConnector == null) {
                throw new DeploymentException("A connector module must be deployed using a Geronimo deployment plan (either META-INF/geronimo-ra.xml in the RAR file or a standalone deployment plan passed to the deployer).");
            }
            ConnectorPlanRectifier.rectifyPlan(gerConnector);
            XmlCursor cursor = gerConnector.newCursor();
            try {
                SchemaConversionUtils.convertToGeronimoSubSchemas((XmlCursor)cursor);
            }
            finally {
                cursor.dispose();
            }
            SchemaConversionUtils.validateDD((XmlObject)gerConnector);
        }
        catch (XmlException e) {
            throw new DeploymentException((Throwable)e);
        }
        URI configId = null;
        try {
            configId = new URI(gerConnector.getConfigId());
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Invalid configId " + gerConnector.getConfigId(), (Throwable)e);
        }
        List parentId = ServiceConfigBuilder.getParentID((String)gerConnector.getParentId(), (DependencyType[])gerConnector.getImportArray());
        if (!gerConnector.getSuppressDefaultParentId()) {
            parentId.addAll(this.defaultParentId);
        }
        return new ConnectorModule(standAlone, configId, parentId, moduleFile, targetPath, (XmlObject)connector, (XmlObject)gerConnector, specDD);
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module) throws DeploymentException {
        GerConnectorType vendorConnector = (GerConnectorType)module.getVendorDD();
        try {
            JarFile moduleFile = module.getModuleFile();
            earContext.addManifestClassPath(moduleFile, URI.create(module.getTargetPath()));
            URI targetURI = URI.create(module.getTargetPath() + "/");
            Enumeration<JarEntry> entries = moduleFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                URI target = targetURI.resolve(entry.getName());
                if (entry.getName().endsWith(".jar")) {
                    earContext.addInclude(target, (ZipFile)moduleFile, entry);
                    continue;
                }
                earContext.addFile(target, (ZipFile)moduleFile, entry);
            }
            DependencyType[] dependencies = vendorConnector.getDependencyArray();
            ServiceConfigBuilder.addDependencies((DeploymentContext)earContext, (DependencyType[])dependencies, (Repository)this.repository);
        }
        catch (IOException e) {
            throw new DeploymentException("Problem deploying connector", (Throwable)e);
        }
        if (vendorConnector.isSetInverseClassloading()) {
            earContext.setInverseClassloading(vendorConnector.getInverseClassloading());
        }
        ClassFilterType[] filters = vendorConnector.getHiddenClassesArray();
        ServiceConfigBuilder.addHiddenClasses((DeploymentContext)earContext, (ClassFilterType[])filters);
        filters = vendorConnector.getNonOverridableClassesArray();
        ServiceConfigBuilder.addNonOverridableClasses((DeploymentContext)earContext, (ClassFilterType[])filters);
    }

    public void initContext(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
        J2eeContext earJ2eeContext = earContext.getJ2eeContext();
        J2eeContextImpl moduleJ2eeContext = J2eeContextImpl.newModuleContextFromApplication((J2eeContext)earJ2eeContext, (String)"ResourceAdapterModule", (String)module.getName());
        J2eeContextImpl resourceJ2eeContext = J2eeContextImpl.newModuleContextFromApplication((J2eeContext)earJ2eeContext, (String)"JCAResource", (String)module.getName());
        ConnectorType connector = (ConnectorType)module.getSpecDD();
        ObjectName resourceAdapterModuleName = null;
        try {
            resourceAdapterModuleName = NameFactory.getModuleName(null, null, null, null, null, (J2eeContext)moduleJ2eeContext);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Could not construct module name", (Throwable)e);
        }
        GBeanData resourceAdapterModuleData = new GBeanData(resourceAdapterModuleName, ResourceAdapterModuleImplGBean.GBEAN_INFO);
        resourceAdapterModuleData.setReferencePattern("J2EEServer", earContext.getServerObjectName());
        if (!earContext.getJ2EEApplicationName().equals("null")) {
            resourceAdapterModuleData.setReferencePattern("J2EEApplication", earContext.getApplicationObjectName());
        }
        resourceAdapterModuleData.setAttribute("deploymentDescriptor", (Object)module.getOriginalSpecDD());
        resourceAdapterModuleData.setAttribute("displayName", connector.getDisplayNameArray().length == 0 ? null : connector.getDisplayNameArray(0).getStringValue());
        resourceAdapterModuleData.setAttribute("description", connector.getDescriptionArray().length == 0 ? null : connector.getDescriptionArray(0).getStringValue());
        resourceAdapterModuleData.setAttribute("vendorName", (Object)connector.getVendorName().getStringValue());
        resourceAdapterModuleData.setAttribute("EISType", (Object)connector.getEisType().getStringValue());
        resourceAdapterModuleData.setAttribute("resourceAdapterVersion", (Object)connector.getResourceadapterVersion().getStringValue());
        ResourceadapterType resourceadapter = connector.getResourceadapter();
        if (resourceadapter.isSetResourceadapterClass()) {
            GBeanInfoBuilder resourceAdapterInfoBuilder = new GBeanInfoBuilder(ResourceAdapterWrapperGBean.class, ResourceAdapterWrapperGBean.GBEAN_INFO);
            GBeanData resourceAdapterGBeanData = this.setUpDynamicGBean(resourceAdapterInfoBuilder, resourceadapter.getConfigPropertyArray(), cl);
            resourceAdapterGBeanData.setAttribute("resourceAdapterClass", (Object)resourceadapter.getResourceadapterClass().getStringValue().trim());
            resourceAdapterModuleData.setAttribute("resourceAdapterGBeanData", (Object)resourceAdapterGBeanData);
        }
        if (resourceadapter.isSetInboundResourceadapter() && resourceadapter.getInboundResourceadapter().isSetMessageadapter()) {
            Map activationSpecInfoMap = this.getActivationSpecInfoMap(resourceadapter.getInboundResourceadapter().getMessageadapter().getMessagelistenerArray(), cl);
            resourceAdapterModuleData.setAttribute("activationSpecInfoMap", (Object)activationSpecInfoMap);
        }
        Map adminObjectInfoMap = this.getAdminObjectInfoMap(resourceadapter.getAdminobjectArray(), cl);
        resourceAdapterModuleData.setAttribute("adminObjectInfoMap", (Object)adminObjectInfoMap);
        if (resourceadapter.isSetOutboundResourceadapter()) {
            Map managedConnectionFactoryInfoMap = this.getManagedConnectionFactoryInfoMap(resourceadapter.getOutboundResourceadapter().getConnectionDefinitionArray(), cl);
            resourceAdapterModuleData.setAttribute("managedConnectionFactoryInfoMap", (Object)managedConnectionFactoryInfoMap);
        }
        earContext.addGBean(resourceAdapterModuleData);
        GerConnectorType geronimoConnector = (GerConnectorType)module.getVendorDD();
        GerResourceadapterType[] geronimoResourceAdapters = geronimoConnector.getResourceadapterArray();
        for (int k = 0; k < geronimoResourceAdapters.length; ++k) {
            GerResourceadapterType geronimoResourceAdapter = geronimoResourceAdapters[k];
            if (resourceadapter.isSetResourceadapterClass()) {
                try {
                    if (resourceadapter.isSetInboundResourceadapter() && resourceadapter.getInboundResourceadapter().isSetMessageadapter()) {
                        String resourceAdapterName = geronimoResourceAdapter.getResourceadapterInstance().getResourceadapterName();
                        ObjectName resourceAdapterObjectName = NameFactory.getComponentName(null, null, null, null, null, (String)resourceAdapterName, (String)"JCAResourceAdapter", (J2eeContext)resourceJ2eeContext);
                        GBeanData resourceAdapterData = new GBeanData(resourceAdapterObjectName, null);
                        earContext.addGBean(resourceAdapterData);
                    }
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException("Could not construct resource adapter instance", (Throwable)e);
                }
            }
            if (!geronimoResourceAdapter.isSetOutboundResourceadapter()) continue;
            GerConnectionDefinitionType[] connectionDefinitions = geronimoResourceAdapter.getOutboundResourceadapter().getConnectionDefinitionArray();
            for (int i = 0; i < connectionDefinitions.length; ++i) {
                GerConnectionDefinitionType connectionDefinition = connectionDefinitions[i];
                GerConnectiondefinitionInstanceType[] connectionDefinitionInstances = connectionDefinition.getConnectiondefinitionInstanceArray();
                for (int j = 0; j < connectionDefinitionInstances.length; ++j) {
                    GerConnectiondefinitionInstanceType connectionDefinitionInstance = connectionDefinitionInstances[j];
                    ObjectName connectionFactoryObjectName = null;
                    try {
                        connectionFactoryObjectName = NameFactory.getComponentName(null, null, null, null, null, (String)connectionDefinitionInstance.getName(), (String)"JCAManagedConnectionFactory", (J2eeContext)resourceJ2eeContext);
                    }
                    catch (MalformedObjectNameException e) {
                        throw new DeploymentException("Could not construct resource object name", (Throwable)e);
                    }
                    GBeanData connectionFactoryData = new GBeanData(connectionFactoryObjectName, null);
                    earContext.addGBean(connectionFactoryData);
                }
            }
        }
        for (int i = 0; i < geronimoConnector.getAdminobjectArray().length; ++i) {
            GerAdminobjectType gerAdminObject = geronimoConnector.getAdminobjectArray()[i];
            for (int j = 0; j < gerAdminObject.getAdminobjectInstanceArray().length; ++j) {
                GerAdminobjectInstanceType gerAdminObjectInstance = gerAdminObject.getAdminobjectInstanceArray()[j];
                ObjectName adminObjectObjectName = null;
                try {
                    adminObjectObjectName = NameFactory.getComponentName(null, null, null, null, null, (String)gerAdminObjectInstance.getMessageDestinationName(), (String)"JCAAdminObject", (J2eeContext)resourceJ2eeContext);
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException("Could not construct resource object name", (Throwable)e);
                }
                GBeanData adminObjectData = new GBeanData(adminObjectObjectName, null);
                earContext.addGBean(adminObjectData);
            }
        }
    }

    public void addGBeans(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
        J2eeContext earJ2eeContext = earContext.getJ2eeContext();
        J2eeContextImpl moduleJ2eeContext = J2eeContextImpl.newModuleContextFromApplication((J2eeContext)earJ2eeContext, (String)"ResourceAdapterModule", (String)module.getName());
        J2eeContextImpl resourceJ2eeContext = J2eeContextImpl.newModuleContextFromApplication((J2eeContext)earJ2eeContext, (String)"JCAResource", (String)module.getName());
        XmlObject specDD = module.getSpecDD();
        ObjectName resourceAdapterModuleName = null;
        try {
            resourceAdapterModuleName = NameFactory.getModuleName(null, null, null, null, null, (J2eeContext)moduleJ2eeContext);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Could not construct module name", (Throwable)e);
        }
        GBeanData resourceAdapterModuleData = null;
        try {
            resourceAdapterModuleData = earContext.getGBeanInstance(resourceAdapterModuleName);
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("Internal consistency bug: Could not retrieve gbean data for module: " + resourceAdapterModuleName);
        }
        if (resourceAdapterModuleData == null) {
            throw new DeploymentException("Internal consistency bug: gbean data for module is missing: " + resourceAdapterModuleName);
        }
        ObjectName resourceAdapterjsr77Name = null;
        try {
            resourceAdapterjsr77Name = NameFactory.getComponentName(null, null, null, null, null, (String)resourceJ2eeContext.getJ2eeModuleName(), (String)"ResourceAdapter", (J2eeContext)moduleJ2eeContext);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Could not construct resource adapter placeholder name", (Throwable)e);
        }
        resourceAdapterModuleData.setAttribute("resourceAdapter", (Object)resourceAdapterjsr77Name.getCanonicalName());
        earContext.addGBean(resourceAdapterModuleData);
        GBeanData resourceAdapterData = new GBeanData(resourceAdapterjsr77Name, ResourceAdapterImplGBean.GBEAN_INFO);
        ObjectName jcaResourcejsr77Name = null;
        try {
            jcaResourcejsr77Name = NameFactory.getComponentName(null, null, null, (String)"ResourceAdapter", null, (String)resourceJ2eeContext.getJ2eeModuleName(), (String)"JCAResource", (J2eeContext)moduleJ2eeContext);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Could not construct jca resource placeholder name", (Throwable)e);
        }
        resourceAdapterData.setAttribute("JCAResource", (Object)jcaResourcejsr77Name.getCanonicalName());
        earContext.addGBean(resourceAdapterData);
        GBeanData jcaResourceData = new GBeanData(jcaResourcejsr77Name, JCAResourceImplGBean.GBEAN_INFO);
        earContext.addGBean(jcaResourceData);
        GerConnectorType geronimoConnector = (GerConnectorType)module.getVendorDD();
        GbeanType[] gbeans = geronimoConnector.getGbeanArray();
        ServiceConfigBuilder.addGBeans((GbeanType[])gbeans, (ClassLoader)cl, (J2eeContext)moduleJ2eeContext, (DeploymentContext)earContext);
        this.addConnectorGBeans(earContext, (J2eeContext)resourceJ2eeContext, resourceAdapterModuleData, (ConnectorType)specDD, geronimoConnector, cl);
    }

    public String getSchemaNamespace() {
        return GERCONNECTOR_NAMESPACE;
    }

    private void addConnectorGBeans(EARContext earContext, J2eeContext moduleJ2eeContext, GBeanData resourceAdapterModuleData, ConnectorType connector, GerConnectorType geronimoConnector, ClassLoader cl) throws DeploymentException {
        ResourceadapterType resourceadapter = connector.getResourceadapter();
        GerResourceadapterType[] geronimoResourceAdapters = geronimoConnector.getResourceadapterArray();
        for (int k = 0; k < geronimoResourceAdapters.length; ++k) {
            GerResourceadapterType geronimoResourceAdapter = geronimoResourceAdapters[k];
            ObjectName resourceAdapterObjectName = null;
            if (resourceadapter.isSetResourceadapterClass()) {
                GBeanData resourceAdapterGBeanData = this.locateResourceAdapterGBeanData(resourceAdapterModuleData);
                GBeanData resourceAdapterInstanceGBeanData = new GBeanData(resourceAdapterGBeanData);
                this.setDynamicGBeanDataAttributes(resourceAdapterInstanceGBeanData, geronimoResourceAdapter.getResourceadapterInstance().getConfigPropertySettingArray(), cl);
                ObjectName workManagerName = ENCConfigBuilder.getGBeanId((String)"JCAWorkManager", (GerGbeanLocatorType)geronimoResourceAdapter.getResourceadapterInstance().getWorkmanager(), (J2eeContext)moduleJ2eeContext, (DeploymentContext)earContext, (Kernel)this.kernel);
                resourceAdapterInstanceGBeanData.setReferencePattern("WorkManager", workManagerName);
                String resourceAdapterName = geronimoResourceAdapter.getResourceadapterInstance().getResourceadapterName();
                try {
                    resourceAdapterObjectName = NameFactory.getComponentName(null, null, null, null, null, (String)resourceAdapterName, (String)"JCAResourceAdapter", (J2eeContext)moduleJ2eeContext);
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException("Could not construct resource adapter object name", (Throwable)e);
                }
                resourceAdapterInstanceGBeanData.setName(resourceAdapterObjectName);
                earContext.addGBean(resourceAdapterInstanceGBeanData);
            }
            if (!geronimoResourceAdapter.isSetOutboundResourceadapter()) continue;
            if (!resourceadapter.isSetOutboundResourceadapter()) {
                throw new DeploymentException("Geronimo plan configures an outbound resource adapter but ra.xml does not describe any");
            }
            String transactionSupport = resourceadapter.getOutboundResourceadapter().getTransactionSupport().getStringValue().trim();
            for (int i = 0; i < geronimoResourceAdapter.getOutboundResourceadapter().getConnectionDefinitionArray().length; ++i) {
                GerConnectionDefinitionType geronimoConnectionDefinition = geronimoResourceAdapter.getOutboundResourceadapter().getConnectionDefinitionArray(i);
                if (!$assertionsDisabled && geronimoConnectionDefinition == null) {
                    throw new AssertionError((Object)"Null GeronimoConnectionDefinition");
                }
                String connectionFactoryInterfaceName = geronimoConnectionDefinition.getConnectionfactoryInterface().trim();
                GBeanData connectionFactoryGBeanData = this.locateConnectionFactoryInfo(resourceAdapterModuleData, connectionFactoryInterfaceName);
                if (connectionFactoryGBeanData == null) {
                    throw new DeploymentException("No connection definition for ConnectionFactory class: " + connectionFactoryInterfaceName);
                }
                for (int j = 0; j < geronimoConnectionDefinition.getConnectiondefinitionInstanceArray().length; ++j) {
                    GerConnectiondefinitionInstanceType connectionfactoryInstance = geronimoConnectionDefinition.getConnectiondefinitionInstanceArray()[j];
                    this.addOutboundGBeans(earContext, moduleJ2eeContext, resourceAdapterObjectName, connectionFactoryGBeanData, connectionfactoryInstance, transactionSupport, cl);
                }
            }
        }
        for (int i = 0; i < geronimoConnector.getAdminobjectArray().length; ++i) {
            GerAdminobjectType gerAdminObject = geronimoConnector.getAdminobjectArray()[i];
            String adminObjectInterface = gerAdminObject.getAdminobjectInterface().trim();
            GBeanData adminObjectGBeanData = this.locateAdminObjectInfo(resourceAdapterModuleData, adminObjectInterface);
            if (adminObjectGBeanData == null) {
                throw new DeploymentException("No admin object declared for interface: " + adminObjectInterface);
            }
            for (int j = 0; j < gerAdminObject.getAdminobjectInstanceArray().length; ++j) {
                GBeanData adminObjectInstanceGBeanData = new GBeanData(adminObjectGBeanData);
                GerAdminobjectInstanceType gerAdminObjectInstance = gerAdminObject.getAdminobjectInstanceArray()[j];
                this.setDynamicGBeanDataAttributes(adminObjectInstanceGBeanData, gerAdminObjectInstance.getConfigPropertySettingArray(), cl);
                ObjectName adminObjectObjectName = null;
                try {
                    adminObjectObjectName = NameFactory.getComponentName(null, null, null, null, null, (String)gerAdminObjectInstance.getMessageDestinationName(), (String)"JCAAdminObject", (J2eeContext)moduleJ2eeContext);
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException("Could not construct admin object object name", (Throwable)e);
                }
                adminObjectInstanceGBeanData.setName(adminObjectObjectName);
                earContext.addGBean(adminObjectInstanceGBeanData);
            }
        }
    }

    private Map getActivationSpecInfoMap(MessagelistenerType[] messagelistenerArray, ClassLoader cl) throws DeploymentException {
        HashMap<String, GBeanData> activationSpecInfos = new HashMap<String, GBeanData>();
        for (int i = 0; i < messagelistenerArray.length; ++i) {
            MessagelistenerType messagelistenerType = messagelistenerArray[i];
            String messageListenerInterface = messagelistenerType.getMessagelistenerType().getStringValue().trim();
            ActivationspecType activationspec = messagelistenerType.getActivationspec();
            String activationSpecClassName = activationspec.getActivationspecClass().getStringValue().trim();
            GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder(class$org$apache$geronimo$connector$ActivationSpecWrapperGBean == null ? ConnectorModuleBuilder.class$("org.apache.geronimo.connector.ActivationSpecWrapperGBean") : class$org$apache$geronimo$connector$ActivationSpecWrapperGBean, ActivationSpecWrapperGBean.GBEAN_INFO);
            HashMap<String, String> getters = new HashMap<String, String>();
            HashSet<String> setters = new HashSet<String>();
            Method[] methods = null;
            try {
                Class<?> activationSpecClass = cl.loadClass(activationSpecClassName);
                methods = activationSpecClass.getMethods();
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Can not load activation spec class", (Throwable)e);
            }
            for (int j = 0; j < methods.length; ++j) {
                Method method = methods[j];
                String methodName = method.getName();
                if ((methodName.startsWith("get") || methodName.startsWith("is")) && method.getParameterTypes().length == 0) {
                    String attributeName = methodName.startsWith("get") ? methodName.substring(3) : methodName.substring(2);
                    getters.put(Introspector.decapitalize(attributeName), method.getReturnType().getName());
                    continue;
                }
                if (!methodName.startsWith("set") || method.getParameterTypes().length != 1) continue;
                setters.add(Introspector.decapitalize(methodName.substring(3)));
            }
            getters.keySet().retainAll(setters);
            getters.remove("resourceAdapter");
            Iterator iterator = getters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                infoBuilder.addAttribute((GAttributeInfo)new DynamicGAttributeInfo((String)entry.getKey(), (String)entry.getValue(), true, true, true, true));
            }
            GBeanInfo gbeanInfo = infoBuilder.getBeanInfo();
            try {
                cl.loadClass(activationSpecClassName);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException("Could not load ActivationSpec class", (Throwable)e);
            }
            GBeanData activationSpecInfo = new GBeanData(gbeanInfo);
            activationSpecInfo.setAttribute("activationSpecClass", (Object)activationSpecClassName);
            activationSpecInfos.put(messageListenerInterface, activationSpecInfo);
        }
        return activationSpecInfos;
    }

    private Map getManagedConnectionFactoryInfoMap(ConnectionDefinitionType[] connectionDefinitionArray, ClassLoader cl) throws DeploymentException {
        HashMap<String, GBeanData> managedConnectionFactoryInfos = new HashMap<String, GBeanData>();
        for (int i = 0; i < connectionDefinitionArray.length; ++i) {
            ConnectionDefinitionType connectionDefinition = connectionDefinitionArray[i];
            GBeanInfoBuilder managedConnectionFactoryInfoBuilder = new GBeanInfoBuilder(class$org$apache$geronimo$connector$outbound$ManagedConnectionFactoryWrapper == null ? ConnectorModuleBuilder.class$("org.apache.geronimo.connector.outbound.ManagedConnectionFactoryWrapper") : class$org$apache$geronimo$connector$outbound$ManagedConnectionFactoryWrapper, ManagedConnectionFactoryWrapperGBean.GBEAN_INFO);
            GBeanData managedConnectionFactoryGBeanData = this.setUpDynamicGBean(managedConnectionFactoryInfoBuilder, connectionDefinition.getConfigPropertyArray(), cl);
            String connectionfactoryInterface = connectionDefinition.getConnectionfactoryInterface().getStringValue().trim();
            managedConnectionFactoryGBeanData.setAttribute("managedConnectionFactoryClass", (Object)connectionDefinition.getManagedconnectionfactoryClass().getStringValue().trim());
            managedConnectionFactoryGBeanData.setAttribute("connectionFactoryInterface", (Object)connectionfactoryInterface);
            managedConnectionFactoryGBeanData.setAttribute("connectionFactoryImplClass", (Object)connectionDefinition.getConnectionfactoryImplClass().getStringValue().trim());
            managedConnectionFactoryGBeanData.setAttribute("connectionInterface", (Object)connectionDefinition.getConnectionInterface().getStringValue().trim());
            managedConnectionFactoryGBeanData.setAttribute("connectionImplClass", (Object)connectionDefinition.getConnectionImplClass().getStringValue().trim());
            managedConnectionFactoryInfos.put(connectionfactoryInterface, managedConnectionFactoryGBeanData);
        }
        return managedConnectionFactoryInfos;
    }

    private Map getAdminObjectInfoMap(AdminobjectType[] adminobjectArray, ClassLoader cl) throws DeploymentException {
        HashMap<String, GBeanData> adminObjectInfos = new HashMap<String, GBeanData>();
        for (int i = 0; i < adminobjectArray.length; ++i) {
            AdminobjectType adminObject = adminobjectArray[i];
            GBeanInfoBuilder adminObjectInfoBuilder = new GBeanInfoBuilder(class$org$apache$geronimo$connector$AdminObjectWrapper == null ? ConnectorModuleBuilder.class$("org.apache.geronimo.connector.AdminObjectWrapper") : class$org$apache$geronimo$connector$AdminObjectWrapper, AdminObjectWrapperGBean.GBEAN_INFO);
            GBeanData adminObjectGBeanData = this.setUpDynamicGBean(adminObjectInfoBuilder, adminObject.getConfigPropertyArray(), cl);
            String adminObjectInterface = adminObject.getAdminobjectInterface().getStringValue().trim();
            adminObjectGBeanData.setAttribute("adminObjectInterface", (Object)adminObjectInterface);
            adminObjectGBeanData.setAttribute("adminObjectClass", (Object)adminObject.getAdminobjectClass().getStringValue().trim());
            adminObjectInfos.put(adminObjectInterface, adminObjectGBeanData);
        }
        return adminObjectInfos;
    }

    private GBeanData setUpDynamicGBean(GBeanInfoBuilder infoBuilder, ConfigPropertyType[] configProperties, ClassLoader cl) throws DeploymentException {
        for (int i = 0; i < configProperties.length; ++i) {
            infoBuilder.addAttribute((GAttributeInfo)new DynamicGAttributeInfo(configProperties[i].getConfigPropertyName().getStringValue().trim(), configProperties[i].getConfigPropertyType().getStringValue().trim(), true, true, true, true));
        }
        GBeanInfo gbeanInfo = infoBuilder.getBeanInfo();
        GBeanData gbeanData = new GBeanData(gbeanInfo);
        for (int i = 0; i < configProperties.length; ++i) {
            if (!configProperties[i].isSetConfigPropertyValue()) continue;
            gbeanData.setAttribute(configProperties[i].getConfigPropertyName().getStringValue(), this.getValue(configProperties[i].getConfigPropertyType().getStringValue(), configProperties[i].getConfigPropertyValue().getStringValue(), cl));
        }
        return gbeanData;
    }

    private void setDynamicGBeanDataAttributes(GBeanData gbeanData, GerConfigPropertySettingType[] configProperties, ClassLoader cl) throws DeploymentException {
        try {
            for (int i = 0; i < configProperties.length; ++i) {
                String name = configProperties[i].getName();
                GAttributeInfo attributeInfo = gbeanData.getGBeanInfo().getAttribute(name);
                if (attributeInfo == null) {
                    throw new DeploymentException("The plan is trying to set attribute: " + name + " which does not exist.  Known attributs are: " + gbeanData.getGBeanInfo().getAttributes());
                }
                String type = attributeInfo.getType();
                gbeanData.setAttribute(name, this.getValue(type, configProperties[i].getStringValue().trim(), cl));
            }
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private Object getValue(String type, String value, ClassLoader cl) throws DeploymentException {
        Class<?> clazz;
        if (value == null) {
            return null;
        }
        try {
            clazz = cl.loadClass(type);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException("Could not load attribute class:  type: " + type, (Throwable)e);
        }
        if (value.equals("") && (Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz))) {
            return null;
        }
        PropertyEditor editor = PropertyEditors.getEditor(clazz);
        editor.setAsText(value);
        return editor.getValue();
    }

    private ObjectName configureConnectionManager(EARContext earContext, J2eeContext j2eeContext, String ddTransactionSupport, GerConnectiondefinitionInstanceType connectionfactoryInstance, ClassLoader cl) throws DeploymentException {
        GerSinglepoolType pool;
        GBeanInfo gbeanInfo;
        ObjectName connectionManagerObjectName = null;
        try {
            connectionManagerObjectName = NameFactory.getComponentName(null, null, null, null, null, (String)connectionfactoryInstance.getName(), (String)"JCAConnectionManager", (J2eeContext)j2eeContext);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Could not construct connection manager object name", (Throwable)e);
        }
        try {
            gbeanInfo = GBeanInfo.getGBeanInfo((String)"org.apache.geronimo.connector.outbound.GenericConnectionManagerGBean", (ClassLoader)cl);
        }
        catch (InvalidConfigurationException e) {
            throw new DeploymentException("Unable to create GMBean", (Throwable)e);
        }
        GBeanData connectionManagerGBean = new GBeanData(connectionManagerObjectName, gbeanInfo);
        GerConnectionmanagerType connectionManager = connectionfactoryInstance.getConnectionmanager();
        TransactionSupport transactionSupport = null;
        if (connectionManager.isSetNoTransaction()) {
            transactionSupport = NoTransactions.INSTANCE;
        } else if (connectionManager.isSetLocalTransaction()) {
            transactionSupport = LocalTransactions.INSTANCE;
        } else if (connectionManager.isSetTransactionLog()) {
            transactionSupport = TransactionLog.INSTANCE;
        } else if (connectionManager.isSetXaTransaction()) {
            transactionSupport = new XATransactions(connectionManager.getXaTransaction().isSetTransactionCaching(), connectionManager.getXaTransaction().isSetThreadCaching());
        } else if ("NoTransaction".equals(ddTransactionSupport)) {
            transactionSupport = NoTransactions.INSTANCE;
        } else if ("LocalTransaction".equals(ddTransactionSupport)) {
            transactionSupport = LocalTransactions.INSTANCE;
        } else if ("XATransaction".equals(ddTransactionSupport)) {
            transactionSupport = new XATransactions(this.defaultXATransactionCaching, this.defaultXAThreadCaching);
        } else {
            throw new DeploymentException("Unexpected transaction support element");
        }
        NoPool pooling = null;
        if (connectionManager.getSinglePool() != null) {
            pool = connectionManager.getSinglePool();
            pooling = new SinglePool(pool.isSetMaxSize() ? pool.getMaxSize() : this.defaultMaxSize, pool.isSetMinSize() ? pool.getMinSize() : this.defaultMinSize, pool.isSetBlockingTimeoutMilliseconds() ? pool.getBlockingTimeoutMilliseconds() : this.defaultBlockingTimeoutMilliseconds, pool.isSetIdleTimeoutMinutes() ? pool.getIdleTimeoutMinutes() : this.defaultIdleTimeoutMinutes, pool.getMatchOne() != null, pool.getMatchAll() != null, pool.getSelectOneAssumeMatch() != null);
        } else if (connectionManager.getPartitionedPool() != null) {
            pool = connectionManager.getPartitionedPool();
            pooling = new PartitionedPool(pool.isSetMaxSize() ? pool.getMaxSize() : this.defaultMaxSize, pool.isSetMinSize() ? pool.getMinSize() : this.defaultMinSize, pool.isSetBlockingTimeoutMilliseconds() ? pool.getBlockingTimeoutMilliseconds() : this.defaultBlockingTimeoutMilliseconds, pool.isSetIdleTimeoutMinutes() ? pool.getIdleTimeoutMinutes() : this.defaultIdleTimeoutMinutes, pool.getMatchOne() != null, pool.getMatchAll() != null, pool.getSelectOneAssumeMatch() != null, pool.isSetPartitionByConnectionrequestinfo(), pool.isSetPartitionBySubject());
        } else if (connectionManager.getNoPool() != null) {
            pooling = new NoPool();
        } else {
            throw new DeploymentException("Unexpected pooling support element");
        }
        try {
            connectionManagerGBean.setAttribute("transactionSupport", (Object)transactionSupport);
            connectionManagerGBean.setAttribute("pooling", (Object)pooling);
            connectionManagerGBean.setReferencePattern("ConnectionTracker", earContext.getConnectionTrackerObjectName());
            connectionManagerGBean.setAttribute("containerManagedSecurity", (Object)new Boolean(connectionManager.isSetContainerManagedSecurity()));
            connectionManagerGBean.setReferencePattern("TransactionContextManager", earContext.getTransactionContextManagerObjectName());
        }
        catch (Exception e) {
            throw new DeploymentException("Problem setting up ConnectionManager", (Throwable)e);
        }
        earContext.addGBean(connectionManagerGBean);
        return connectionManagerObjectName;
    }

    private void addOutboundGBeans(EARContext earContext, J2eeContext j2eeContext, ObjectName resourceAdapterObjectName, GBeanData managedConnectionFactoryPrototypeGBeanData, GerConnectiondefinitionInstanceType connectiondefinitionInstance, String transactionSupport, ClassLoader cl) throws DeploymentException {
        GBeanData managedConnectionFactoryInstanceGBeanData = new GBeanData(managedConnectionFactoryPrototypeGBeanData);
        ObjectName connectionManagerObjectName = this.configureConnectionManager(earContext, j2eeContext, transactionSupport, connectiondefinitionInstance, cl);
        this.setDynamicGBeanDataAttributes(managedConnectionFactoryInstanceGBeanData, connectiondefinitionInstance.getConfigPropertySettingArray(), cl);
        try {
            if (resourceAdapterObjectName != null) {
                managedConnectionFactoryInstanceGBeanData.setReferencePattern("ResourceAdapterWrapper", resourceAdapterObjectName);
            }
            managedConnectionFactoryInstanceGBeanData.setReferencePattern("ConnectionManagerContainer", connectionManagerObjectName);
            String[] implementedInterfaces = connectiondefinitionInstance.getImplementedInterfaceArray();
            if (implementedInterfaces != null) {
                for (int i = 0; i < implementedInterfaces.length; ++i) {
                    implementedInterfaces[i] = implementedInterfaces[i].trim();
                }
            } else {
                implementedInterfaces = new String[]{};
            }
            managedConnectionFactoryInstanceGBeanData.setAttribute("implementedInterfaces", (Object)implementedInterfaces);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
        ObjectName managedConnectionFactoryObjectName = null;
        try {
            managedConnectionFactoryObjectName = NameFactory.getComponentName(null, null, null, null, null, (String)connectiondefinitionInstance.getName(), (String)"JCAManagedConnectionFactory", (J2eeContext)j2eeContext);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Could not construct managed connection factory object name", (Throwable)e);
        }
        managedConnectionFactoryInstanceGBeanData.setName(managedConnectionFactoryObjectName);
        earContext.addGBean(managedConnectionFactoryInstanceGBeanData);
        ObjectName connectionFactoryObjectName = null;
        try {
            connectionFactoryObjectName = NameFactory.getComponentName(null, null, null, null, null, (String)connectiondefinitionInstance.getName(), (String)"JCAConnectionFactory", (J2eeContext)j2eeContext);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Could not construct connection factory object name", (Throwable)e);
        }
        GBeanData connectionFactoryGBeanData = new GBeanData(connectionFactoryObjectName, JCAConnectionFactoryImplGBean.GBEAN_INFO);
        connectionFactoryGBeanData.setReferencePattern("J2EEServer", earContext.getServerObjectName());
        connectionFactoryGBeanData.setAttribute("managedConnectionFactory", (Object)managedConnectionFactoryObjectName.getCanonicalName());
        earContext.addGBean(connectionFactoryGBeanData);
    }

    public Reference createResourceRef(String containerId, Class iface) throws DeploymentException {
        return new ResourceReference(containerId, iface);
    }

    public Reference createAdminObjectRef(String containerId, Class iface) throws DeploymentException {
        return new ResourceReference(containerId, iface);
    }

    public GBeanData locateActivationSpecInfo(GBeanData resourceAdapterModuleData, String messageListenerInterface) throws DeploymentException {
        Map activationSpecInfos = (Map)resourceAdapterModuleData.getAttribute("activationSpecInfoMap");
        if (activationSpecInfos == null) {
            throw new DeploymentException("No activation spec info map found in resource adapter module: " + resourceAdapterModuleData.getName());
        }
        return (GBeanData)activationSpecInfos.get(messageListenerInterface);
    }

    public GBeanData locateResourceAdapterGBeanData(GBeanData resourceAdapterModuleData) throws DeploymentException {
        GBeanData data = (GBeanData)resourceAdapterModuleData.getAttribute("resourceAdapterGBeanData");
        if (data == null) {
            throw new DeploymentException("No resource adapter info found for resource adapter module: " + resourceAdapterModuleData.getName());
        }
        return data;
    }

    public GBeanData locateAdminObjectInfo(GBeanData resourceAdapterModuleData, String adminObjectInterfaceName) throws DeploymentException {
        Map adminObjectInfos = (Map)resourceAdapterModuleData.getAttribute("adminObjectInfoMap");
        if (adminObjectInfos == null) {
            throw new DeploymentException("No admin object infos found for resource adapter module: " + resourceAdapterModuleData.getName());
        }
        return (GBeanData)adminObjectInfos.get(adminObjectInterfaceName);
    }

    public GBeanData locateConnectionFactoryInfo(GBeanData resourceAdapterModuleData, String connectionFactoryInterfaceName) throws DeploymentException {
        Map managedConnectionFactoryInfos = (Map)resourceAdapterModuleData.getAttribute("managedConnectionFactoryInfoMap");
        if (managedConnectionFactoryInfos == null) {
            throw new DeploymentException("No managed connection factory infos found for resource adapter module: " + resourceAdapterModuleData.getName());
        }
        return (GBeanData)managedConnectionFactoryInfos.get(connectionFactoryInterfaceName);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !ConnectorModuleBuilder.class.desiredAssertionStatus();
        CONNECTOR_QNAME = GerConnectorDocument.type.getDocumentElementName();
        GERCONNECTOR_NAMESPACE = CONNECTOR_QNAME.getNamespaceURI();
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)ConnectorModuleBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultParentId", URI;.class, true, true);
        infoBuilder.addAttribute("defaultMaxSize", Integer.TYPE, true, true);
        infoBuilder.addAttribute("defaultMinSize", Integer.TYPE, true, true);
        infoBuilder.addAttribute("defaultBlockingTimeoutMilliseconds", Integer.TYPE, true, true);
        infoBuilder.addAttribute("defaultIdleTimeoutMinutes", Integer.TYPE, true, true);
        infoBuilder.addAttribute("defaultXATransactionCaching", Boolean.TYPE, true, true);
        infoBuilder.addAttribute("defaultXAThreadCaching", Boolean.TYPE, true, true);
        infoBuilder.addReference("Repository", Repository.class, "GBean");
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addInterface(ModuleBuilder.class);
        infoBuilder.addInterface(ResourceReferenceBuilder.class);
        infoBuilder.setConstructor(new String[]{"defaultParentId", "defaultMaxSize", "defaultMinSize", "defaultBlockingTimeoutMilliseconds", "defaultIdleTimeoutMinutes", "defaultXATransactionCaching", "defaultXAThreadCaching", "Repository", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

