/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.client;

import java.util.Iterator;
import java.util.Map;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.geronimo.client.AppClientPlugin;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.naming.enc.EnterpriseNamingContext;
import org.apache.geronimo.naming.java.RootContext;
import org.apache.geronimo.naming.reference.ClassLoaderAwareReference;
import org.apache.geronimo.naming.reference.KernelAwareReference;

public class StaticJndiContextPlugin
implements AppClientPlugin {
    private final Context context;
    public static final GBeanInfo GBEAN_INFO;

    public StaticJndiContextPlugin(Map context, Kernel kernel, ClassLoader classLoader) throws NamingException {
        Iterator iterator = context.values().iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value instanceof KernelAwareReference) {
                ((KernelAwareReference)value).setKernel(kernel);
            }
            if (!(value instanceof ClassLoaderAwareReference)) continue;
            ((ClassLoaderAwareReference)value).setClassLoader(classLoader);
        }
        this.context = EnterpriseNamingContext.createEnterpriseNamingContext((Map)context);
    }

    public void startClient(ObjectName appClientModuleName, Kernel kernel, ClassLoader classLoader) throws Exception {
        RootContext.setComponentContext((Context)this.context);
        System.setProperty("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "org.apache.geronimo.naming");
        new InitialContext().lookup("java:comp/env");
    }

    public void stopClient(ObjectName appClientModuleName) throws Exception {
        RootContext.setComponentContext(null);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)StaticJndiContextPlugin.class);
        infoFactory.addAttribute("context", Map.class, true);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addInterface(AppClientPlugin.class);
        infoFactory.setConstructor(new String[]{"context", "kernel", "classLoader"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

