/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.codegen.CollectionsRegistry;
import fr.xebia.extras.selma.codegen.InOutType;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import fr.xebia.extras.selma.codegen.MappingSourceNode;
import fr.xebia.extras.selma.codegen.ProcessorUtils;
import fr.xebia.extras.selma.codegen.SourceNodeVars;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor6;

public abstract class MappingBuilder {
    public static final String JAVA_TIME_LOCAL_DATE_CLASS = "java.time.LocalDate";
    public static final String JAVA_TIME_DURATION_CLASS = "java.time.Duration";
    public static final String JAVA_TIME_INSTANT_CLASS = "java.time.Instant";
    public static final String JAVA_TIME_LOCAL_DATE_TIME_CLASS = "java.time.LocalDateTime";
    private static final List<MappingSpecification> mappingSpecificationList = new LinkedList<MappingSpecification>();
    private static final Set<String> immutableTypes = new HashSet<String>(Arrays.asList(BigInteger.class.getName(), BigDecimal.class.getName(), UUID.class.getName(), "java.time.LocalDate", "java.time.Duration", "java.time.Instant", "java.time.LocalDateTime", "java.time.LocalTime", "java.time.MonthDay", "java.time.OffsetDateTime", "java.time.OffsetTime", "java.time.Period", "java.time.Year", "java.time.YearMonth", "java.time.ZonedDateTime", "java.time.ZoneOffset"));
    MappingSourceNode root;
    private boolean nullSafe = false;

    private MappingBuilder() {
        this.root = MappingSourceNode.blank();
    }

    private MappingBuilder(boolean nullSafe) {
        this.nullSafe = nullSafe;
        this.root = MappingSourceNode.blank();
    }

    private static boolean areMatchingBoxedToPrimitive(InOutType inOutType, MapperGeneratorContext context) {
        boolean res = false;
        if (inOutType.isDeclaredToPrimitive()) {
            PrimitiveType inAsPrimitive = MappingBuilder.getUnboxedPrimitive(inOutType.inAsDeclaredType(), context);
            res = inAsPrimitive != null && inAsPrimitive.getKind() == inOutType.outKind();
        }
        return res;
    }

    private static boolean isMatchingPrimitiveToBoxed(InOutType inOutType, MapperGeneratorContext context) {
        boolean res = false;
        if (inOutType.isPrimitiveToDeclared()) {
            PrimitiveType outAsPrimitive = MappingBuilder.getUnboxedPrimitive(inOutType.outAsDeclaredType(), context);
            res = outAsPrimitive != null && outAsPrimitive.getKind() == inOutType.inKind();
        }
        return res;
    }

    private static Map.Entry<TypeMirror, Integer> getArrayDimensionsAndType(ArrayType arrayType) {
        int res = 1;
        ArrayType type = arrayType;
        while (type.getComponentType().getKind() == TypeKind.ARRAY) {
            ++res;
            type = (ArrayType)type.getComponentType();
        }
        return new AbstractMap.SimpleEntry<TypeMirror, Integer>(type.getComponentType(), res);
    }

    public static MappingBuilder getBuilderFor(MapperGeneratorContext context, final InOutType inOutType) {
        if (context.types().isSameType(context.getObjectType(), inOutType.in())) {
            return null;
        }
        MappingBuilder res = null;
        for (MappingSpecification specification : mappingSpecificationList) {
            if (!specification.match(context, inOutType)) continue;
            res = specification.getBuilder(context, inOutType);
            break;
        }
        if (res == null && inOutType.areDeclared() && context.depth > 0) {
            res = new MappingBuilder(true){

                @Override
                MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                    this.setOrAssignNestedBean(context, vars, inOutType);
                    return this.root.body;
                }
            };
        }
        return res;
    }

    public static List<String> collectEnumValues(TypeElement typeElement) {
        ArrayList<String> res = new ArrayList<String>();
        List<? extends Element> elementInList = typeElement.getEnclosedElements();
        for (Element element : ElementFilter.fieldsIn(elementInList)) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT || element.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            res.add(element.getSimpleName().toString());
        }
        return res;
    }

    private static boolean isMap(DeclaredType declaredType, MapperGeneratorContext context) {
        TypeElement typeElement1 = context.elements.getTypeElement("java.util.Map");
        DeclaredType declaredType2 = context.type.getDeclaredType(typeElement1, context.type.getWildcardType(null, null), context.type.getWildcardType(null, null));
        return context.type.isAssignable(declaredType, declaredType2);
    }

    public static boolean isCollection(DeclaredType declaredType, MapperGeneratorContext context) {
        TypeElement typeElement1 = context.elements.getTypeElement("java.util.Collection");
        DeclaredType declaredType2 = context.type.getDeclaredType(typeElement1, context.type.getWildcardType(null, null));
        return declaredType != null && context.type.isAssignable(declaredType, declaredType2);
    }

    private static boolean isBoxedPrimitive(DeclaredType declaredType, MapperGeneratorContext context) {
        return MappingBuilder.getUnboxedPrimitive(declaredType, context) != null;
    }

    private static PrimitiveType getUnboxedPrimitive(DeclaredType declaredType, MapperGeneratorContext context) {
        PrimitiveType res = null;
        PackageElement typePackage = context.elements.getPackageOf(declaredType.asElement());
        PackageElement javaLang = context.elements.getPackageElement("java.lang");
        if (typePackage.getSimpleName().equals(javaLang.getSimpleName())) {
            try {
                res = context.type.unboxedType(declaredType);
            }
            catch (IllegalArgumentException ignored) {
                // empty catch block
            }
        }
        return res;
    }

    private static MappingSourceNode notNullInField(SourceNodeVars vars) {
        return MappingSourceNode.controlNotNull(vars.inGetter());
    }

    public static MappingBuilder newCustomMapperImmutableForUpdateGraph(final InOutType inOutType, final String name) {
        return new MappingBuilder(true){

            @Override
            MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                context.mappingMethod(inOutType, name);
                this.root.body(vars.setOrAssignWithOutPut(String.format("%s(%%s, %%s)", name)));
                return this.root.body;
            }
        };
    }

    public static MappingBuilder newCustomMapper(final InOutType inOutType, final String name) {
        return new MappingBuilder(true){

            @Override
            MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                context.mappingMethod(inOutType, name);
                if (inOutType.isOutPutAsParam()) {
                    this.root.body(vars.setOrAssignWithOutPut(String.format("%s(%%s, %%s)", name)));
                } else {
                    this.root.body(vars.setOrAssign(String.format("%s(%%s)", name)));
                }
                return this.root.body;
            }
        };
    }

    public static MappingBuilder newMappingInterceptor(final List<InOutType> inOutTypes, final String name) {
        return new MappingBuilder(){

            @Override
            MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                StringBuilder buff = new StringBuilder(name).append('(');
                if (inOutTypes.size() >= 1 && vars.field == null) {
                    for (InOutType inOutType : inOutTypes) {
                        buff.append(ProcessorUtils.getInVar(inOutType.in())).append(", ");
                    }
                }
                if (vars.field != null && vars.outFieldGetter != null) {
                    this.root.body(MappingSourceNode.statement(String.format(buff.append("%s, %s())").toString(), vars.inField, vars.outFieldGetter)));
                } else {
                    this.root.body(MappingSourceNode.statement(buff.append("out)").toString()));
                }
                return this.root.body;
            }
        };
    }

    public static MappingBuilder newCustomEnumMapper(final InOutType inOutType, final String defaultValue) {
        TypeElement typeElement = inOutType.inAsTypeElement();
        List<String> enumInValues = MappingBuilder.collectEnumValues(typeElement);
        List<String> enumOutValues = MappingBuilder.collectEnumValues(inOutType.outAsTypeElement());
        final List<String> valuesIntersection = MappingBuilder.intersection(enumInValues, enumOutValues);
        return new MappingBuilder(){

            @Override
            MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                if (context.depth > 0) {
                    String mappingMethod = context.mappingMethod(inOutType);
                    if (context.getWrapper().isUseCyclicMapping()) {
                        this.root.body(vars.setOrAssign(String.format("%s(%%s, %s)", mappingMethod, "instanceCache")));
                    } else {
                        this.root.body(vars.setOrAssign(String.format("%s(%%s)", mappingMethod)));
                    }
                } else {
                    MappingSourceNode node;
                    MappingSourceNode valuesBlock = node = MappingSourceNode.blank();
                    for (String value : valuesIntersection) {
                        node = node.child(MappingSourceNode.mapEnumCase(value));
                        node.body(vars.setOrAssign(String.format("%s.%s", inOutType.out(), value)));
                    }
                    node = node.child(MappingSourceNode.mapDefaultCase());
                    if ("".equals(defaultValue)) {
                        node.body(vars.setOrAssign("null"));
                    } else {
                        node.body(vars.setOrAssign(String.format("%s.%s", inOutType.out(), defaultValue)));
                    }
                    this.root.body(MappingSourceNode.mapEnumBlock(vars.inGetter())).body(valuesBlock.child);
                }
                return this.root.body;
            }
        };
    }

    private static TypeMirror getTypeArgument(final MapperGeneratorContext context, TypeMirror type, final int index) {
        return type.accept(new SimpleTypeVisitor6<TypeMirror, Void>(){

            @Override
            public TypeMirror visitDeclared(DeclaredType t, Void p) {
                if (t.getTypeArguments().size() > 0) {
                    TypeMirror type = t.getTypeArguments().get(index);
                    if (type.getKind() == TypeKind.TYPEVAR) {
                        TypeMirror typeVar = ((TypeVariable)type).getLowerBound();
                        type = typeVar.getKind().equals((Object)TypeKind.NULL) ? ((TypeVariable)type).getUpperBound() : typeVar;
                    }
                    return type;
                }
                TypeMirror superclass = ((TypeElement)t.asElement()).getSuperclass();
                return MappingBuilder.getTypeArgument(context, superclass, index);
            }
        }, null);
    }

    public static <T> List<T> intersection(List<T> list1, List<T> list2) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    public static MappingBuilder newImmutable() {
        return new MappingBuilder(true){

            @Override
            MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                this.root.body(vars.setOrAssign("%s"));
                return this.root.body;
            }
        };
    }

    protected void setOrAssignNestedBean(MapperGeneratorContext context, SourceNodeVars vars, InOutType inOutType) {
        String mappingMethod = context.mappingMethod(inOutType);
        if (context.getWrapper().isUseCyclicMapping()) {
            if (inOutType.isOutPutAsParam()) {
                this.root.body(vars.setOrAssignWithOutPut(String.format("%s(%%s, %%s, %s)", mappingMethod, "instanceCache")));
            } else {
                this.root.body(vars.setOrAssign(String.format("%s(%%s, %s)", mappingMethod, "instanceCache")));
            }
        } else if (inOutType.isOutPutAsParam()) {
            this.root.body(vars.setOrAssignWithOutPut(String.format("%s(%%s, %%s)", mappingMethod)));
        } else {
            this.root.body(vars.setOrAssign(String.format("%s(%%s)", mappingMethod)));
        }
    }

    abstract MappingSourceNode buildNodes(MapperGeneratorContext var1, SourceNodeVars var2) throws IOException;

    public MappingSourceNode build(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
        this.root = MappingSourceNode.blank();
        MappingSourceNode ptr = this.buildNodes(context, vars);
        if (context.depth > 0 && !this.nullSafe) {
            this.root = MappingBuilder.notNullInField(vars);
            this.root.body(ptr);
            if (!vars.isOutPrimitive() && !vars.useGetterForDestination) {
                this.root.child(MappingSourceNode.controlNullElse()).body(vars.setOrAssign("null"));
            }
            return this.root;
        }
        if (context.isIgnoreNullValue() && !vars.isOutPrimitive()) {
            this.root = MappingBuilder.notNullInField(vars);
            this.root.body(ptr);
            return this.root;
        }
        return this.buildNodes(context, vars);
    }

    public boolean isNullSafe() {
        return this.nullSafe;
    }

    static {
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, InOutType inOutType) {
                return new MappingBuilder(true){

                    @Override
                    public MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        if (context.depth > 0) {
                            this.root.body(MappingSourceNode.set(vars.outSetterPath(), vars.inGetter()));
                        } else {
                            this.root.body(MappingSourceNode.assignOutPrime(vars.inField));
                        }
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return inOutType.areSamePrimitive() || MappingBuilder.areMatchingBoxedToPrimitive(inOutType, context);
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, InOutType inOutType) {
                return new MappingBuilder(true){

                    @Override
                    public MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        if (context.depth > 0) {
                            this.root.body(MappingSourceNode.set(vars.outSetterPath(), vars.inGetter() + " + \"\""));
                        } else {
                            this.root.body(MappingSourceNode.assignOutToString(vars.inField));
                        }
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                boolean res = false;
                if (inOutType.outIsDeclared() && String.class.getName().equals(inOutType.outAsDeclaredType().toString())) {
                    res = inOutType.inIsDeclared() ? MappingBuilder.isBoxedPrimitive(inOutType.inAsDeclaredType(), context) : inOutType.inIsPrimitive();
                }
                return res;
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, final InOutType inOutType) {
                TypeElement typeElement = inOutType.inAsTypeElement();
                final List<String> enumValues = MappingBuilder.collectEnumValues(typeElement);
                return new MappingBuilder(true){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        if (context.depth > 0) {
                            String mappingMethod = context.mappingMethod(inOutType);
                            if (context.getWrapper().isUseCyclicMapping()) {
                                this.root.body(vars.setOrAssign(String.format("%s(%%s, %s)", mappingMethod, "instanceCache")));
                            } else {
                                this.root.body(vars.setOrAssign(String.format("%s(%%s)", mappingMethod)));
                            }
                        } else {
                            MappingSourceNode node;
                            MappingSourceNode valuesBlock = node = MappingSourceNode.blank();
                            for (String value : enumValues) {
                                node = node.child(MappingSourceNode.mapEnumCase(value));
                                node.body(vars.setOrAssign(String.format("%s.%s", inOutType.out(), value)));
                            }
                            this.root.body(MappingSourceNode.mapEnumBlock(vars.inGetter())).body(valuesBlock.child);
                        }
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return inOutType.areDeclared() && inOutType.areEnums() && !inOutType.areSameDeclared();
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, InOutType inOutType) {
                return new MappingBuilder(true){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        this.root.body(vars.setOrAssign("%s"));
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return inOutType.areDeclared() && inOutType.areEnums() && inOutType.areSameDeclared();
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, InOutType inOutType) {
                return new MappingBuilder(true){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        this.root.body(vars.setOrAssign("%s"));
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                DeclaredType declaredType;
                boolean res = inOutType.areSameDeclared() ? MappingBuilder.isBoxedPrimitive(declaredType = inOutType.inAsDeclaredType(), context) || String.class.getName().equals(declaredType.toString()) : MappingBuilder.isMatchingPrimitiveToBoxed(inOutType, context);
                return res;
            }
        });
        mappingSpecificationList.add(new SameDeclaredMappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, InOutType inOutType) {
                return new MappingBuilder(){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        this.root.body(vars.setOrAssign("new java.util.Date(%s.getTime())"));
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return super.match(context, inOutType) && Date.class.getName().equals(inOutType.in().toString());
            }
        });
        mappingSpecificationList.add(new SameDeclaredMappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, InOutType inOutType) {
                return new MappingBuilder(true){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        this.root.body(vars.setOrAssign("%s"));
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                if (super.match(context, inOutType)) {
                    String inType = inOutType.in().toString();
                    return immutableTypes.contains(inType);
                }
                return false;
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return inOutType.areDeclared() && MappingBuilder.isCollection(inOutType.inAsDeclaredType(), context) && MappingBuilder.isCollection(inOutType.outAsDeclaredType(), context);
            }

            @Override
            MappingBuilder getBuilder(final MapperGeneratorContext context, final InOutType inOutType) {
                final TypeMirror genericIn = MappingBuilder.getTypeArgument(context, inOutType.inAsDeclaredType(), 0);
                if (genericIn == null) {
                    return null;
                }
                final TypeMirror genericOut = MappingBuilder.getTypeArgument(context, inOutType.outAsDeclaredType(), 0);
                String impl = inOutType.outAsTypeElement().getKind() == ElementKind.CLASS ? inOutType.out().toString() : CollectionsRegistry.findImplementationForType(inOutType.outAsTypeElement()) + (genericOut == null ? "" : "<" + genericOut.toString() + ">");
                final String implementation = impl;
                TypeElement outElement = context.elements().getTypeElement(impl.replaceAll("<.*>", ""));
                boolean hasSizeCtr = false;
                List<ExecutableElement> constructors = ElementFilter.constructorsIn(context.elements().getAllMembers(outElement));
                for (ExecutableElement constructor : constructors) {
                    if (constructor.getParameters().size() != 1 || constructor.getParameters().get(0).asType().getKind() != TypeKind.INT) continue;
                    hasSizeCtr = true;
                    break;
                }
                final boolean hasSizeConstructor = hasSizeCtr;
                return new MappingBuilder(){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context2, SourceNodeVars vars) throws IOException {
                        MappingSourceNode node;
                        String itemVar = vars.itemVar();
                        String tmpVar = vars.tmpVar("Collection");
                        String arg = hasSizeConstructor ? String.format("%s.size()", vars.inGetter()) : "";
                        if (vars.useGetterForDestination) {
                            node = this.root.body(MappingSourceNode.assign(String.format("%s %s", inOutType.inAsTypeElement(), tmpVar), String.format("%s()", vars.outFieldGetter))).child(MappingSourceNode.mapCollection(itemVar, genericIn.toString(), vars.inGetter()));
                        } else {
                            node = this.root.body(MappingSourceNode.assign(String.format("%s %s", implementation, tmpVar), String.format("new %s(%s)", implementation, arg))).child(MappingSourceNode.mapCollection(itemVar, genericIn.toString(), vars.inGetter()));
                            node.child(vars.setOrAssign(tmpVar));
                        }
                        context2.pushStackForBody(node, new SourceNodeVars().withInOutType(this.createInOutType()).withInField(itemVar).withOutField(String.format("%s.add", tmpVar)).withAssign(false).withIndexPtr(vars.nextPtr()));
                        return this.root.body;
                    }

                    private InOutType createInOutType() {
                        TypeMirror out = genericOut == null ? context.getObjectType() : genericOut;
                        return new InOutType(genericIn, out, false);
                    }
                };
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(final MapperGeneratorContext context, InOutType inOutType) {
                TypeMirror genericOutValue;
                final TypeMirror genericInKey = MappingBuilder.getTypeArgument(context, inOutType.inAsDeclaredType(), 0);
                final TypeMirror genericInValue = MappingBuilder.getTypeArgument(context, inOutType.inAsDeclaredType(), 1);
                if (genericInKey == null || genericInValue == null) {
                    throw new IllegalStateException("input map has no defined arguments");
                }
                final TypeMirror genericOutKey = MappingBuilder.getTypeArgument(context, inOutType.outAsDeclaredType(), 0);
                if (genericOutKey == null ^ (genericOutValue = MappingBuilder.getTypeArgument(context, inOutType.outAsDeclaredType(), 1)) == null) {
                    throw new IllegalStateException("genericOutKey and genericOutValue must both be null or non-null");
                }
                String impl = inOutType.outAsTypeElement().getKind() == ElementKind.CLASS ? inOutType.out().toString() : CollectionsRegistry.findImplementationForType(inOutType.outAsTypeElement()) + (genericOutKey == null ? "" : "<" + genericOutKey.toString() + ", " + genericOutValue.toString() + ">");
                final String implementation = impl;
                return new MappingBuilder(){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context2, SourceNodeVars vars) throws IOException {
                        String itemVar = vars.itemEntry();
                        String tmpVar = vars.tmpVar("Map");
                        String keyVar = vars.tmpVar("Key");
                        MappingSourceNode node = this.root.body(MappingSourceNode.assign(String.format("%s %s", implementation, tmpVar), String.format("new %s()", implementation))).child(vars.setOrAssign(tmpVar)).child(MappingSourceNode.mapMap(itemVar, genericInKey.toString(), genericInValue.toString(), vars.inGetter())).body(MappingSourceNode.assign(String.format("%s %s", genericOutKey == null ? "Object" : genericOutKey, keyVar), "null"));
                        context2.pushStackForChild(node, new SourceNodeVars().withInOutType(this.createInOutType(genericInValue, genericOutValue)).withInField(String.format("%s.getValue()", itemVar)).withInFieldPrefix(String.format("%s,", keyVar)).withOutField(String.format("%s.put", tmpVar)).withAssign(false).withIndexPtr(vars.nextPtr()));
                        context2.pushStackForChild(node, new SourceNodeVars().withInOutType(this.createInOutType(genericInKey, genericOutKey)).withInField(String.format("%s.getKey()", itemVar)).withOutField(keyVar).withAssign(true).withIndexPtr(vars.nextPtr()));
                        return this.root.body;
                    }

                    private InOutType createInOutType(TypeMirror in, TypeMirror out) {
                        if (out == null) {
                            out = context.getObjectType();
                        }
                        return new InOutType(in, out, false);
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return inOutType.areDeclared() && MappingBuilder.isMap(inOutType.inAsDeclaredType(), context) && MappingBuilder.isMap(inOutType.outAsDeclaredType(), context);
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, final InOutType inOutType) {
                return new MappingBuilder(){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        this.root.body(vars.setOrAssign(String.format("new %s[%%s.length]", inOutType.inArrayComponentType()))).child(MappingSourceNode.arrayCopy(vars.inGetter(), vars.outGetter()));
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return inOutType.inIsArray() && inOutType.isInArrayComponentPrimitive() && !inOutType.differs();
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, final InOutType inOutType) {
                return new MappingBuilder(){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        String indexVar = vars.indexVar();
                        String tmpVar = vars.tmpVar("Array");
                        Map.Entry dims = MappingBuilder.getArrayDimensionsAndType(inOutType.outAsArrayType());
                        String totalCountVar = vars.totalCountVar();
                        String totalCountVal = String.format("%s.length", vars.inGetter());
                        String newArray = String.format("new %s[%s.length]", dims.getKey(), vars.inGetter());
                        for (int i = 1; i < (Integer)dims.getValue(); ++i) {
                            newArray = newArray + "[]";
                        }
                        MappingSourceNode node = this.root.body(MappingSourceNode.assign(String.format("%s %s", inOutType.out().toString(), tmpVar), newArray)).child(MappingSourceNode.assign("int " + totalCountVar, totalCountVal)).child(vars.setOrAssign(tmpVar)).child(MappingSourceNode.mapArrayBis(indexVar, totalCountVar));
                        context.pushStackForBody(node, new SourceNodeVars().withInOutType(new InOutType(inOutType.inArrayComponentType(), inOutType.outArrayComponentType(), false)).withInField(String.format("%s[%s]", vars.inGetter(), indexVar)).withOutField(String.format("%s[%s]", tmpVar, indexVar)).withAssign(true).withIndexPtr(vars.nextPtr()));
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return inOutType.inIsArray() && inOutType.isInArrayComponentDeclaredOrArray();
            }
        });
        mappingSpecificationList.add(new MappingSpecification(){

            @Override
            MappingBuilder getBuilder(MapperGeneratorContext context, InOutType inOutType) {
                return new MappingBuilder(true){

                    @Override
                    MappingSourceNode buildNodes(MapperGeneratorContext context, SourceNodeVars vars) throws IOException {
                        this.root.body(vars.setOrAssign("%s"));
                        return this.root.body;
                    }
                };
            }

            @Override
            boolean match(MapperGeneratorContext context, InOutType inOutType) {
                return context.types().isAssignable(inOutType.in(), inOutType.out()) && context.isValueType(inOutType.in());
            }
        });
    }

    static abstract class SameDeclaredMappingSpecification
    extends MappingSpecification {
        SameDeclaredMappingSpecification() {
        }

        @Override
        boolean match(MapperGeneratorContext context, InOutType inOutType) {
            return !inOutType.differs() && inOutType.areDeclared();
        }
    }

    static abstract class MappingSpecification {
        MappingSpecification() {
        }

        abstract MappingBuilder getBuilder(MapperGeneratorContext var1, InOutType var2);

        abstract boolean match(MapperGeneratorContext var1, InOutType var2);
    }
}

