/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.codegen.InOutType;
import fr.xebia.extras.selma.codegen.MapperWrapper;
import fr.xebia.extras.selma.codegen.MappingSourceNode;
import fr.xebia.extras.selma.codegen.SourceNodeVars;
import fr.xebia.extras.selma.codegen.compiler.CompilerMessageRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class MapperGeneratorContext {
    public final List<TypeElement> sources;
    private final ProcessingEnvironment processingEnv;
    private final CompilerMessageRegistry messageRegistry;
    int depth = 0;
    final Elements elements;
    final Types type;
    LinkedList<StackElem> stack;
    LinkedList<MappingMethod> methodStack;
    private boolean ignoreNullValue = false;
    private HashMap<String, MappingMethod> mappingRegistry;
    private String newParams;
    private MapperWrapper wrapper;
    private final DeclaredType objectType;
    private final TypeVisitor<Boolean, MapperGeneratorContext> isValueTypeVisitor;

    public MapperGeneratorContext(ProcessingEnvironment processingEnvironment) {
        this.elements = processingEnvironment.getElementUtils();
        this.type = processingEnvironment.getTypeUtils();
        this.stack = new LinkedList();
        this.processingEnv = processingEnvironment;
        this.mappingRegistry = new HashMap();
        this.methodStack = new LinkedList();
        this.messageRegistry = new CompilerMessageRegistry();
        this.sources = new ArrayList<TypeElement>();
        this.objectType = this.type.getDeclaredType(this.elements.getTypeElement("java.lang.Object"), new TypeMirror[0]);
        this.isValueTypeVisitor = new SimpleTypeVisitor6<Boolean, MapperGeneratorContext>(){
            private final DeclaredType enumType;
            private final DeclaredType numberType;
            private final DeclaredType stringType;
            private final DeclaredType booleanType;
            private final DeclaredType characterType;
            {
                this.enumType = MapperGeneratorContext.this.getDeclaredType("java.lang.Enum");
                this.numberType = MapperGeneratorContext.this.getDeclaredType("java.lang.Number");
                this.stringType = MapperGeneratorContext.this.getDeclaredType("java.lang.String");
                this.booleanType = MapperGeneratorContext.this.getDeclaredType("java.lang.Boolean");
                this.characterType = MapperGeneratorContext.this.getDeclaredType("java.lang.Character");
            }

            @Override
            public Boolean visitDeclared(DeclaredType t, MapperGeneratorContext ctx) {
                return ctx.types().isSubtype(t, this.enumType) || ctx.types().isSubtype(t, this.numberType) || ctx.types().isSameType(t, this.stringType) || ctx.types().isSameType(t, this.booleanType) || ctx.types().isSameType(t, this.characterType);
            }

            @Override
            public Boolean visitPrimitive(PrimitiveType t, MapperGeneratorContext ctx) {
                return true;
            }
        };
    }

    public void error(Element element, String templateMessage, Object ... args) {
        this.message(Diagnostic.Kind.ERROR, element, templateMessage, args);
    }

    public void warn(Element element, String templateMessage, Object ... args) {
        this.message(Diagnostic.Kind.WARNING, element, templateMessage, args);
    }

    private void message(Diagnostic.Kind kind, Element element, String templateMessage, Object ... args) {
        if (this.messageRegistry.hasMessageFor(kind, element)) {
            this.processingEnv.getMessager().printMessage(kind, String.format(templateMessage, args));
        } else {
            this.processingEnv.getMessager().printMessage(kind, String.format(templateMessage, args), element);
        }
    }

    public void pushStackForBody(MappingSourceNode node, SourceNodeVars vars) {
        this.stack.push(new StackElem(node, vars));
    }

    public void pushStackForChild(MappingSourceNode node, SourceNodeVars vars) {
        this.stack.push(new StackElem(node, vars).withChild(true));
    }

    public StackElem popStack() {
        if (this.stack.size() > 0) {
            return this.stack.pop();
        }
        return null;
    }

    public boolean isIgnoreNullValue() {
        return this.ignoreNullValue;
    }

    public void setIgnoreNullValue(boolean ignoreNullValue) {
        this.ignoreNullValue = ignoreNullValue;
    }

    public void mappingMethod(InOutType inOutType, String name) {
        this.getMappingMethod(inOutType, new MappingMethod(inOutType, name));
    }

    public String mappingMethod(InOutType inOutType) {
        MappingMethod method = this.getMappingMethod(inOutType, new MappingMethod(inOutType));
        return method.name();
    }

    private MappingMethod getMappingMethod(InOutType inOutType, MappingMethod mappingMethod) {
        InOutType key = inOutType;
        MappingMethod method = mappingMethod;
        if (this.mappingRegistry.containsKey(key.toString())) {
            return this.mappingRegistry.get(key.toString());
        }
        if (inOutType.areDeclared() && inOutType.areEnums() && inOutType.isOutPutAsParam()) {
            key = new InOutType(inOutType, false);
            if (this.mappingRegistry.containsKey(key.toString())) {
                return this.mappingRegistry.get(key.toString());
            }
            mappingMethod = new MappingMethod(mappingMethod, key);
        }
        this.methodStack.push(mappingMethod);
        this.mappingRegistry.put(key.toString(), mappingMethod);
        return mappingMethod;
    }

    public boolean hasMappingMethods() {
        return this.mappingRegistry.size() > 0;
    }

    public MappingMethod popMappingMethod() {
        MappingMethod mappingMethod = null;
        if (this.methodStack.size() > 0) {
            mappingMethod = this.methodStack.pop();
            while (this.methodStack.size() > 0 && mappingMethod.built) {
                mappingMethod = this.methodStack.pop();
            }
            if (mappingMethod.built) {
                mappingMethod = null;
            }
        }
        return mappingMethod;
    }

    public Elements elements() {
        return this.elements;
    }

    public Types types() {
        return this.type;
    }

    public void setNewParams(String newParams) {
        this.newParams = newParams;
    }

    public String newParams() {
        return this.newParams;
    }

    public int getSourcesCount() {
        return this.sources.size();
    }

    public TypeElement getTypeElement(String classe) {
        return this.elements.getTypeElement(classe);
    }

    public DeclaredType getDeclaredType(String classe) {
        return this.type.getDeclaredType(this.getTypeElement(classe), new TypeMirror[0]);
    }

    public boolean isValueType(TypeMirror typeMirror) {
        return typeMirror.accept(this.isValueTypeVisitor, this);
    }

    public TypeMirror getObjectType() {
        return this.objectType;
    }

    public void setSources(List<TypeElement> _sources) {
        this.sources.addAll(_sources);
    }

    public List<TypeElement> sources() {
        return this.sources;
    }

    public TypeElement getBoxedClass(PrimitiveType type) {
        return this.processingEnv.getTypeUtils().boxedClass(type);
    }

    public MapperWrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(MapperWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public class MappingMethod {
        private final InOutType inOutType;
        private final String name;
        private boolean built;

        public MappingMethod(InOutType inOutType) {
            this.inOutType = inOutType;
            this.name = String.format("as%s", inOutType.outAsTypeElement().getSimpleName());
            this.built = false;
        }

        public MappingMethod(InOutType inOutType, String name) {
            this.inOutType = inOutType;
            this.name = name;
            this.built = true;
        }

        public MappingMethod(MappingMethod mappingMethod, InOutType key) {
            this.name = mappingMethod.name();
            this.built = mappingMethod.built;
            this.inOutType = key;
        }

        public String name() {
            return this.name;
        }

        public boolean isBuilt() {
            return this.built;
        }

        public void build() {
            this.built = true;
        }

        public String inType() {
            return this.inOutType.in().toString();
        }

        public String outType() {
            return this.inOutType.out().toString();
        }

        public TypeMirror in() {
            return this.inOutType.in();
        }

        public InOutType inOutType() {
            return this.inOutType;
        }
    }

    class StackElem {
        final MappingSourceNode lastNode;
        private final SourceNodeVars vars;
        boolean child = false;

        private StackElem(MappingSourceNode lastNode, SourceNodeVars vars) {
            this.lastNode = lastNode;
            this.vars = vars;
        }

        public SourceNodeVars sourceNodeVars() {
            return this.vars;
        }

        public StackElem withChild(boolean isChild) {
            this.child = isChild;
            return this;
        }
    }
}

