/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.codegen.MapperProcessor;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class InOutType {
    private final TypeMirror in;
    private final TypeMirror out;
    private final boolean outPutAsParam;

    public InOutType(InOutType ioType, boolean outPutAsParam) {
        this.in = ioType.in;
        this.out = ioType.out;
        this.outPutAsParam = outPutAsParam;
    }

    public InOutType(TypeMirror in, TypeMirror out, boolean outPutAsParam) {
        this.in = in;
        this.out = out;
        this.outPutAsParam = outPutAsParam;
        if (in == null || out == null) {
            throw new IllegalArgumentException(String.format("in type %s and out type %s can not be null", in, out));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InOutType inOutType = (InOutType)o;
        if (!MapperProcessor.types.isSameType(this.in, inOutType.in)) {
            return false;
        }
        if (!MapperProcessor.types.isSameType(this.out, inOutType.out)) {
            return false;
        }
        return inOutType.outPutAsParam == this.outPutAsParam;
    }

    public boolean equalsWithoutOutputAsParam(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InOutType inOutType = (InOutType)o;
        if (!MapperProcessor.types.isSameType(this.in, inOutType.in)) {
            return false;
        }
        return MapperProcessor.types.isSameType(this.out, inOutType.out);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InOutType{");
        sb.append("in=").append(this.in);
        sb.append(", out=").append(this.out);
        sb.append(", outPutAsParam=").append(this.outPutAsParam);
        sb.append('}');
        return sb.toString();
    }

    public boolean areSamePrimitive() {
        return this.in.getKind().isPrimitive() && this.in.getKind() == this.out.getKind();
    }

    public boolean areDeclared() {
        return this.in.getKind() == TypeKind.DECLARED && this.out.getKind() == TypeKind.DECLARED;
    }

    public DeclaredType inAsDeclaredType() {
        return (DeclaredType)this.in;
    }

    public TypeElement inAsTypeElement() {
        return (TypeElement)this.inAsDeclaredType().asElement();
    }

    public boolean areEnums() {
        return this.inAsTypeElement().getKind() == ElementKind.ENUM && this.outAsTypeElement().getKind() == ElementKind.ENUM;
    }

    public boolean inIsArray() {
        return this.in.getKind() == TypeKind.ARRAY;
    }

    public ArrayType inAsArrayType() {
        return (ArrayType)this.in;
    }

    public boolean isInArrayComponentPrimitive() {
        return this.inAsArrayType().getComponentType().getKind().isPrimitive();
    }

    public TypeMirror inArrayComponentType() {
        return this.inAsArrayType().getComponentType();
    }

    public boolean isInArrayComponentDeclared() {
        return this.inArrayComponentType().getKind() == TypeKind.DECLARED;
    }

    public TypeMirror in() {
        return this.in;
    }

    public TypeMirror out() {
        return this.out;
    }

    public TypeMirror outArrayComponentType() {
        return this.outAsArrayType().getComponentType();
    }

    public ArrayType outAsArrayType() {
        return (ArrayType)this.out;
    }

    public boolean isInArrayComponentDeclaredOrArray() {
        return this.isInArrayComponentDeclared() || this.inArrayComponentType().getKind() == TypeKind.ARRAY;
    }

    public TypeElement outAsTypeElement() {
        return (TypeElement)((DeclaredType)this.out).asElement();
    }

    public boolean differs() {
        return !this.in.toString().equals(this.out.toString());
    }

    public DeclaredType outAsDeclaredType() {
        return (DeclaredType)this.out;
    }

    public boolean inIsPrimitive() {
        return this.in.getKind().isPrimitive();
    }

    public boolean areSameDeclared() {
        return !this.differs() && this.areDeclared();
    }

    public boolean outIsDeclared() {
        return this.out.getKind() == TypeKind.DECLARED;
    }

    public boolean isPrimitiveToDeclared() {
        return this.inIsPrimitive() && this.outIsDeclared();
    }

    public TypeKind inKind() {
        return this.in.getKind();
    }

    public boolean isDeclaredToPrimitive() {
        return this.outIsPrimitive() && this.inIsDeclared();
    }

    protected boolean outIsPrimitive() {
        return this.out().getKind().isPrimitive();
    }

    protected boolean inIsDeclared() {
        return this.in.getKind() == TypeKind.DECLARED;
    }

    public TypeKind outKind() {
        return this.out.getKind();
    }

    public boolean isOutPutAsParam() {
        return this.outPutAsParam;
    }

    public InOutType invert() {
        return new InOutType(this.out, this.in, this.outPutAsParam);
    }
}

