/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.codegen.AnnotationWrapper;
import fr.xebia.extras.selma.codegen.InOutType;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import fr.xebia.extras.selma.codegen.MappingBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;

public class ImmutableTypesWrapper {
    private final AnnotationWrapper mapper;
    private final MapperGeneratorContext context;
    private final Map<InOutType, MappingBuilder> immutables;
    private final Set<InOutType> unusedImmutables;
    private final List<String> immutablesPackages;

    public ImmutableTypesWrapper(AnnotationWrapper mapper, MapperGeneratorContext context) {
        this.mapper = mapper;
        this.context = context;
        this.immutables = new HashMap<InOutType, MappingBuilder>();
        this.unusedImmutables = new HashSet<InOutType>();
        List<String> immutables = mapper.getAsStrings("withImmutables");
        for (String immutableClass : immutables) {
            TypeElement element = context.elements.getTypeElement(immutableClass.replace(".class", ""));
            InOutType ioType = new InOutType(element.asType(), element.asType(), false);
            this.immutables.put(ioType, MappingBuilder.newImmutable());
            this.immutables.put(new InOutType(ioType, true), MappingBuilder.newImmutable());
            this.unusedImmutables.add(ioType);
        }
        this.immutablesPackages = mapper.getAsStrings("withImmutablesPackages");
    }

    public MappingBuilder get(InOutType inOutType) {
        MappingBuilder mappingBuilder = this.immutables.get(inOutType);
        if (mappingBuilder != null) {
            this.unusedImmutables.remove(inOutType);
        } else {
            for (String packageName : this.immutablesPackages) {
                if (!inOutType.inAsDeclaredType().toString().startsWith(packageName)) continue;
                mappingBuilder = MappingBuilder.newImmutable();
                break;
            }
        }
        return mappingBuilder;
    }

    public void reportUnused() {
        for (InOutType immutableIO : this.unusedImmutables) {
            this.context.warn(this.mapper.getAnnotatedElement(), "Immutable class \"%s\" is never used", immutableIO.in());
        }
    }
}

