/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.Fields;
import fr.xebia.extras.selma.codegen.AnnotationWrapper;
import fr.xebia.extras.selma.codegen.CustomMapperWrapper;
import fr.xebia.extras.selma.codegen.Field;
import fr.xebia.extras.selma.codegen.FieldBuilder;
import fr.xebia.extras.selma.codegen.FieldMap;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import fr.xebia.extras.selma.codegen.MethodWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

public class FieldsWrapper {
    private MapperGeneratorContext context;
    private Element element;
    private FieldMap fieldsRegistry;
    private FieldMap unusedFields;
    private FieldsWrapper parent = null;
    private List<CustomMapperWrapper> customMapperWrappers = new ArrayList<CustomMapperWrapper>();

    private FieldsWrapper(MapperGeneratorContext context, Element element) {
        this.context = context;
        this.element = element;
        this.fieldsRegistry = new FieldMap(element);
    }

    public FieldsWrapper(MapperGeneratorContext context, MethodWrapper mapperMethod, FieldsWrapper parent, List<AnnotationWrapper> withCustomFields) {
        this(context, mapperMethod.element());
        if (mapperMethod.hasFields()) {
            this.processFields(context, this.element);
        }
        if (withCustomFields != null && withCustomFields.size() > 0) {
            this.processFieldList(context, withCustomFields);
        }
        this.unusedFields = new FieldMap(this.fieldsRegistry);
        this.parent = parent;
    }

    public FieldsWrapper(MapperGeneratorContext context, TypeElement type, AnnotationWrapper mapper) {
        this(context, type);
        this.processFields(context, type);
        this.processFieldsFromMapper(context, mapper);
        this.unusedFields = new FieldMap(this.fieldsRegistry);
        this.parent = null;
    }

    private void processFieldsFromMapper(MapperGeneratorContext context, AnnotationWrapper mapper) {
        List<AnnotationWrapper> withCustomFields = mapper.getAsAnnotationWrapper("withCustomFields");
        this.processFieldList(context, withCustomFields);
    }

    private void processFields(MapperGeneratorContext context, Element type) {
        AnnotationWrapper fields = AnnotationWrapper.buildFor(context, type, Fields.class);
        if (fields != null) {
            this.processFieldList(context, fields.getAsAnnotationWrapper("value"));
        }
    }

    private void processFieldList(MapperGeneratorContext context, List<AnnotationWrapper> fields) {
        for (AnnotationWrapper field : fields) {
            CustomMapperWrapper customMapperWrapper;
            List<String> fieldPair = field.getAsStrings("value");
            String withCustom = field.getAsString("withCustom");
            FieldBuilder fieldBuilder = null;
            if (fieldPair.size() == 1 && !"java.lang.Object".equals(withCustom)) {
                fieldBuilder = new FieldBuilder().forElement(this.element).from(fieldPair.get(0).toLowerCase()).to(fieldPair.get(0).toLowerCase());
                customMapperWrapper = new CustomMapperWrapper(field, context);
                fieldBuilder.withCustom(customMapperWrapper);
                this.customMapperWrappers.add(customMapperWrapper);
            } else if (fieldPair.size() == 2 && !fieldPair.get(0).isEmpty() && !fieldPair.get(1).isEmpty()) {
                fieldBuilder = new FieldBuilder().forElement(this.element).from(fieldPair.get(0).toLowerCase()).to(fieldPair.get(1).toLowerCase());
                if (!"java.lang.Object".equals(withCustom)) {
                    customMapperWrapper = new CustomMapperWrapper(field, context);
                    fieldBuilder.withCustom(customMapperWrapper);
                    this.customMapperWrappers.add(customMapperWrapper);
                }
            } else if (fieldPair.size() == 2) {
                context.error(this.element, "Invalid @Field signature, empty string for fields are forbidden: " + field.toString(), new Object[0]);
            } else {
                context.error(this.element, "Invalid @Field signature, bad value count in value array: " + field.toString() + " \n" + "One value is supported @Field(value = \"field\", withCustom = MyCustomMapper.class)" + " only when withCustom is defined\n" + "Otherwise you must provide 2 and only 2 values @Field({\"fieldFrom\", \"fieldTo\"}", new Object[0]);
            }
            if (fieldBuilder == null) continue;
            this.fieldsRegistry.push(fieldBuilder.build());
        }
    }

    public List<Field> getFieldFor(String field, DeclaredType sourceType, DeclaredType destinationType) {
        String sourceFqcn = sourceType.toString().toLowerCase();
        String sourceSimpleName = sourceType.asElement().getSimpleName().toString().toLowerCase();
        String destinationFqcn = destinationType.toString().toLowerCase();
        String destinationSimpleName = destinationType.asElement().getSimpleName().toString().toLowerCase();
        ArrayList<Field> resParent = new ArrayList<Field>();
        ArrayList<Field> res = new ArrayList<Field>();
        if (this.parent != null) {
            resParent.addAll(this.parent.getFieldFor(field, sourceType, destinationType));
        }
        res.addAll(this.fieldsRegistry.getStartingWith(field));
        res.addAll(this.fieldsRegistry.getStartingWith(sourceFqcn + "." + field));
        res.addAll(this.fieldsRegistry.getStartingWith(sourceSimpleName + "." + field));
        for (Field re : res) {
            this.unusedFields.remove(re.to);
            re.removeDestinationPrefix(destinationFqcn, destinationSimpleName);
            re.removeSourcePrefix(sourceFqcn, sourceSimpleName);
            Iterator parentIterator = resParent.iterator();
            while (parentIterator.hasNext()) {
                Field parentField = (Field)parentIterator.next();
                if (!parentField.hasOneFieldMatching(re)) continue;
                parentIterator.remove();
            }
        }
        res.addAll(resParent);
        return res;
    }

    public void reportUnused() {
        for (Map.Entry<String, Field> unusedPair : this.unusedFields.entrySet()) {
            this.context.warn(this.element, "Custom @Field({\"%s\",\"%s\"}) mapping is never used !", unusedPair.getKey(), unusedPair.getValue().to);
        }
    }

    public List<TypeElement> mapperFields() {
        ArrayList<TypeElement> res = new ArrayList<TypeElement>();
        for (CustomMapperWrapper custom : this.customMapperWrappers) {
            res.addAll(custom.mapperFields());
        }
        return res;
    }
}

