/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.codegen.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;

public class FieldMap {
    private final Map<String, Field> from;
    private final Map<String, Field> to;
    private Element element;

    public FieldMap(FieldMap clone) {
        this.from = new HashMap<String, Field>(clone.from);
        this.to = new HashMap<String, Field>(clone.to);
        this.element = clone.element;
    }

    public FieldMap(Element element) {
        this.element = element;
        this.from = new HashMap<String, Field>();
        this.to = new HashMap<String, Field>();
    }

    public void push(Field mappingfield) {
        this.from.put(mappingfield.from, mappingfield);
        this.to.put(mappingfield.to, mappingfield.invert());
    }

    public String get(String key) {
        Field val = this.from.get(key);
        String res = null;
        res = val == null ? ((val = this.to.get(key)) != null ? val.originalFrom : null) : val.originalTo;
        return res;
    }

    public void remove(String field) {
        Field val = this.from.get(field);
        if (val == null) {
            val = this.to.get(field);
            if (val != null) {
                this.to.remove(field);
                this.from.remove(val.originalFrom);
            }
        } else {
            this.from.remove(field);
            this.to.remove(val.originalTo);
        }
    }

    public Set<Map.Entry<String, Field>> entrySet() {
        return this.from.entrySet();
    }

    public List<Field> getStartingWith(String fieldName) {
        List<Field> res = this.findStartingWith(this.from, fieldName);
        if (res.isEmpty()) {
            res = this.findStartingWith(this.to, fieldName);
        }
        return res;
    }

    private List<Field> findStartingWith(Map<String, Field> from, String fieldName) {
        ArrayList<Field> res = new ArrayList<Field>();
        for (String key : from.keySet()) {
            if ((!key.startsWith(fieldName) || !key.contains(fieldName + ".")) && !key.equals(fieldName)) continue;
            res.add(from.get(key));
        }
        return res;
    }
}

