/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

public class TypeConstructorWrapper {
    public final boolean hasDefaultConstructor;
    public final boolean hasMatchingSourcesConstructor;
    private final MapperGeneratorContext context;
    private final TypeElement typeElement;

    public TypeConstructorWrapper(MapperGeneratorContext context, TypeElement typeElement) {
        this.context = context;
        this.typeElement = typeElement;
        boolean defaultConstructor = false;
        boolean matchingSourcesConstructor = false;
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
        for (ExecutableElement constructor : constructors) {
            if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC) || constructor.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            int paramsCount = constructor.getParameters().size();
            if (paramsCount == 0) {
                defaultConstructor = true;
            }
            if (matchingSourcesConstructor || paramsCount != context.getSourcesCount()) continue;
            matchingSourcesConstructor = this.validateParametersTypes(constructor);
        }
        this.hasMatchingSourcesConstructor = matchingSourcesConstructor;
        this.hasDefaultConstructor = defaultConstructor;
    }

    private boolean validateParametersTypes(ExecutableElement constructor) {
        boolean res = true;
        List<? extends VariableElement> parameters = constructor.getParameters();
        Iterator<TypeElement> sources = this.context.sources().iterator();
        for (VariableElement variableElement : parameters) {
            TypeElement sourceType = sources.next();
            if (variableElement.asType().equals(sourceType.asType())) continue;
            res = false;
            break;
        }
        return res;
    }

    public boolean hasCallableConstructor() {
        return this.hasDefaultConstructor || this.hasMatchingSourcesConstructor;
    }
}

