/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import com.squareup.javawriter.JavaWriter;
import fr.xebia.extras.selma.codegen.AnnotationWrapper;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class SourceWrapper {
    public static final String WITH_SOURCES = "withSources";
    private final AnnotationWrapper mapperAnnotation;
    private final MapperGeneratorContext context;
    private final List<String> sources;
    private final String[] args;
    private final List<String> assigns;
    private final ArrayList<TypeElement> sourcesTypes;

    public SourceWrapper(AnnotationWrapper mapperAnnotation, MapperGeneratorContext context) {
        this.mapperAnnotation = mapperAnnotation;
        this.context = context;
        this.sources = mapperAnnotation.getAsStrings(WITH_SOURCES);
        this.sourcesTypes = new ArrayList();
        int i = 0;
        int iArg = 0;
        this.args = new String[this.sources.size() * 2];
        this.assigns = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (String classe : this.sources) {
            String className;
            builder.append(',');
            this.args[iArg] = className = classe.replace(".class", "");
            this.args[++iArg] = "_source" + i;
            ++iArg;
            this.assigns.add(String.format("this.source%s = _source%s", i, i));
            builder.append("this.source").append(i);
            this.sourcesTypes.add(context.elements.getTypeElement(className));
            ++i;
        }
        if (this.sources.size() > 0) {
            builder.deleteCharAt(0);
        }
        context.setNewParams(builder.toString());
        context.setSources(this.sourcesTypes);
    }

    public void emitFields(JavaWriter writer) throws IOException {
        int i = 0;
        for (String classe : this.sources) {
            writer.emitEmptyLine();
            writer.emitJavadoc("This field is used as source akka given as parameter to the Pojos constructors", new Object[0]);
            writer.emitField(classe.replace(".class", ""), "source" + i, EnumSet.of(Modifier.PRIVATE, Modifier.FINAL));
            ++i;
        }
    }

    public void emitAssigns(JavaWriter writer) throws IOException {
        for (String statement : this.assigns) {
            writer.emitStatement(statement, new Object[0]);
        }
    }

    public String[] sourceConstructorArgs() {
        return this.args;
    }
}

