/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.CollectionMappingStrategy;
import fr.xebia.extras.selma.IgnoreMissing;
import fr.xebia.extras.selma.Maps;
import fr.xebia.extras.selma.codegen.AnnotationWrapper;
import fr.xebia.extras.selma.codegen.BeanWrapper;
import fr.xebia.extras.selma.codegen.CustomMapperWrapper;
import fr.xebia.extras.selma.codegen.EnumMappersWrapper;
import fr.xebia.extras.selma.codegen.Field;
import fr.xebia.extras.selma.codegen.FieldsWrapper;
import fr.xebia.extras.selma.codegen.IgnoreFieldsWrapper;
import fr.xebia.extras.selma.codegen.InOutType;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import fr.xebia.extras.selma.codegen.MapperWrapper;
import fr.xebia.extras.selma.codegen.MappingBuilder;
import fr.xebia.extras.selma.codegen.MappingRegistry;
import fr.xebia.extras.selma.codegen.MappingSourceNode;
import fr.xebia.extras.selma.codegen.MethodWrapper;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

public class MapsWrapper {
    public static final String WITH_CUSTOM_FIELDS = "withCustomFields";
    public static final String WITH_IGNORE_FIELDS = "withIgnoreFields";
    public static final String WITH_ENUMS = "withEnums";
    public static final String WITH_IGNORE_MISSING = "withIgnoreMissing";
    public static final String WITH_COLLECTION_STRATEGY = "withCollectionStrategy";
    private final FieldsWrapper customFields;
    private final AnnotationWrapper maps;
    private final MappingRegistry registry;
    private final IgnoreFieldsWrapper ignoreFields;
    private final EnumMappersWrapper enumMappers;
    private final MethodWrapper method;
    private final MapperWrapper mapperWrapper;
    private final MapperGeneratorContext context;
    private final CustomMapperWrapper customMapper;
    private final IgnoreMissing ignoreMissing;
    private boolean ignoreMissingProperties;
    private final CollectionMappingStrategy collectionMappingStrategy;

    public MapsWrapper(MethodWrapper method, MapperWrapper mapperWrapper) {
        this.method = method;
        this.mapperWrapper = mapperWrapper;
        this.registry = new MappingRegistry(mapperWrapper.registry());
        this.context = mapperWrapper.context();
        this.maps = AnnotationWrapper.buildFor(this.context, method.element(), Maps.class);
        this.ignoreFields = new IgnoreFieldsWrapper(this.context, method.element(), mapperWrapper.ignoredFields(), this.maps == null ? null : this.maps.getAsStrings(WITH_IGNORE_FIELDS));
        this.customFields = new FieldsWrapper(this.context, method, mapperWrapper.fields(), this.maps == null ? null : this.maps.getAsAnnotationWrapper(WITH_CUSTOM_FIELDS));
        this.enumMappers = new EnumMappersWrapper(this.registry.getEnumMappers(), this.maps == null ? null : this.maps.getAsAnnotationWrapper(WITH_ENUMS), (Element)method.element());
        this.registry.enumMappers(this.enumMappers);
        this.customMapper = new CustomMapperWrapper(mapperWrapper.customMappers(), this.maps, this.context);
        this.registry.customMappers(this.customMapper);
        this.ignoreMissingProperties = mapperWrapper.isIgnoreMissingProperties();
        this.collectionMappingStrategy = this.maps == null ? CollectionMappingStrategy.DEFAULT : CollectionMappingStrategy.valueOf((String)this.maps.getAsString(WITH_COLLECTION_STRATEGY));
        IgnoreMissing missing = this.maps == null ? IgnoreMissing.DEFAULT : IgnoreMissing.valueOf((String)this.maps.getAsString(WITH_IGNORE_MISSING));
        this.ignoreMissing = missing == IgnoreMissing.DEFAULT ? mapperWrapper.ignoreMissing() : missing;
    }

    public void reportUnused() {
        this.ignoreFields.reportUnusedFields();
        this.customFields.reportUnused();
        this.enumMappers.reportUnused();
        this.customMapper.reportUnused();
    }

    public List<Field> getFieldsFor(String field, DeclaredType sourceType, DeclaredType destinationType) {
        return this.customFields.getFieldFor(field, sourceType, destinationType);
    }

    public MappingBuilder mappingInterceptor(InOutType inOutType) {
        return this.registry.mappingInterceptor(inOutType);
    }

    public MappingBuilder findMappingFor(InOutType inOutType) {
        return this.registry.findMappingFor(inOutType);
    }

    public boolean isIgnoredField(String field, DeclaredType declaredType) {
        return this.ignoreFields.isIgnoredField(field, declaredType);
    }

    public boolean isIgnoreMissingProperties() {
        return this.ignoreMissingProperties;
    }

    public List<TypeElement> customMapperFields() {
        return this.customMapper.mapperFields();
    }

    public IgnoreMissing ignoreMissing() {
        return this.ignoreMissing;
    }

    public boolean allowCollectionGetter() {
        return this.collectionMappingStrategy == CollectionMappingStrategy.DEFAULT ? this.mapperWrapper.allowCollectionGetter() : this.collectionMappingStrategy == CollectionMappingStrategy.ALLOW_GETTER;
    }

    public MappingSourceNode generateNewInstanceSourceNodes(InOutType inOutType, BeanWrapper outBeanWrapper) {
        return this.mapperWrapper.generateNewInstanceSourceNodes(inOutType, outBeanWrapper);
    }
}

