/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import com.squareup.javawriter.JavaWriter;
import fr.xebia.extras.selma.codegen.BeanWrapper;
import fr.xebia.extras.selma.codegen.BeanWrapperFactory;
import fr.xebia.extras.selma.codegen.Field;
import fr.xebia.extras.selma.codegen.InOutType;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import fr.xebia.extras.selma.codegen.MapperWrapper;
import fr.xebia.extras.selma.codegen.MappingBuilder;
import fr.xebia.extras.selma.codegen.MappingSourceNode;
import fr.xebia.extras.selma.codegen.MapsWrapper;
import fr.xebia.extras.selma.codegen.MethodWrapper;
import fr.xebia.extras.selma.codegen.SourceConfiguration;
import fr.xebia.extras.selma.codegen.SourceNodeVars;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class MapperMethodGenerator {
    private static final Pattern STANDARD_JAVA_PACKAGE = Pattern.compile("^(java|javax)\\.+$");
    private final JavaWriter writer;
    private final MethodWrapper mapperMethod;
    private final MapperGeneratorContext context;
    private final SourceConfiguration configuration;
    private final MapsWrapper maps;
    private final BeanWrapperFactory beanWrapperFactory;

    public MapperMethodGenerator(JavaWriter writer, MethodWrapper method, MapperWrapper mapperWrapper) {
        this.writer = writer;
        this.mapperMethod = method;
        this.context = mapperWrapper.context();
        this.configuration = mapperWrapper.configuration();
        this.beanWrapperFactory = new BeanWrapperFactory();
        this.maps = new MapsWrapper(method, mapperWrapper);
    }

    public void build() throws IOException {
        this.buildMappingMethod(this.writer, this.mapperMethod.inOutType(), this.mapperMethod.getSimpleName(), true);
        if (this.context.hasMappingMethods()) {
            this.buildMappingMethods(this.writer);
        }
        this.maps.reportUnused();
    }

    private void buildMappingMethods(JavaWriter writer) throws IOException {
        MapperGeneratorContext.MappingMethod method;
        while ((method = this.context.popMappingMethod()) != null) {
            this.buildMappingMethod(writer, method.inOutType(), method.name(), false);
        }
    }

    private void buildMappingMethod(JavaWriter writer, InOutType inOutType, String name, boolean override) throws IOException {
        MappingSourceNode ptr;
        boolean isPrimitiveOrImmutable = false;
        MappingSourceNode methodRoot = this.configuration.isFinalMappers() ? MappingSourceNode.mapMethod(inOutType, name, override) : MappingSourceNode.mapMethodNotFinal(inOutType, name, override);
        MappingSourceNode blankRoot = ptr = MappingSourceNode.blank();
        MappingSourceNode methodNode = inOutType.isOutPutAsParam() ? methodRoot.body(MappingSourceNode.blank()) : methodRoot.body(MappingSourceNode.declareOut(inOutType.out()));
        MappingBuilder mappingBuilder = this.findBuilderFor(inOutType);
        if (mappingBuilder != null) {
            ptr.body(mappingBuilder.build(this.context, new SourceNodeVars().withInOutType(inOutType).withAssign(true)));
            this.generateStack(this.context);
            isPrimitiveOrImmutable = !inOutType.differs() && mappingBuilder.isNullSafe();
        } else if (inOutType.areDeclared() && this.isSupported(inOutType.out())) {
            BeanWrapper outBeanWrapper = this.getBeanWrapperOrNew(this.context, inOutType.outAsTypeElement());
            ptr = ptr.body(this.maps.generateNewInstanceSourceNodes(inOutType, outBeanWrapper));
            ++this.context.depth;
            ptr.child(this.generate(inOutType));
            --this.context.depth;
        } else {
            this.handleNotSupported(inOutType, ptr);
        }
        boolean bl = isPrimitiveOrImmutable = isPrimitiveOrImmutable || inOutType.inIsPrimitive();
        if (!isPrimitiveOrImmutable) {
            methodNode = methodNode.child(MappingSourceNode.controlNotNull("in", inOutType.isOutPutAsParam()));
            methodNode.body(blankRoot.body);
        } else {
            methodNode.child(blankRoot.body);
        }
        MappingBuilder interceptor = this.maps.mappingInterceptor(inOutType);
        if (interceptor != null) {
            methodNode.child(interceptor.build(this.context, new SourceNodeVars()));
        }
        methodRoot.write(writer);
    }

    private BeanWrapper getBeanWrapperOrNew(MapperGeneratorContext context, TypeElement typeElement) {
        return this.beanWrapperFactory.getBeanWrapperOrNew(context, typeElement);
    }

    private boolean isSupported(TypeMirror out) {
        boolean res = false;
        Matcher matcher = STANDARD_JAVA_PACKAGE.matcher(out.toString());
        if (!matcher.matches()) {
            TypeElement outTypeElement = (TypeElement)this.context.type.asElement(out);
            BeanWrapper outBean = this.getBeanWrapperOrNew(this.context, outTypeElement);
            res = outBean.hasCallableConstructor();
        }
        return res;
    }

    private void handleNotSupported(InOutType inOutType, MappingSourceNode ptr) {
        String message = String.format("Failed to generate mapping method for type %s to %s not supported on %s.%s !\n--> Add a custom mapper or 'withIgnoreFields' on @Mapper or @Maps to fix this ! If you think this a Bug in Selma please report issue here [https://github.com/xebia-france/selma/issues].", inOutType.in(), inOutType.out(), this.mapperMethod.element().getEnclosingElement(), this.mapperMethod.element().toString());
        ptr.body(MappingSourceNode.notSupported(message));
        if (this.configuration.isIgnoreNotSupported()) {
            this.context.warn(message, this.mapperMethod.element());
        } else {
            this.context.error(this.mapperMethod.element(), message, new Object[0]);
        }
    }

    private MappingSourceNode generateStack(MapperGeneratorContext context) throws IOException {
        MapperGeneratorContext.StackElem stackElem;
        MappingSourceNode root = MappingSourceNode.blank();
        while ((stackElem = context.popStack()) != null) {
            InOutType inOutType = stackElem.sourceNodeVars().inOutType;
            ++context.depth;
            MappingBuilder mappingBuilder = this.findBuilderFor(inOutType);
            if (stackElem.child) {
                stackElem.lastNode.lastChild().child(mappingBuilder.build(context, stackElem.sourceNodeVars()));
            } else {
                stackElem.lastNode.body(mappingBuilder.build(context, stackElem.sourceNodeVars()));
            }
            --context.depth;
        }
        return root;
    }

    MappingBuilder findBuilderFor(InOutType inOutType) {
        return this.maps.findMappingFor(inOutType);
    }

    private MappingSourceNode generate(InOutType inOutType) throws IOException {
        MappingSourceNode root;
        MappingSourceNode ptr = root = MappingSourceNode.blank();
        TypeElement outTypeElement = (TypeElement)this.context.type.asElement(inOutType.out());
        BeanWrapper outBean = this.getBeanWrapperOrNew(this.context, outTypeElement);
        BeanWrapper inBean = this.getBeanWrapperOrNew(this.context, (TypeElement)this.context.type.asElement(inOutType.in()));
        Set<String> outFields = outBean.getSetterFields();
        ArrayList<Field> customFields = new ArrayList<Field>();
        Iterator<String> i$ = inBean.getGetterFields().iterator();
        while (i$.hasNext()) {
            String field;
            String outFieldName = field = i$.next();
            List<Field> customFieldsFor = this.maps.getFieldsFor(field, inOutType.inAsDeclaredType(), inOutType.outAsDeclaredType());
            if (!customFieldsFor.isEmpty()) {
                boolean hasEmbedded = false;
                for (Field customField : customFieldsFor) {
                    if (!customField.hasEmbedded()) continue;
                    outFields.remove(customField.to);
                    hasEmbedded = true;
                }
                if (hasEmbedded) {
                    customFields.addAll(customFieldsFor);
                    continue;
                }
                outFieldName = customFieldsFor.get((int)0).to;
            }
            TypeMirror typeForInField = inBean.getTypeForGetter(field);
            TypeMirror typeForOutField = outBean.getTypeForSetter(outFieldName);
            boolean isMissingInDestination = !outBean.hasFieldAndSetter(outFieldName);
            boolean useGetterForDestination = false;
            if (isMissingInDestination && this.maps.allowCollectionGetter() && outBean.hasFieldAndGetter(outFieldName)) {
                DeclaredType declaredTypeForGetter = outBean.getDeclaredTypeForGetter(outFieldName);
                isMissingInDestination = !MappingBuilder.isCollection(declaredTypeForGetter, this.context);
                typeForOutField = declaredTypeForGetter;
                useGetterForDestination = true;
            }
            if (this.maps.isIgnoredField(field, inOutType.inAsDeclaredType()) || isMissingInDestination && this.maps.ignoreMissing().isIgnoreDestination()) continue;
            if (isMissingInDestination) {
                if (!customFieldsFor.isEmpty()) {
                    this.context.error(this.mapperMethod.element(), String.format("Mapping custom field %s from source bean %s, setter for field %s is missing in destination bean %s !\n --> Check your custom field %s, you can add simple class name or FQCN to the longest field path  or add missing getter", field, inOutType.in(), outFieldName, inOutType.out(), customFieldsFor.get(0)), new Object[0]);
                } else {
                    this.context.error(this.mapperMethod.element(), String.format("Mapping field %s from source bean %s, setter for field %s is missing in destination bean %s !\n --> Add @Mapper(withIgnoreFields=\"%s.%s\") / @Maps(withIgnoreFields=\"%s.%s\") to mapper interface / method or add missing getter or specify corresponding @Field to customize field to field mapping", field, inOutType.in(), outFieldName, inOutType.out(), inOutType.in(), field, inOutType.in(), field), new Object[0]);
                }
                outFields.remove(field);
                continue;
            }
            try {
                InOutType inOutTypeForField = new InOutType(typeForInField, typeForOutField, inOutType.isOutPutAsParam());
                MappingBuilder mappingBuilder = this.findBuilderFor(inOutTypeForField);
                if (mappingBuilder != null) {
                    ptr = ptr.child(mappingBuilder.build(this.context, new SourceNodeVars(field, outFieldName, inBean, outBean).withInOutType(inOutTypeForField).withAssign(false).withUseGetterForDestination(useGetterForDestination)));
                    this.generateStack(this.context);
                } else {
                    this.handleNotSupported(inOutTypeForField, ptr);
                }
            }
            catch (Exception e) {
                System.out.printf("Error while searching builder for field %s on %s mapper", field, inOutType.toString());
                e.printStackTrace();
            }
            ptr = ptr.lastChild();
            outFields.remove(outFieldName);
        }
        for (Field customField : customFields) {
            ptr = this.buildEmbeddedMapping(customField, inBean, outBean, ptr, outFields, inOutType.isOutPutAsParam());
            ptr = ptr.lastChild();
        }
        if (!this.maps.ignoreMissing().isIgnoreSource()) {
            for (String outField : outFields) {
                if (this.maps.isIgnoredField(outField, inOutType.outAsDeclaredType())) continue;
                this.context.error(this.mapperMethod.element(), "setter for field %s from destination bean %s has no getter in source bean %s !\n --> Add @Mapper(withIgnoreFields=\"%s.%s\") / @Maps(withIgnoreFields=\"%s.%s\") to mapper interface / method or add missing setter or specify corresponding @Field to customize field to field mapping", outField, inOutType.out(), inOutType.in(), inOutType.out(), outField, inOutType.out(), outField);
            }
        }
        return root.child;
    }

    private MappingSourceNode buildEmbeddedMapping(Field customField, BeanWrapper inBean, BeanWrapper outBean, MappingSourceNode root, Set<String> outFields, boolean outPutAsParam) {
        String lastVisitedField;
        MappingSourceNode ptr;
        MappingSourceNode ptrRoot = ptr = MappingSourceNode.blank();
        if (customField.hasEmbeddedSourceAndDestination()) {
            this.context.error(customField.element, "Bad custom field to field mapping: both source and destination can not be embedded !\n-->  Fix @Field({\"%s\",\"%s\"})", customField.originalFrom, customField.originalTo);
            return root;
        }
        boolean sourceEmbedded = customField.sourceEmbedded();
        BeanWrapper beanPtr = sourceEmbedded ? inBean : outBean;
        boolean useGetterForDestination = false;
        if (sourceEmbedded && !outBean.hasFieldAndSetter(customField.to)) {
            if (this.maps.allowCollectionGetter() && outBean.hasFieldAndGetter(customField.to)) {
                DeclaredType declaredTypeForGetter = outBean.getDeclaredTypeForGetter(customField.to);
                useGetterForDestination = MappingBuilder.isCollection(declaredTypeForGetter, this.context);
            }
            if (!useGetterForDestination) {
                this.context.error(customField.element, "Bad custom field to field mapping: setter for field %s is missing in destination bean %s !\n --> Fix @Field({\"%s\",\"%s\"})", customField.to, outBean.typeElement, customField.originalFrom, customField.originalTo);
                return root;
            }
        }
        if (!sourceEmbedded && !inBean.hasFieldAndGetter(customField.from)) {
            this.context.error(customField.element, "Bad custom field to field mapping: getter for field %s is missing in source bean %s !\n --> Fix @Field({\"%s\",\"%s\"})", customField.from, inBean.typeElement, customField.originalFrom, customField.originalTo);
            return root;
        }
        String[] fields = sourceEmbedded ? customField.fromFields() : customField.toFields();
        String previousFieldPath = sourceEmbedded ? "in" : "out";
        StringBuilder field = new StringBuilder(previousFieldPath);
        for (int id = 0; id < fields.length - 1; ++id) {
            lastVisitedField = fields[id];
            if (id == 0 && !sourceEmbedded) {
                outFields.remove(lastVisitedField);
            }
            if (sourceEmbedded && !beanPtr.hasFieldAndGetter(lastVisitedField)) {
                this.context.error(customField.element, "Bad custom field to field mapping: field %s.%s from source bean %s has no getter !\n-->  Fix @Field({\"%s\",\"%s\"})", field, lastVisitedField, inBean.typeElement, customField.originalFrom, customField.originalTo);
                return root;
            }
            if (!sourceEmbedded && !beanPtr.hasFieldAndGetter(lastVisitedField)) {
                this.context.error(customField.element, "Bad custom field to field mapping: field %s.%s from destination bean %s has no getter !\n-->  Fix @Field({\"%s\",\"%s\"})", field, lastVisitedField, outBean.typeElement, customField.originalFrom, customField.originalTo);
                return root;
            }
            field.append('.').append(beanPtr.getGetterFor(lastVisitedField)).append("()");
            if (sourceEmbedded) {
                ptr = ptr.body(MappingSourceNode.controlNotNull(field.toString(), false));
            } else {
                ptr = ptr.child(MappingSourceNode.controlNull(field.toString()));
                ptr.body(MappingSourceNode.set(previousFieldPath + '.' + beanPtr.getSetterFor(lastVisitedField), "new " + beanPtr.getTypeForGetter(lastVisitedField) + "(" + this.context.newParams() + ")"));
            }
            beanPtr = this.getBeanWrapperOrNew(this.context, (TypeElement)this.context.type.asElement(beanPtr.getTypeForGetter(lastVisitedField)));
            previousFieldPath = field.toString();
        }
        lastVisitedField = fields[fields.length - 1];
        if (sourceEmbedded && !beanPtr.hasFieldAndGetter(lastVisitedField)) {
            this.context.error(customField.element, "Bad custom field to field mapping: field %s.%s from source bean %s has no getter !\n-->  Fix @Field({\"%s\",\"%s\"})", field, lastVisitedField, inBean.typeElement, customField.originalFrom, customField.originalTo);
            return root;
        }
        if (!sourceEmbedded && !beanPtr.hasFieldAndSetter(lastVisitedField)) {
            if (this.maps.allowCollectionGetter() && beanPtr.hasFieldAndSetter(lastVisitedField)) {
                DeclaredType declaredTypeForGetter = beanPtr.getDeclaredTypeForGetter(lastVisitedField);
                useGetterForDestination = MappingBuilder.isCollection(declaredTypeForGetter, this.context);
            }
            if (!useGetterForDestination) {
                this.context.error(customField.element, "Bad custom field to field mapping: field %s.%s from destination bean %s has no setter !\n-->  Fix @Field({\"%s\",\"%s\"})", field, lastVisitedField, outBean.typeElement, customField.originalFrom, customField.originalTo);
                return root;
            }
        }
        if (sourceEmbedded) {
            field.append('.').append(beanPtr.getGetterFor(lastVisitedField)).append("()");
        } else {
            field.append('.').append(beanPtr.getSetterFor(lastVisitedField));
        }
        InOutType inOutType = sourceEmbedded ? new InOutType(beanPtr.getTypeForGetter(lastVisitedField), outBean.getTypeForSetter(customField.to), outPutAsParam) : new InOutType(inBean.getTypeForGetter(customField.from), beanPtr.getTypeForSetter(lastVisitedField), outPutAsParam);
        try {
            MappingBuilder mappingBuilder = this.findBuilderFor(inOutType);
            if (mappingBuilder != null) {
                ptr = sourceEmbedded ? ptr.body(mappingBuilder.build(this.context, new SourceNodeVars(field.toString(), customField.to, outBean).withInOutType(inOutType).withAssign(false).withUseGetterForDestination(useGetterForDestination))) : ptr.child(mappingBuilder.build(this.context, new SourceNodeVars("in." + inBean.getGetterFor(customField.from) + "()", field.toString()).withInOutType(inOutType).withAssign(false).withUseGetterForDestination(useGetterForDestination)));
                this.generateStack(this.context);
            } else {
                this.handleNotSupported(inOutType, ptr);
            }
        }
        catch (Exception e) {
            System.out.printf("Error while searching builder for field %s on %s mapper", field, inOutType.toString());
            e.printStackTrace();
        }
        if (!sourceEmbedded && inBean.getTypeForGetter(customField.from).getKind() == TypeKind.DECLARED) {
            MappingSourceNode ifNode = MappingSourceNode.controlNotNull("in." + inBean.getGetterFor(customField.from) + "()", false);
            ifNode.body(ptrRoot.child);
            ptrRoot.child = ifNode;
        }
        return root.child(sourceEmbedded ? ptrRoot.body : ptrRoot.child);
    }

    public MapsWrapper maps() {
        return this.maps;
    }
}

