/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.codegen.InOutType;
import fr.xebia.extras.selma.codegen.MappingSourceNode;
import fr.xebia.extras.selma.codegen.SourceNodeVars;
import fr.xebia.extras.selma.codegen.compiler.CompilerMessageRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class MapperGeneratorContext {
    private final ProcessingEnvironment processingEnv;
    private final CompilerMessageRegistry messageRegistry;
    int depth = 0;
    Elements elements;
    Types type;
    LinkedList<StackElem> stack;
    private HashMap<String, MappingMethod> mappingRegistry;
    LinkedList<MappingMethod> methodStack;
    private String newParams;
    public final List<TypeElement> sources;

    public MapperGeneratorContext(ProcessingEnvironment processingEnvironment) {
        this.elements = processingEnvironment.getElementUtils();
        this.type = processingEnvironment.getTypeUtils();
        this.stack = new LinkedList();
        this.processingEnv = processingEnvironment;
        this.mappingRegistry = new HashMap();
        this.methodStack = new LinkedList();
        this.messageRegistry = new CompilerMessageRegistry();
        this.sources = new ArrayList<TypeElement>();
    }

    public void error(Element element, String message, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(message, args), this.messageRegistry.hasMessageFor(Diagnostic.Kind.ERROR, element) ? null : element);
    }

    public void pushStackForBody(MappingSourceNode node, SourceNodeVars vars) {
        this.stack.push(new StackElem(node, vars));
    }

    public void pushStackForChild(MappingSourceNode node, SourceNodeVars vars) {
        this.stack.push(new StackElem(node, vars).withChild(true));
    }

    public StackElem popStack() {
        if (this.stack.size() > 0) {
            return this.stack.pop();
        }
        return null;
    }

    public void warn(String s, ExecutableElement element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, s, this.messageRegistry.hasMessageFor(Diagnostic.Kind.WARNING, element) ? null : element);
    }

    public void mappingMethod(InOutType inOutType, String name) {
        this.getMappingMethod(inOutType, new MappingMethod(inOutType, name));
    }

    public String mappingMethod(InOutType inOutType) {
        MappingMethod method = this.getMappingMethod(inOutType, new MappingMethod(inOutType));
        return method.name();
    }

    private MappingMethod getMappingMethod(InOutType inOutType, MappingMethod mappingMethod) {
        InOutType key = inOutType;
        MappingMethod method = mappingMethod;
        if (this.mappingRegistry.containsKey(key.toString())) {
            return this.mappingRegistry.get(key.toString());
        }
        if (inOutType.areDeclared() && inOutType.areEnums() && inOutType.isOutPutAsParam()) {
            key = new InOutType(inOutType, false);
            if (this.mappingRegistry.containsKey(key.toString())) {
                return this.mappingRegistry.get(key.toString());
            }
            mappingMethod = new MappingMethod(mappingMethod, key);
        }
        this.methodStack.push(mappingMethod);
        this.mappingRegistry.put(key.toString(), mappingMethod);
        return mappingMethod;
    }

    public boolean hasMappingMethods() {
        return this.mappingRegistry.size() > 0;
    }

    public MappingMethod popMappingMethod() {
        MappingMethod mappingMethod = null;
        if (this.methodStack.size() > 0) {
            mappingMethod = this.methodStack.pop();
            while (this.methodStack.size() > 0 && mappingMethod.built) {
                mappingMethod = this.methodStack.pop();
            }
            if (mappingMethod.built) {
                mappingMethod = null;
            }
        }
        return mappingMethod;
    }

    public Elements elements() {
        return this.elements;
    }

    public void warn(Element element, String templateMessage, Object ... args) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format(templateMessage, args), this.messageRegistry.hasMessageFor(Diagnostic.Kind.WARNING, element) ? null : element);
    }

    public void setNewParams(String newParams) {
        this.newParams = newParams;
    }

    public String newParams() {
        return this.newParams;
    }

    public int getSourcesCount() {
        return this.sources.size();
    }

    public TypeElement getTypeElement(String classe) {
        return this.elements.getTypeElement(classe);
    }

    public void setSources(List<TypeElement> _sources) {
        this.sources.addAll(_sources);
    }

    public List<TypeElement> sources() {
        return this.sources;
    }

    public class MappingMethod {
        private final InOutType inOutType;
        private final String name;
        private boolean built;

        public MappingMethod(InOutType inOutType) {
            this.inOutType = inOutType;
            this.name = String.format("as%s", inOutType.outAsTypeElement().getSimpleName());
            this.built = false;
        }

        public MappingMethod(InOutType inOutType, String name) {
            this.inOutType = inOutType;
            this.name = name;
            this.built = true;
        }

        public MappingMethod(MappingMethod mappingMethod, InOutType key) {
            this.name = mappingMethod.name();
            this.built = mappingMethod.built;
            this.inOutType = key;
        }

        public String name() {
            return this.name;
        }

        public boolean isBuilt() {
            return this.built;
        }

        public void build() {
            this.built = true;
        }

        public String inType() {
            return this.inOutType.in().toString();
        }

        public String outType() {
            return this.inOutType.out().toString();
        }

        public TypeMirror in() {
            return this.inOutType.in();
        }

        public InOutType inOutType() {
            return this.inOutType;
        }
    }

    class StackElem {
        final MappingSourceNode lastNode;
        private final SourceNodeVars vars;
        boolean child = false;

        private StackElem(MappingSourceNode lastNode, SourceNodeVars vars) {
            this.lastNode = lastNode;
            this.vars = vars;
        }

        public SourceNodeVars sourceNodeVars() {
            return this.vars;
        }

        public StackElem withChild(boolean isChild) {
            this.child = isChild;
            return this;
        }
    }
}

