/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import fr.xebia.extras.selma.codegen.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;

public class FieldMap {
    private final Map<String, String> from;
    private final Map<String, String> to;
    private Element element;

    public FieldMap(FieldMap clone) {
        this.from = new HashMap<String, String>(clone.from);
        this.to = new HashMap<String, String>(clone.to);
        this.element = clone.element;
    }

    public FieldMap(Element element) {
        this.element = element;
        this.from = new HashMap<String, String>();
        this.to = new HashMap<String, String>();
    }

    public void push(String _from, String _to) {
        this.from.put(_from, _to);
        this.to.put(_to, _from);
    }

    public String get(String key) {
        String val = this.from.get(key);
        if (val == null) {
            val = this.to.get(key);
        }
        return val;
    }

    public void remove(String field) {
        String val = this.from.get(field);
        if (val == null) {
            val = this.to.get(field);
            if (val != null) {
                this.to.remove(field);
                this.from.remove(val);
            }
        } else {
            this.from.remove(field);
            this.to.remove(val);
        }
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.from.entrySet();
    }

    public List<Field> getStartingWith(String fieldName) {
        List<Field> res = this.findStartingWith(this.from, fieldName);
        if (res.isEmpty()) {
            res = this.findStartingWith(this.to, fieldName);
        }
        return res;
    }

    private List<Field> findStartingWith(Map<String, String> from, String fieldName) {
        ArrayList<Field> res = new ArrayList<Field>();
        for (String key : from.keySet()) {
            if ((!key.startsWith(fieldName) || !key.contains(fieldName + ".")) && !key.equals(fieldName)) continue;
            res.add(new Field(key, from.get(key), this.element));
        }
        return res;
    }
}

