/*
 * Decompiled with CFR 0.152.
 */
package fr.xebia.extras.selma.codegen;

import com.squareup.javawriter.JavaWriter;
import fr.xebia.extras.selma.IoC;
import fr.xebia.extras.selma.codegen.AnnotationWrapper;
import fr.xebia.extras.selma.codegen.InOutType;
import fr.xebia.extras.selma.codegen.MapperGeneratorContext;
import fr.xebia.extras.selma.codegen.MapperProcessor;
import fr.xebia.extras.selma.codegen.MappingBuilder;
import fr.xebia.extras.selma.codegen.MethodWrapper;
import fr.xebia.extras.selma.codegen.TypeConstructorWrapper;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class CustomMapperWrapper {
    public static final String CUSTOM_MAPPER_FIELD_TPL = "customMapper%s";
    public static final String WITH_CUSTOM = "withCustom";
    private CustomMapperWrapper parent;
    private final AnnotationWrapper annotationWrapper;
    private final MapperGeneratorContext context;
    private final HashMap<InOutType, String> unusedCustomMappers;
    private final Map<InOutType, MappingBuilder> registryMap;
    private final Map<InOutType, MappingBuilder> interceptorMap;
    private final List<TypeElement> customMapperFields;
    private final HashMap<InOutType, String> unusedInterceptor;
    private final Element annotatedElement;
    private final IoC ioC;

    public CustomMapperWrapper(AnnotationWrapper mapperAnnotation, MapperGeneratorContext context) {
        this.annotatedElement = mapperAnnotation.getAnnotatedElement();
        this.annotationWrapper = mapperAnnotation;
        this.context = context;
        this.customMapperFields = new LinkedList<TypeElement>();
        this.unusedCustomMappers = new HashMap();
        this.unusedInterceptor = new HashMap();
        this.registryMap = new HashMap<InOutType, MappingBuilder>();
        this.interceptorMap = new HashMap<InOutType, MappingBuilder>();
        this.ioC = IoC.valueOf((String)this.annotationWrapper.getAsString("withIoC"));
        this.collectCustomMappers();
    }

    public CustomMapperWrapper(CustomMapperWrapper parent, AnnotationWrapper annotationWrapper, MapperGeneratorContext context) {
        this.parent = parent;
        this.annotationWrapper = annotationWrapper;
        this.customMapperFields = new LinkedList<TypeElement>();
        this.unusedCustomMappers = new HashMap();
        this.unusedInterceptor = new HashMap();
        this.registryMap = new HashMap<InOutType, MappingBuilder>();
        this.interceptorMap = new HashMap<InOutType, MappingBuilder>();
        this.context = context;
        this.ioC = parent.ioC;
        if (annotationWrapper != null) {
            this.annotatedElement = annotationWrapper.getAnnotatedElement();
            this.collectCustomMappers();
        } else {
            this.annotatedElement = null;
        }
    }

    void emitCustomMappersFields(JavaWriter writer, boolean assign) throws IOException {
        for (TypeElement customMapperField : this.customMapperFields) {
            String field = String.format(CUSTOM_MAPPER_FIELD_TPL, customMapperField.getSimpleName().toString());
            if (assign) {
                if (customMapperField.getKind() == ElementKind.INTERFACE) continue;
                TypeConstructorWrapper constructorWrapper = new TypeConstructorWrapper(this.context, customMapperField);
                writer.emitStatement("this.%s = new %s(%s)", new Object[]{field, customMapperField.getQualifiedName().toString(), constructorWrapper.hasMatchingSourcesConstructor ? this.context.newParams() : ""});
                continue;
            }
            writer.emitEmptyLine();
            writer.emitJavadoc("This field is used for custom Mapping", new Object[0]);
            if (this.ioC == IoC.SPRING) {
                writer.emitAnnotation("org.springframework.beans.factory.annotation.Autowired");
            }
            writer.emitField(customMapperField.asType().toString(), String.format(CUSTOM_MAPPER_FIELD_TPL, customMapperField.getSimpleName().toString()), EnumSet.of(Modifier.PRIVATE));
            writer.emitEmptyLine();
            writer.emitJavadoc("Custom Mapper setter for " + field, new Object[0]);
            writer.beginMethod("void", "setCustomMapper" + customMapperField.getSimpleName(), EnumSet.of(Modifier.PUBLIC, Modifier.FINAL), new String[]{customMapperField.asType().toString(), "mapper"});
            writer.emitStatement("this.%s = mapper", new Object[]{field});
            writer.endMethod();
            writer.emitEmptyLine();
        }
    }

    private void pushCustomMapper(TypeElement element, MethodWrapper method, Boolean immutable, boolean ignoreAbstract) {
        MappingBuilder res = null;
        String customMapperFieldName = ignoreAbstract ? "this" : this.buildMapperFieldName(element);
        InOutType inOutType = method.inOutType();
        String methodCall = String.format("%s.%s", customMapperFieldName, method.getSimpleName());
        if (immutable == null) {
            res = MappingBuilder.newCustomMapper(inOutType, methodCall);
            this.unusedCustomMappers.put(inOutType, String.format("%s.%s", element.getQualifiedName(), method.getSimpleName()));
        } else if (immutable.booleanValue()) {
            res = MappingBuilder.newCustomMapper(inOutType, methodCall);
            inOutType = new InOutType(inOutType, true);
        } else if (!immutable.booleanValue()) {
            res = MappingBuilder.newCustomMapperImmutableForUpdateGraph(inOutType, methodCall);
            inOutType = new InOutType(inOutType, false);
        }
        this.registryMap.put(inOutType, res);
    }

    private void pushMappingInterceptor(TypeElement element, MethodWrapper method) {
        String customMapperFieldName = this.buildMapperFieldName(element);
        InOutType inOutType = method.inOutArgs();
        MappingBuilder res = MappingBuilder.newMappingInterceptor(inOutType, String.format("%s.%s", customMapperFieldName, method.getSimpleName()));
        this.interceptorMap.put(inOutType, res);
        this.interceptorMap.put(new InOutType(inOutType.in(), inOutType.out(), false), res);
        this.unusedInterceptor.put(inOutType, String.format("%s.%s", element.getQualifiedName(), method.getSimpleName()));
    }

    private void collectCustomMappers() {
        List<String> customClasses = this.annotationWrapper.getAsStrings(WITH_CUSTOM);
        if (customClasses.size() > 0) {
            int mappingMethodCount = 0;
            for (String customMapper : customClasses) {
                TypeElement element = this.context.elements.getTypeElement(customMapper.replaceAll("\\.class$", ""));
                if ((mappingMethodCount += this.collectCustomMethods(element, false)) == 0) {
                    this.context.error(element, "No valid mapping method found in custom selma class %s\\n A custom mapping method is public and returns a type not void, it takes one parameter or more if you specified datasource.", customMapper);
                    continue;
                }
                TypeConstructorWrapper constructorWrapper = new TypeConstructorWrapper(this.context, element);
                if (!constructorWrapper.hasDefaultConstructor && element.getKind() != ElementKind.INTERFACE) {
                    this.context.error(element, "No default public constructor found in custom mapping class %s\\n Please add one", customMapper);
                }
                this.customMapperFields.add(element);
            }
        }
    }

    private int collectCustomMethods(TypeElement element, boolean ignoreAbstract) {
        int mappingMethodCount = 0;
        List<ExecutableElement> methods = ElementFilter.methodsIn(element.getEnclosedElements());
        HashMap<CustomMapperKey, CustomMapperEntry> customInOutTypes = new HashMap<CustomMapperKey, CustomMapperEntry>();
        for (ExecutableElement method : methods) {
            MethodWrapper methodWrapper = new MethodWrapper(method, (DeclaredType)element.asType(), this.context);
            if (ignoreAbstract && methodWrapper.isAbstract() || !this.isValidCustomMapping(methodWrapper)) continue;
            if (methodWrapper.isCustomMapper()) {
                this.pushCustomMapper(element, methodWrapper, null, ignoreAbstract);
                this.addCustomInOutType(customInOutTypes, methodWrapper);
            } else {
                this.pushMappingInterceptor(element, methodWrapper);
            }
            ++mappingMethodCount;
        }
        this.addMissingMappings(customInOutTypes, element, ignoreAbstract);
        return mappingMethodCount;
    }

    private void addMissingMappings(HashMap<CustomMapperKey, CustomMapperEntry> customInOutTypes, TypeElement element, boolean ignoreAbstract) {
        for (Map.Entry<CustomMapperKey, CustomMapperEntry> entry : customInOutTypes.entrySet()) {
            if (entry.getValue().updateGraphMethod == null) {
                this.pushCustomMapper(element, entry.getValue().immutableMethod, Boolean.TRUE, ignoreAbstract);
                continue;
            }
            if (entry.getValue().immutableMethod != null) continue;
            this.pushCustomMapper(element, entry.getValue().updateGraphMethod, Boolean.FALSE, ignoreAbstract);
        }
    }

    private void addCustomInOutType(HashMap<CustomMapperKey, CustomMapperEntry> customInOutTypes, MethodWrapper methodWrapper) {
        CustomMapperKey key = new CustomMapperKey(methodWrapper.inOutType());
        CustomMapperEntry entry1 = customInOutTypes.get(key);
        if (entry1 == null) {
            CustomMapperEntry entry = new CustomMapperEntry(methodWrapper.inOutType(), methodWrapper);
            customInOutTypes.put(key, entry);
        } else {
            CustomMapperEntry entry = new CustomMapperEntry(entry1, methodWrapper);
            customInOutTypes.put(key, entry);
        }
    }

    private String buildMapperFieldName(TypeElement element) {
        return String.format(CUSTOM_MAPPER_FIELD_TPL, element.getSimpleName());
    }

    private boolean isValidCustomMapping(MethodWrapper methodWrapper) {
        boolean res = true;
        if (MapperProcessor.exclusions.contains(methodWrapper.getSimpleName())) {
            return false;
        }
        if (!methodWrapper.element().getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.context.warn(methodWrapper.element(), "Custom mapping method should be *public* (Fix modifiers of the method) on %s", methodWrapper.getSimpleName());
            res = false;
        }
        if (methodWrapper.element().getModifiers().contains((Object)Modifier.STATIC)) {
            this.context.warn(methodWrapper.element(), "Custom mapping method can not be *static* (Fix modifiers of the method) on %s", methodWrapper.getSimpleName());
            res = false;
        }
        if (!methodWrapper.isCustomMapper() && !methodWrapper.isMappingInterceptor()) {
            this.context.warn(methodWrapper.element(), "Custom mapping method should have a return type and one or two parameters and interceptor method should be void and have two parameters (Fix method signature) on %s", methodWrapper.getSimpleName());
            res = false;
        }
        return res;
    }

    public MappingBuilder getMapper(InOutType inOutType) {
        MappingBuilder res = this.registryMap.get(inOutType);
        if (res != null) {
            this.unusedCustomMappers.remove(inOutType);
        } else if (this.parent != null) {
            res = this.parent.getMapper(inOutType);
        }
        return res;
    }

    public MappingBuilder getMappingInterceptor(InOutType inOutType) {
        MappingBuilder res = this.interceptorMap.get(inOutType);
        if (res != null) {
            this.unusedInterceptor.remove(new InOutType(inOutType, true));
        } else if (this.parent != null) {
            res = this.parent.getMappingInterceptor(inOutType);
        }
        return res;
    }

    public void reportUnused() {
        for (String field : this.unusedCustomMappers.values()) {
            this.context.warn(this.annotatedElement, "Custom mapping method \"%s\" is never used", field);
        }
        for (String field : this.unusedInterceptor.values()) {
            this.context.warn(this.annotatedElement, "Custom interceptor method \"%s\" is never used", field);
        }
    }

    public List<TypeElement> mapperFields() {
        return this.customMapperFields;
    }

    public void addFields(List<TypeElement> childFields) {
        for (TypeElement childField : childFields) {
            boolean found = false;
            for (TypeElement maperField : this.customMapperFields) {
                if (!childField.equals(maperField)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.customMapperFields.add(childField);
        }
    }

    public void addMappersElementMethods(TypeElement mapperInterface) {
        this.collectCustomMethods(mapperInterface, true);
    }

    class CustomMapperEntry {
        final MethodWrapper updateGraphMethod;
        final MethodWrapper immutableMethod;

        public CustomMapperEntry(InOutType inOutType, MethodWrapper customMethod) {
            if (inOutType.isOutPutAsParam()) {
                this.updateGraphMethod = customMethod;
                this.immutableMethod = null;
            } else {
                this.immutableMethod = customMethod;
                this.updateGraphMethod = null;
            }
        }

        public CustomMapperEntry(CustomMapperEntry entry1, MethodWrapper methodWrapper) {
            if (entry1.immutableMethod != null) {
                this.immutableMethod = entry1.immutableMethod;
                this.updateGraphMethod = methodWrapper;
            } else {
                this.updateGraphMethod = entry1.updateGraphMethod;
                this.immutableMethod = methodWrapper;
            }
        }
    }

    class CustomMapperKey {
        final TypeMirror in;
        final TypeMirror out;

        public CustomMapperKey(InOutType inOutType) {
            this.in = inOutType.in();
            this.out = inOutType.out();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomMapperKey key = (CustomMapperKey)o;
            if (!MapperProcessor.types.isSameType(this.in, key.in)) {
                return false;
            }
            return MapperProcessor.types.isSameType(this.out, key.out);
        }

        public int hashCode() {
            int result = ("" + this.in).hashCode();
            result = 31 * result + ("" + this.out).hashCode();
            return result;
        }
    }
}

