/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.textstyling.html;

import fr.opensagres.xdocreport.document.textstyling.properties.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HTMLColorParser {
    private static final Map<String, String> COLORNAME_TO_HEXADECIMAL_VALUE = Collections.unmodifiableMap(HTMLColorParser.getColornameToHexMapping());

    private static Map<String, String> getColornameToHexMapping() {
        HashMap<String, String> colornameToHexMapping = new HashMap<String, String>();
        colornameToHexMapping.put("aliceblue", "#F0F8FF");
        colornameToHexMapping.put("antiquewhite", "#FAEBD7");
        colornameToHexMapping.put("aqua", "#00FFFF");
        colornameToHexMapping.put("aquamarine", "#7FFFD4");
        colornameToHexMapping.put("azure", "#F0FFFF");
        colornameToHexMapping.put("beige", "#F5F5DC");
        colornameToHexMapping.put("bisque", "#FFE4C4");
        colornameToHexMapping.put("black", "#000000");
        colornameToHexMapping.put("blanchedalmond", "#FFEBCD");
        colornameToHexMapping.put("blue", "#0000FF");
        colornameToHexMapping.put("blueviolet", "#8A2BE2");
        colornameToHexMapping.put("brown", "#A52A2A");
        colornameToHexMapping.put("burlywood", "#DEB887");
        colornameToHexMapping.put("cadetblue", "#5F9EA0");
        colornameToHexMapping.put("chartreuse", "#7FFF00");
        colornameToHexMapping.put("chocolate", "#D2691E");
        colornameToHexMapping.put("coral", "#FF7F50");
        colornameToHexMapping.put("cornflowerblue", "#6495ED");
        colornameToHexMapping.put("cornsilk", "#FFF8DC");
        colornameToHexMapping.put("crimson", "#DC143C");
        colornameToHexMapping.put("cyan", "#00FFFF");
        colornameToHexMapping.put("darkblue", "#00008B");
        colornameToHexMapping.put("darkcyan", "#008B8B");
        colornameToHexMapping.put("darkgoldenrod", "#B8860B");
        colornameToHexMapping.put("darkgray", "#A9A9A9");
        colornameToHexMapping.put("darkgreen", "#006400");
        colornameToHexMapping.put("darkkhaki", "#BDB76B");
        colornameToHexMapping.put("darkmagenta", "#8B008B");
        colornameToHexMapping.put("darkolivegreen", "#556B2F");
        colornameToHexMapping.put("darkorange", "#FF8C00");
        colornameToHexMapping.put("darkorchid", "#9932CC");
        colornameToHexMapping.put("darkred", "#8B0000");
        colornameToHexMapping.put("darksalmon", "#E9967A");
        colornameToHexMapping.put("darkseagreen", "#8FBC8F");
        colornameToHexMapping.put("darkslateblue", "#483D8B");
        colornameToHexMapping.put("darkslategray", "#2F4F4F");
        colornameToHexMapping.put("darkturquoise", "#00CED1");
        colornameToHexMapping.put("darkviolet", "#9400D3");
        colornameToHexMapping.put("deeppink", "#FF1493");
        colornameToHexMapping.put("deepskyblue", "#00BFFF");
        colornameToHexMapping.put("dimgray", "#696969");
        colornameToHexMapping.put("dodgerblue", "#1E90FF");
        colornameToHexMapping.put("firebrick", "#B22222");
        colornameToHexMapping.put("floralwhite", "#FFFAF0");
        colornameToHexMapping.put("forestgreen", "#228B22");
        colornameToHexMapping.put("fuchsia", "#FF00FF");
        colornameToHexMapping.put("gainsboro", "#DCDCDC");
        colornameToHexMapping.put("ghostwhite", "#F8F8FF");
        colornameToHexMapping.put("gold", "#FFD700");
        colornameToHexMapping.put("goldenrod", "#DAA520");
        colornameToHexMapping.put("gray", "#808080");
        colornameToHexMapping.put("green", "#008000");
        colornameToHexMapping.put("greenyellow", "#ADFF2F");
        colornameToHexMapping.put("honeydew", "#F0FFF0");
        colornameToHexMapping.put("hotpink", "#FF69B4");
        colornameToHexMapping.put("indianred", "#CD5C5C");
        colornameToHexMapping.put("indigo", "#4B0082");
        colornameToHexMapping.put("ivory", "#FFFFF0");
        colornameToHexMapping.put("khaki", "#F0E68C");
        colornameToHexMapping.put("lavender", "#E6E6FA");
        colornameToHexMapping.put("lavenderblush", "#FFF0F5");
        colornameToHexMapping.put("lawngreen", "#7CFC00");
        colornameToHexMapping.put("lemonchiffon", "#FFFACD");
        colornameToHexMapping.put("lightblue", "#ADD8E6");
        colornameToHexMapping.put("lightcoral", "#F08080");
        colornameToHexMapping.put("lightcyan", "#E0FFFF");
        colornameToHexMapping.put("lightgoldenrodyellow", "#FAFAD2");
        colornameToHexMapping.put("lightgray", "#D3D3D3");
        colornameToHexMapping.put("lightgreen", "#90EE90");
        colornameToHexMapping.put("lightpink", "#FFB6C1");
        colornameToHexMapping.put("lightsalmon", "#FFA07A");
        colornameToHexMapping.put("lightseagreen", "#20B2AA");
        colornameToHexMapping.put("lightskyblue", "#87CEFA");
        colornameToHexMapping.put("lightslategray", "#778899");
        colornameToHexMapping.put("lightsteelblue", "#B0C4DE");
        colornameToHexMapping.put("lightyellow", "#FFFFE0");
        colornameToHexMapping.put("lime", "#00FF00");
        colornameToHexMapping.put("limegreen", "#32CD32");
        colornameToHexMapping.put("linen", "#FAF0E6");
        colornameToHexMapping.put("maroon", "#800000");
        colornameToHexMapping.put("mediumaquamarine", "#66CDAA");
        colornameToHexMapping.put("mediumblue", "#0000CD");
        colornameToHexMapping.put("mediumorchid", "#BA55D3");
        colornameToHexMapping.put("mediumpurple", "#9370DB");
        colornameToHexMapping.put("mediumseagreen", "#3CB371");
        colornameToHexMapping.put("mediumslateblue", "#7B68EE");
        colornameToHexMapping.put("mediumspringgreen", "#00FA9A");
        colornameToHexMapping.put("mediumturquoise", "#48D1CC");
        colornameToHexMapping.put("mediumvioletred", "#C71585");
        colornameToHexMapping.put("midnightblue", "#191970");
        colornameToHexMapping.put("mintcream", "#F5FFFA");
        colornameToHexMapping.put("mistyrose", "#FFE4E1");
        colornameToHexMapping.put("moccasin", "#FFE4B5");
        colornameToHexMapping.put("navajowhite", "#FFDEAD");
        colornameToHexMapping.put("navy", "#000080");
        colornameToHexMapping.put("oldlace", "#FDF5E6");
        colornameToHexMapping.put("olive", "#808000");
        colornameToHexMapping.put("olivedrab", "#6B8E23");
        colornameToHexMapping.put("orange", "#FFA500");
        colornameToHexMapping.put("orangered", "#FF4500");
        colornameToHexMapping.put("orchid", "#DA70D6");
        colornameToHexMapping.put("palegoldenrod", "#EEE8AA");
        colornameToHexMapping.put("palegreen", "#98FB98");
        colornameToHexMapping.put("paleturquoise", "#AFEEEE");
        colornameToHexMapping.put("palevioletred", "#DB7093");
        colornameToHexMapping.put("papayawhip", "#FFEFD5");
        colornameToHexMapping.put("peachpuff", "#FFDAB9");
        colornameToHexMapping.put("peru", "#CD853F");
        colornameToHexMapping.put("pink", "#FFC0CB");
        colornameToHexMapping.put("plum", "#DDA0DD");
        colornameToHexMapping.put("powderblue", "#B0E0E6");
        colornameToHexMapping.put("purple", "#800080");
        colornameToHexMapping.put("red", "#FF0000");
        colornameToHexMapping.put("rosybrown", "#BC8F8F");
        colornameToHexMapping.put("royalblue", "#4169E1");
        colornameToHexMapping.put("saddlebrown", "#8B4513");
        colornameToHexMapping.put("salmon", "#FA8072");
        colornameToHexMapping.put("sandybrown", "#F4A460");
        colornameToHexMapping.put("seagreen", "#2E8B57");
        colornameToHexMapping.put("seashell", "#FFF5EE");
        colornameToHexMapping.put("sienna", "#A0522D");
        colornameToHexMapping.put("silver", "#C0C0C0");
        colornameToHexMapping.put("skyblue", "#87CEEB");
        colornameToHexMapping.put("slateblue", "#6A5ACD");
        colornameToHexMapping.put("slategray", "#708090");
        colornameToHexMapping.put("snow", "#FFFAFA");
        colornameToHexMapping.put("springgreen", "#00FF7F");
        colornameToHexMapping.put("steelblue", "#4682B4");
        colornameToHexMapping.put("tan", "#D2B48C");
        colornameToHexMapping.put("teal", "#008080");
        colornameToHexMapping.put("thistle", "#D8BFD8");
        colornameToHexMapping.put("tomato", "#FF6347");
        colornameToHexMapping.put("turquoise", "#40E0D0");
        colornameToHexMapping.put("violet", "#EE82EE");
        colornameToHexMapping.put("wheat", "#F5DEB3");
        colornameToHexMapping.put("white", "#FFFFFF");
        colornameToHexMapping.put("whitesmoke", "#F5F5F5");
        colornameToHexMapping.put("yellow", "#FFFF00");
        colornameToHexMapping.put("yellowgreen", "#9ACD32");
        return colornameToHexMapping;
    }

    public static Color parse(String colorString) {
        if (colorString == null || colorString.isEmpty()) {
            return null;
        }
        if (colorString.startsWith("rgb")) {
            return HTMLColorParser.parseRgb(colorString);
        }
        if (colorString.startsWith("#") && colorString.length() == 7) {
            return HTMLColorParser.parseHexadecimalValues(colorString);
        }
        if (colorString.startsWith("hsl")) {
            return HTMLColorParser.parseHsl(colorString);
        }
        if (HTMLColorParser.isColorname(colorString)) {
            return HTMLColorParser.parseHexadecimalValues(HTMLColorParser.colornameToHexadecimalValue(colorString));
        }
        return null;
    }

    private static Color parseRgb(String colorString) {
        String color = colorString.replaceAll("[^\\d,]*", "");
        String[] rgbColor = color.split(",");
        if (rgbColor.length == 3) {
            try {
                return new Color(Integer.parseInt(rgbColor[0]), Integer.parseInt(rgbColor[1]), Integer.parseInt(rgbColor[2]));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static Color parseHsl(String colorString) {
        String color = colorString.replaceAll("[^\\d,]*", "");
        String[] hslColor = color.split(",");
        if (hslColor.length == 3) {
            try {
                int[] rgbColor = HTMLColorParser.hslToRgb(new int[]{Integer.parseInt(hslColor[0]), Integer.parseInt(hslColor[1]), Integer.parseInt(hslColor[2])});
                return new Color(rgbColor[0], rgbColor[1], rgbColor[2]);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private static Color parseHexadecimalValues(String colorString) {
        String red = colorString.substring(1, 3);
        String green = colorString.substring(3, 5);
        String blue = colorString.substring(5, 7);
        try {
            return new Color(Integer.parseInt(red, 16), Integer.parseInt(green, 16), Integer.parseInt(blue, 16));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isColorname(String colorValueCssText) {
        return COLORNAME_TO_HEXADECIMAL_VALUE.containsKey(colorValueCssText.toLowerCase());
    }

    private static String colornameToHexadecimalValue(String colorValueCssText) {
        return COLORNAME_TO_HEXADECIMAL_VALUE.get(colorValueCssText.toLowerCase());
    }

    static int[] hslToRgb(int[] hsl) {
        int b;
        int g;
        int r;
        float h = (float)(hsl[0] % 360) / 360.0f;
        float s = (float)hsl[1] / 100.0f;
        float l = (float)hsl[2] / 100.0f;
        if (s == 0.0f) {
            r = (int)(l * 255.0f);
            g = (int)(l * 255.0f);
            b = (int)(l * 255.0f);
        } else {
            float q = (double)l < 0.5 ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = (int)(HTMLColorParser.hue2rgb(p, q, h + 0.33333334f) * 255.0f);
            g = (int)(HTMLColorParser.hue2rgb(p, q, h) * 255.0f);
            b = (int)(HTMLColorParser.hue2rgb(p, q, h - 0.33333334f) * 255.0f);
        }
        return new int[]{r, g, b};
    }

    private static float hue2rgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t * 6.0f < 1.0f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t * 2.0f < 1.0f) {
            return q;
        }
        if (t * 3.0f < 2.0f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }
}

