/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.xdocreport;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.struts2.views.xdocreport.AbstractPopulateContext;

public class LazyPopulateContext
extends AbstractPopulateContext {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final LazyPopulateContext INSTANCE = new LazyPopulateContext();

    public static LazyPopulateContext getInstance() {
        return INSTANCE;
    }

    protected PropertyDescriptor[] getPropertyDescriptors(Object pojo) throws Exception {
        BeanInfo info = Introspector.getBeanInfo(pojo.getClass());
        return info.getPropertyDescriptors();
    }

    protected Object getSimpleProperty(Object pojo, PropertyDescriptor descriptor) throws Exception {
        Method readMethod = this.getReadMethod(pojo.getClass(), descriptor);
        if (readMethod == null) {
            return null;
        }
        return readMethod.invoke(pojo, EMPTY_OBJECT_ARRAY);
    }

    protected Method getReadMethod(Class clazz, PropertyDescriptor descriptor) {
        return this.getAccessibleMethod(clazz, descriptor.getReadMethod());
    }

    protected Method getAccessibleMethod(Class clazz, Method method) {
        if (method == null) {
            return null;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        boolean sameClass = true;
        if (clazz == null) {
            clazz = method.getDeclaringClass();
        } else {
            sameClass = clazz.equals(method.getDeclaringClass());
            if (!method.getDeclaringClass().isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(clazz.getName() + " is not assignable from " + method.getDeclaringClass().getName());
            }
        }
        if (Modifier.isPublic(clazz.getModifiers())) {
            if (sameClass || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                // empty if block
            }
            return method;
        }
        return method;
    }
}

