/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.xdocreport;

import com.opensymphony.xwork2.ActionInvocation;
import fr.opensagres.xdocreport.converter.ConverterTypeTo;
import fr.opensagres.xdocreport.converter.IConverter;
import fr.opensagres.xdocreport.converter.IURIResolver;
import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.converter.XDocConverterException;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.document.web.WEBURIResolver;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.dispatcher.StrutsResultSupport;
import org.apache.struts2.views.xdocreport.ActionInvocationUtils;
import org.apache.struts2.views.xdocreport.LocationType;
import org.apache.struts2.views.xdocreport.XDocReportInitializerAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXDocReportResult
extends StrutsResultSupport {
    private static final long serialVersionUID = -3844927561499091875L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractXDocReportResult.class);
    private static final String SAT_6_MAY_1995_12_00_00_GMT = "Sat, 6 May 1995 12:00:00 GMT";
    private static final String EXPIRES = "Expires";
    private static final String POST_CHECK_0_PRE_CHECK_0 = "post-check=0, pre-check=0";
    private static final String NO_CACHE = "no-cache";
    private static final String PRAGMA = "Pragma";
    private static final String NO_STORE_NO_CACHE_MUST_REVALIDATE = "no-store, no-cache, must-revalidate";
    private static final String CACHE_CONTROL_HTTP_HEADER = "Cache-Control";
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final String ATTACHMENT_FILENAME = "attachment; filename=\"";
    private static final String WEB_URI_RESOLVER_DATA_KEY = WEBURIResolver.class.getName();
    protected static final String ACTION_KEY = "#action";
    private static final Map<Class, Boolean> isXDocReportInitializerAwareClassCache = new HashMap<Class, Boolean>();
    public static final String LAST_MODIFIED = AbstractXDocReportResult.class.getSimpleName() + "_LAST_MODIFIED";
    private String templateEngine = TemplateEngineKind.Velocity.name();
    private String converter = null;
    private String[] expressions = new String[]{"#action"};
    private String trackLastModified = "false";
    private String download = "true";
    private String fieldsAsList = null;

    public void setTemplateEngine(String templateEngine) {
        this.templateEngine = templateEngine;
    }

    public String getTemplateEngine() {
        return this.templateEngine;
    }

    public void setConverter(String converter) {
        this.converter = converter;
    }

    public String getConverter() {
        return this.converter;
    }

    public void setExpression(String expression) {
        this.expressions = expression.split(",");
    }

    public String[] getExpressions() {
        return this.expressions;
    }

    public void setTrackLastModified(String trackLastModified) {
        this.trackLastModified = trackLastModified;
    }

    public String getTrackLastModified() {
        return this.trackLastModified;
    }

    public void setDownload(String download) {
        this.download = download;
    }

    public String getDownload() {
        return this.download;
    }

    public void setFieldAsList(String fieldAsList) {
        this.fieldsAsList = fieldAsList;
    }

    public String[] getFieldsAsList() {
        if (StringUtils.isEmpty((String)this.fieldsAsList)) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        return this.fieldsAsList.split(",");
    }

    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        String location = this.getLocation(finalLocation, invocation);
        long startTime = -1L;
        if (LOG.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            LOG.debug("Start XDocReportResult for location=" + location + ", templateEngine" + this.getTemplateEngine());
        }
        try {
            XDocReportRegistry registry = XDocReportRegistry.getRegistry();
            IXDocReport report = this.getReport(registry, location, invocation);
            if (report == null) {
                throw new XDocReportException("Cannot get XDoc Report for location=" + location);
            }
            IContext context = report.createContext();
            this.populateContext(report, context, location, invocation);
            Options options = this.getOptionsConverter(report, location, invocation);
            if (options == null) {
                this.doProcessReport(report, context, location, invocation);
            } else {
                this.doProcessReportWithConverter(report, context, options, location, invocation);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("End XDocReportResult with SUCCESS for location=" + location + ", templateEngine" + this.getTemplateEngine() + " done in " + (System.currentTimeMillis() - startTime) + "ms");
            }
        }
        catch (Throwable e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("End XDocReportResult with ERROR for location=" + location + ", templateEngine" + this.getTemplateEngine() + " done in " + (System.currentTimeMillis() - startTime) + "ms", e);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new ServletException(e);
        }
    }

    protected IXDocReport getReport(XDocReportRegistry registry, String location, ActionInvocation invocation) throws ServletException, IOException {
        InputStream sourceStream;
        boolean trackLastModified = this.isTrackLastModified(invocation);
        String reportId = this.getReportId(location);
        IXDocReport report = registry.getReport(reportId);
        if (report != null && !trackLastModified) {
            return report;
        }
        LocationType locationType = LocationType.getLocationType(location);
        if (report != null && locationType == LocationType.CLASSPATH) {
            return report;
        }
        File sourceFile = this.getSourceFile(location, locationType, invocation);
        if (report != null) {
            if (sourceFile == null) {
                return report;
            }
            Long lastModified = (Long)report.getData(LAST_MODIFIED);
            if (lastModified == null) {
                return report;
            }
            if (lastModified >= sourceFile.lastModified()) {
                return report;
            }
            registry.unregisterReport(reportId);
        }
        if ((sourceStream = this.getSourceStream(location, locationType, sourceFile, invocation)) == null) {
            throw new IOException("Stream null for location=" + location);
        }
        try {
            report = registry.loadReport(sourceStream, reportId, this.getTemplateEngine(invocation));
            report.setFieldsMetadata(this.getFieldsMetadata(report, location, invocation));
            Object action = invocation.getStack().findValue(ACTION_KEY);
            XDocReportInitializerAware initializer = this.getXDocReportInitializerAware(action);
            if (initializer != null) {
                initializer.initialize(report);
            }
            report.setData(LAST_MODIFIED, (Object)System.currentTimeMillis());
            return report;
        }
        catch (IOException e) {
            throw new ServletException("Inputstream", (Throwable)e);
        }
        catch (XDocReportException e) {
            throw new ServletException("Inputstream", (Throwable)e);
        }
    }

    protected boolean isTrackLastModified(ActionInvocation invocation) {
        String trackLastModified = this.getTrackLastModified();
        trackLastModified = this.getValue(trackLastModified, invocation);
        return StringUtils.asBoolean((String)trackLastModified, (boolean)false);
    }

    protected boolean isDownload(ActionInvocation invocation) {
        String download = this.getDownload();
        download = this.getValue(download, invocation);
        return StringUtils.asBoolean((String)download, (boolean)true);
    }

    protected String getLocation(String finalLocation, ActionInvocation invocation) {
        return this.getValue(finalLocation, invocation);
    }

    protected String getTemplateEngine(ActionInvocation invocation) {
        String templateEngine = this.getTemplateEngine();
        return this.getValue(templateEngine, invocation);
    }

    protected String getValue(String value, ActionInvocation invocation) {
        if (StringUtils.isEmpty((String)value)) {
            return value;
        }
        if (value.startsWith("#")) {
            return invocation.getStack().findString(value);
        }
        return value;
    }

    protected String getReportId(String finalLocation) {
        StringBuilder reportId = new StringBuilder(StringUtils.replaceAll((String)finalLocation, (String)"/", (String)"_"));
        reportId.append("_");
        reportId.append(this.getTemplateEngine());
        return reportId.toString();
    }

    protected InputStream getSourceStream(String finalLocation, LocationType locationType, File sourceFile, ActionInvocation invocation) throws IOException {
        switch (locationType) {
            case CLASSPATH: {
                String location = locationType.getLocation(finalLocation);
                return this.getSourceStreamFromClasspath(location);
            }
            case FILESYSTEM: {
                return new FileInputStream(sourceFile);
            }
        }
        return new FileInputStream(sourceFile);
    }

    protected File getSourceFile(String finalLocation, LocationType locationType, ActionInvocation invocation) {
        String location = locationType.getLocation(finalLocation);
        switch (locationType) {
            case CLASSPATH: {
                return null;
            }
            case FILESYSTEM: {
                return new File(location);
            }
        }
        ServletContext servletContext = ActionInvocationUtils.getServletContext(invocation);
        return new File(servletContext.getRealPath(location));
    }

    protected InputStream getSourceStreamFromClasspath(String path) {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        return cl.getResourceAsStream(path);
    }

    protected FieldsMetadata getFieldsMetadata(IXDocReport report, String location, ActionInvocation invocation) {
        String[] fieldsAsList = this.getFieldsAsList();
        if (fieldsAsList != null && fieldsAsList.length > 0) {
            FieldsMetadata fieldsMetadata = new FieldsMetadata();
            for (int i = 0; i < fieldsAsList.length; ++i) {
                fieldsMetadata.addFieldAsList(this.getValue(fieldsAsList[i], invocation));
            }
            return fieldsMetadata;
        }
        return null;
    }

    protected void doProcessReport(IXDocReport report, IContext context, String finalLocation, ActionInvocation invocation) throws XDocReportException, IOException {
        HttpServletResponse response = ActionInvocationUtils.getResponse(invocation);
        this.prepareHTTPResponse(report.getId(), finalLocation, report.getMimeMapping(), invocation, ActionInvocationUtils.getRequest(invocation), response);
        report.process(context, (OutputStream)response.getOutputStream());
    }

    protected void doProcessReportWithConverter(IXDocReport report, IContext context, Options options, String finalLocation, ActionInvocation invocation) throws XDocConverterException, XDocReportException, IOException {
        HttpServletResponse response = ActionInvocationUtils.getResponse(invocation);
        IConverter converter = report.getConverter(options);
        this.prepareHTTPResponse(report.getId(), finalLocation, converter.getMimeMapping(), invocation, ActionInvocationUtils.getRequest(invocation), response);
        report.convert(context, options, (OutputStream)response.getOutputStream());
    }

    protected Options getOptionsConverter(IXDocReport report, String finalLocation, ActionInvocation invocation) {
        String converterId = this.getConverter(invocation);
        if (StringUtils.isEmpty((String)converterId)) {
            return null;
        }
        Options options = null;
        int index = converterId.lastIndexOf(95);
        if (index != -1) {
            String to = converterId.substring(0, index);
            String via = converterId.substring(index + 1, converterId.length());
            options = Options.getTo((String)to).via(via);
        } else {
            options = Options.getTo((String)converterId);
        }
        this.prepareOptions(options, report, converterId, finalLocation, invocation);
        return options;
    }

    protected String getConverter(ActionInvocation invocation) {
        String converter = this.getConverter();
        return this.getValue(converter, invocation);
    }

    protected void prepareOptions(Options options, IXDocReport report, String converterId, String finalLocation, ActionInvocation invocation) {
        if (ConverterTypeTo.FO.name().equals(options.getTo()) || ConverterTypeTo.XHTML.name().equals(options.getTo())) {
            options.setProperty(IURIResolver.class.getName(), (Object)this.createWEBURIResolver(report, converterId, finalLocation, invocation));
        }
    }

    protected IURIResolver createWEBURIResolver(IXDocReport report, String converterId, String finalLocation, ActionInvocation invocation) {
        WEBURIResolver resolver = (WEBURIResolver)report.getData(WEB_URI_RESOLVER_DATA_KEY);
        if (resolver == null) {
            resolver = new WEBURIResolver(report.getId(), ActionInvocationUtils.getRequest(invocation));
            report.setData(WEB_URI_RESOLVER_DATA_KEY, (Object)resolver);
        }
        return resolver;
    }

    protected void prepareHTTPResponse(String reportId, String finalLocation, MimeMapping mimeMapping, ActionInvocation invocation, HttpServletRequest request, HttpServletResponse response) {
        if (mimeMapping != null) {
            response.setContentType(mimeMapping.getMimeType());
        }
        if (this.isGenerateContentDisposition(reportId, mimeMapping, invocation)) {
            String contentDisposition;
            String sourceFileName = finalLocation;
            int index = finalLocation.lastIndexOf(47);
            if (index != -1) {
                sourceFileName = finalLocation.substring(index + 1, finalLocation.length());
            }
            if (StringUtils.isNotEmpty((String)(contentDisposition = this.getContentDisposition(sourceFileName, mimeMapping, request)))) {
                response.setHeader(CONTENT_DISPOSITION_HEADER, contentDisposition.toString());
            }
        }
        if (this.isDisableHTTPResponseCache()) {
            this.disableHTTPResponseCache(response);
        }
    }

    protected boolean isGenerateContentDisposition(String reportId, MimeMapping mimeMapping, ActionInvocation invocation) {
        return this.isDownload(invocation);
    }

    protected void prepareHTTPResponse(String reportId, String entryName, ActionInvocation invocation, HttpServletRequest request, HttpServletResponse response) {
        String contentDisposition;
        if (this.isGenerateContentDisposition(reportId, null, invocation) && StringUtils.isNotEmpty((String)(contentDisposition = this.getContentDisposition(entryName)))) {
            response.setHeader(CONTENT_DISPOSITION_HEADER, contentDisposition.toString());
        }
        if (this.isDisableHTTPResponseCache()) {
            this.disableHTTPResponseCache(response);
        }
    }

    protected boolean isDisableHTTPResponseCache() {
        return true;
    }

    protected String getContentDisposition(String sourceFileName, MimeMapping mimeMapping, HttpServletRequest request) {
        if (mimeMapping != null) {
            String fileName = mimeMapping.formatFileName(sourceFileName);
            return this.getContentDisposition(fileName);
        }
        return null;
    }

    protected String getContentDisposition(String fileName) {
        StringBuilder contentDisposition = new StringBuilder(ATTACHMENT_FILENAME);
        contentDisposition.append(fileName);
        contentDisposition.append("\"");
        return contentDisposition.toString();
    }

    protected void disableHTTPResponseCache(HttpServletResponse response) {
        response.setHeader(EXPIRES, SAT_6_MAY_1995_12_00_00_GMT);
        response.setHeader(CACHE_CONTROL_HTTP_HEADER, NO_STORE_NO_CACHE_MUST_REVALIDATE);
        response.addHeader(CACHE_CONTROL_HTTP_HEADER, POST_CHECK_0_PRE_CHECK_0);
        response.setHeader(PRAGMA, NO_CACHE);
    }

    protected XDocReportInitializerAware getXDocReportInitializerAware(Object action) {
        if (action == null) {
            return null;
        }
        Boolean result = isXDocReportInitializerAwareClassCache.get(action.getClass());
        if (result == null) {
            result = action instanceof XDocReportInitializerAware;
            isXDocReportInitializerAwareClassCache.put(action.getClass(), result);
        }
        if (result.booleanValue()) {
            return (XDocReportInitializerAware)action;
        }
        return null;
    }

    protected abstract void populateContext(IXDocReport var1, IContext var2, String var3, ActionInvocation var4) throws Exception;
}

