/*
 * Decompiled with CFR 0.152.
 */
package fr.flowarg.flowcompat;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class Platform {
    public static final String OS = System.getProperty("os.name").toLowerCase();

    public static void exit(int exitCode, boolean halt) {
        if (halt) {
            Runtime.getRuntime().halt(exitCode);
        } else {
            System.exit(exitCode);
        }
    }

    public static boolean isOnMac() {
        AtomicBoolean bool = new AtomicBoolean(false);
        EnumOS.MAC.getNames().forEach(alias -> {
            if (OS.contains((CharSequence)alias)) {
                bool.set(true);
            }
        });
        return bool.get();
    }

    public static boolean isOnWindows() {
        AtomicBoolean bool = new AtomicBoolean(false);
        EnumOS.WINDOWS.getNames().forEach(alias -> {
            if (OS.contains((CharSequence)alias)) {
                bool.set(true);
            }
        });
        return bool.get();
    }

    public static boolean isOnLinux() {
        AtomicBoolean bool = new AtomicBoolean(false);
        EnumOS.LINUX.getNames().forEach(alias -> {
            if (OS.contains((CharSequence)alias)) {
                bool.set(true);
            }
        });
        return bool.get();
    }

    public static EnumOS getCurrentPlatform() {
        for (EnumOS en : EnumOS.values()) {
            AtomicReference<Object> result = new AtomicReference<Object>(null);
            if (en.getNames().contains(OS)) {
                result.set(en);
            } else {
                en.getNames().forEach(s -> {
                    if (OS.contains((CharSequence)s)) {
                        result.set(en);
                    }
                });
            }
            if (result.get() == null) continue;
            return result.get();
        }
        return null;
    }

    public static String getArch() {
        return System.getProperty("sun.arch.data.model");
    }

    public static enum EnumOS {
        MAC(Arrays.asList("mac", "osx", "macos", "darwin")),
        WINDOWS(Arrays.asList("windows", "win")),
        LINUX(Arrays.asList("linux", "unix"));

        private final List<String> names;

        private EnumOS(List<String> names) {
            this.names = names;
        }

        public List<String> getNames() {
            return this.names;
        }
    }
}

