/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import fr.brouillard.oss.jgitver.BranchingPolicy;
import fr.brouillard.oss.jgitver.GitVersionCalculator;
import fr.brouillard.oss.jgitver.LookupPolicy;
import fr.brouillard.oss.jgitver.Strategies;
import fr.brouillard.oss.jgitver.Version;
import fr.brouillard.oss.jgitver.impl.Commit;
import fr.brouillard.oss.jgitver.impl.ConfigurableVersionStrategy;
import fr.brouillard.oss.jgitver.impl.DistanceCalculator;
import fr.brouillard.oss.jgitver.impl.GitUtils;
import fr.brouillard.oss.jgitver.impl.Lambdas;
import fr.brouillard.oss.jgitver.impl.MavenVersionStrategy;
import fr.brouillard.oss.jgitver.impl.Pair;
import fr.brouillard.oss.jgitver.impl.PatternVersionStrategy;
import fr.brouillard.oss.jgitver.impl.TagDateExtractor;
import fr.brouillard.oss.jgitver.impl.VersionNamingConfiguration;
import fr.brouillard.oss.jgitver.impl.VersionStrategy;
import fr.brouillard.oss.jgitver.impl.metadata.MetadataHolder;
import fr.brouillard.oss.jgitver.metadata.Metadatas;
import fr.brouillard.oss.jgitver.metadata.TagType;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class GitVersionCalculatorImpl
implements GitVersionCalculator {
    private MetadataHolder metadatas;
    private Repository repository;
    private boolean mavenLike = false;
    private boolean autoIncrementPatch = false;
    private boolean useDistance = true;
    private boolean useGitCommitId = false;
    private boolean useGitCommitTimestamp = false;
    private boolean useDirty = false;
    private boolean useLongFormat = false;
    private boolean useSnapshot = false;
    private int gitCommitIdLength = 8;
    private int maxDepth = Integer.MAX_VALUE;
    private List<BranchingPolicy> qualifierBranchingPolicies;
    private boolean useDefaultBranchingPolicy = true;
    private Strategies versionStrategy = null;
    private String tagVersionPattern = null;
    private String versionPattern = null;
    private LookupPolicy lookupPolicy = LookupPolicy.MAX;
    private final File gitRepositoryLocation;
    private final Function<Ref, ObjectId> refToObjectIdFunction = r -> r.getPeeledObjectId() != null ? r.getPeeledObjectId() : r.getObjectId();
    private boolean computationRequired = true;
    private Version computedVersion;
    private String computedHeadSHA1;
    private final SimpleDateFormat dtfmt;
    private Pattern findTagVersionPattern = VersionNamingConfiguration.DEFAULT_FIND_TAG_VERSION_PATTERN;

    GitVersionCalculatorImpl(File gitRepositoryLocation) throws IOException {
        this.gitRepositoryLocation = gitRepositoryLocation;
        this.dtfmt = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy Z", Locale.US);
        this.setNonQualifierBranches("master");
    }

    private Repository openRepository() throws IOException {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        return ((FileRepositoryBuilder)builder.findGitDir(this.gitRepositoryLocation)).build();
    }

    private void computeVersion() {
        this.metadatas = new MetadataHolder();
        try {
            this.repository = this.openRepository();
        }
        catch (Exception ex) {
            this.setComputedVersion(Version.NOT_GIT_VERSION);
            return;
        }
        try (Git git = new Git(this.repository);){
            VersionStrategy strategy;
            LinkedList<BranchingPolicy> policiesToUse = new LinkedList<BranchingPolicy>(this.qualifierBranchingPolicies);
            if (this.useDefaultBranchingPolicy) {
                policiesToUse.add(BranchingPolicy.DEFAULT_FALLBACK);
            }
            VersionNamingConfiguration vnc = new VersionNamingConfiguration(this.findTagVersionPattern, policiesToUse.toArray(new BranchingPolicy[policiesToUse.size()]));
            if (this.versionStrategy == null) {
                this.versionStrategy = this.mavenLike ? Strategies.MAVEN : Strategies.CONFIGURABLE;
            }
            switch (this.versionStrategy) {
                case MAVEN: {
                    strategy = new MavenVersionStrategy(vnc, this.repository, git, this.metadatas).setUseDirty(this.useDirty);
                    break;
                }
                case CONFIGURABLE: {
                    strategy = new ConfigurableVersionStrategy(vnc, this.repository, git, this.metadatas).setAutoIncrementPatch(this.autoIncrementPatch).setUseDistance(this.useDistance).setUseDirty(this.useDirty).setUseGitCommitId(this.useGitCommitId).setGitCommitIdLength(this.gitCommitIdLength).setUseCommitTimestamp(this.useGitCommitTimestamp).setUseLongFormat(this.useLongFormat).setUseSnapshot(this.useSnapshot);
                    break;
                }
                case PATTERN: {
                    strategy = new PatternVersionStrategy(vnc, this.repository, git, this.metadatas).setAutoIncrementPatch(this.autoIncrementPatch).setVersionPattern(this.versionPattern).setTagVersionPattern(this.tagVersionPattern);
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown strategy: " + (Object)((Object)this.versionStrategy));
                }
            }
            strategy.setSearchDepthLimit(this.maxDepth);
            Version calculatedVersion = this.buildVersion(git, strategy);
            this.setComputedVersion(calculatedVersion);
        }
    }

    @Override
    public Version getVersionObject(boolean forceComputation) {
        if (forceComputation) {
            this.computeVersion();
        }
        return this.getVersionObject();
    }

    @Override
    public Version getVersionObject() {
        if (this.needToRecompute()) {
            this.computeVersion();
        }
        return this.computedVersion;
    }

    private boolean needToRecompute() {
        if (this.computationRequired || this.repository == null) {
            return true;
        }
        try {
            ObjectId head = this.repository.resolve("HEAD");
            String actualHeadSHA1 = head != null ? head.getName() : "";
            return !actualHeadSHA1.equals(this.computedHeadSHA1);
        }
        catch (IOException e) {
            throw new IllegalStateException("failure to retrieve actual HEAD SHA1", e);
        }
    }

    private void setComputedVersion(Version computedVersion) {
        this.computedVersion = computedVersion;
        try {
            if (this.repository != null) {
                ObjectId head = this.repository.resolve("HEAD");
                this.computedHeadSHA1 = head != null ? head.getName() : "";
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("failure to retrieve current HEAD SHA1", e);
        }
        this.computationRequired = false;
    }

    private boolean hasPatchVersionBeenIncremented(VersionStrategy strategy, Version calculatedVersion) {
        if (Version.EMPTY_REPOSITORY_VERSION.equals(calculatedVersion)) {
            return false;
        }
        return (this.autoIncrementPatch || strategy instanceof MavenVersionStrategy) && this.metadatas.meta(Metadatas.HEAD_VERSION_TAGS).get().isEmpty();
    }

    private void provideNextVersionsMetadatas(Version calculatedVersion, boolean patchIsIncremented) {
        Version unqualifiedCalculatedVersion = calculatedVersion.noQualifier();
        Version baseVersion = Version.parse(this.metadatas.meta(Metadatas.BASE_VERSION).get());
        Version unqualifiedBaseVersion = baseVersion.noQualifier();
        if (baseVersion.isSnapshot() || TagType.LIGHTWEIGHT.name().equals(this.metadatas.meta(Metadatas.BASE_TAG_TYPE).orElse(null))) {
            this.metadatas.registerMetadata(Metadatas.NEXT_PATCH_VERSION, unqualifiedBaseVersion.toString());
            if (unqualifiedBaseVersion.getPatch() == 0) {
                this.metadatas.registerMetadata(Metadatas.NEXT_MINOR_VERSION, unqualifiedBaseVersion.toString());
            } else {
                this.metadatas.registerMetadata(Metadatas.NEXT_MINOR_VERSION, unqualifiedBaseVersion.incrementMinor().toString());
            }
            if (unqualifiedBaseVersion.getMinor() == 0) {
                this.metadatas.registerMetadata(Metadatas.NEXT_MAJOR_VERSION, unqualifiedBaseVersion.toString());
            } else {
                this.metadatas.registerMetadata(Metadatas.NEXT_MAJOR_VERSION, unqualifiedBaseVersion.incrementMajor().toString());
            }
        } else {
            if (patchIsIncremented && !unqualifiedCalculatedVersion.equals(unqualifiedBaseVersion)) {
                unqualifiedCalculatedVersion = new Version(unqualifiedCalculatedVersion.getMajor(), unqualifiedCalculatedVersion.getMinor(), unqualifiedCalculatedVersion.getPatch() - 1, new String[0]);
            }
            this.metadatas.registerMetadata(Metadatas.NEXT_MAJOR_VERSION, unqualifiedCalculatedVersion.incrementMajor().toString());
            this.metadatas.registerMetadata(Metadatas.NEXT_MINOR_VERSION, unqualifiedCalculatedVersion.incrementMinor().toString());
            this.metadatas.registerMetadata(Metadatas.NEXT_PATCH_VERSION, unqualifiedCalculatedVersion.incrementPatch().toString());
        }
    }

    @Override
    public String getVersion() {
        return this.getVersion(false);
    }

    @Override
    public String getVersion(boolean forceComputation) {
        return this.getVersionObject(forceComputation).toString();
    }

    private Version buildVersion(Git git, VersionStrategy<?> strategy) {
        try {
            boolean dirty = GitUtils.isDirty(git);
            this.metadatas.registerMetadata(Metadatas.DIRTY, "" + dirty);
            if (dirty) {
                this.metadatas.registerMetadata(Metadatas.DIRTY_TEXT, "dirty");
            }
            List allTags = git.tagList().call().stream().map(this::peel).collect(Collectors.toCollection(ArrayList::new));
            Collections.reverse(allTags);
            this.metadatas.registerMetadataTags(Metadatas.ALL_TAGS, allTags.stream());
            this.metadatas.registerMetadataTags(Metadatas.ALL_ANNOTATED_TAGS, allTags.stream().filter(GitUtils::isAnnotated));
            this.metadatas.registerMetadataTags(Metadatas.ALL_LIGHTWEIGHT_TAGS, allTags.stream().filter(Lambdas.as(GitUtils::isAnnotated).negate()));
            List allVersionTags = allTags.stream().filter(strategy::isVersionTag).collect(Collectors.toCollection(ArrayList::new));
            List<Ref> normals = allVersionTags.stream().filter(GitUtils::isAnnotated).collect(Collectors.toList());
            List<Ref> lights = allVersionTags.stream().filter(Lambdas.as(GitUtils::isAnnotated).negate()).collect(Collectors.toList());
            this.metadatas.registerMetadataTags(Metadatas.ALL_VERSION_TAGS, allVersionTags.stream());
            this.metadatas.registerMetadataTags(Metadatas.ALL_VERSION_ANNOTATED_TAGS, normals.stream());
            this.metadatas.registerMetadataTags(Metadatas.ALL_VERSION_LIGHTWEIGHT_TAGS, lights.stream());
            ObjectId rootId = this.repository.resolve("HEAD");
            if (rootId == null) {
                return Version.EMPTY_REPOSITORY_VERSION;
            }
            git.log().add((AnyObjectId)rootId).setMaxCount(1).call().spliterator().tryAdvance(rc -> {
                PersonIdent commitInfo = rc.getAuthorIdent();
                this.metadatas.registerMetadata(Metadatas.HEAD_COMMITTER_NAME, commitInfo.getName());
                this.metadatas.registerMetadata(Metadatas.HEAD_COMMITER_EMAIL, commitInfo.getEmailAddress());
                this.dtfmt.setTimeZone(commitInfo.getTimeZone());
                this.metadatas.registerMetadata(Metadatas.HEAD_COMMIT_DATETIME, this.dtfmt.format(commitInfo.getWhen()));
            });
            this.metadatas.registerMetadataTags(Metadatas.HEAD_TAGS, GitUtils.tagsOf(allTags, rootId).stream());
            this.metadatas.registerMetadataTags(Metadatas.HEAD_ANNOTATED_TAGS, GitUtils.tagsOf(allTags.stream().filter(GitUtils::isAnnotated).collect(Collectors.toList()), rootId).stream());
            this.metadatas.registerMetadataTags(Metadatas.HEAD_LIGHTWEIGHT_TAGS, GitUtils.tagsOf(allTags.stream().filter(Lambdas.as(GitUtils::isAnnotated).negate()).collect(Collectors.toList()), rootId).stream());
            this.metadatas.registerMetadataTags(Metadatas.HEAD_VERSION_TAGS, GitUtils.tagsOf(allVersionTags, rootId).stream());
            this.metadatas.registerMetadataTags(Metadatas.HEAD_VERSION_ANNOTATED_TAGS, GitUtils.tagsOf(allVersionTags.stream().filter(GitUtils::isAnnotated).collect(Collectors.toList()), rootId).stream());
            this.metadatas.registerMetadataTags(Metadatas.HEAD_VERSION_LIGHTWEIGHT_TAGS, GitUtils.tagsOf(allVersionTags.stream().filter(Lambdas.as(GitUtils::isAnnotated).negate()).collect(Collectors.toList()), rootId).stream());
            this.metadatas.registerMetadata(Metadatas.GIT_SHA1_FULL, rootId.getName());
            this.metadatas.registerMetadata(Metadatas.GIT_SHA1_8, rootId.getName().substring(0, 8));
            Commit head = new Commit(rootId, 0, GitUtils.tagsOf(normals, rootId), GitUtils.tagsOf(lights, rootId));
            Commit baseCommit = this.findBaseCommitFromReachableTags(rootId, allVersionTags, normals, lights, this.maxDepth, strategy);
            if (baseCommit == null) {
                baseCommit = this.deepestReachableCommit(rootId, this.maxDepth);
            }
            Version calculatedVersion = strategy.build(head, Collections.singletonList(baseCommit));
            this.metadatas.registerMetadata(Metadatas.CALCULATED_VERSION, calculatedVersion.toString());
            boolean patchVersionIsIncremented = this.hasPatchVersionBeenIncremented(strategy, calculatedVersion);
            this.provideNextVersionsMetadatas(calculatedVersion, patchVersionIsIncremented);
            return calculatedVersion;
        }
        catch (NoWorkTreeException ex) {
            return Version.NO_WORKTREE_AND_INDEX;
        }
        catch (Exception ex) {
            throw new IllegalStateException("failure calculating version", ex);
        }
    }

    private Commit deepestReachableCommit(ObjectId headId, int maxDepth) throws IOException {
        try (RevWalk revWalk = new RevWalk(this.repository);){
            int depth;
            RevCommit headCommit = this.repository.parseCommit((AnyObjectId)headId);
            revWalk.markStart(headCommit);
            RevCommit lastCommit = headCommit;
            Iterator iterator = revWalk.iterator();
            for (depth = 0; iterator.hasNext() && depth <= maxDepth; ++depth) {
                lastCommit = (RevCommit)iterator.next();
            }
            int retainedDepth = depth - 1;
            Commit commit = new Commit(lastCommit.getId(), retainedDepth, Collections.emptyList(), Collections.emptyList());
            return commit;
        }
    }

    private Commit findBaseCommitFromReachableTags(ObjectId headId, List<Ref> allVersionTags, List<Ref> normals, List<Ref> lights, int maxDepth, VersionStrategy strategy) throws Exception {
        List<Ref> reachableTags = this.filterReachableTags(headId, allVersionTags);
        if (LookupPolicy.LATEST.equals((Object)this.lookupPolicy)) {
            reachableTags = this.keepOnlyAnnotatedTags(reachableTags);
        }
        if (reachableTags.isEmpty()) {
            return null;
        }
        ObjectId baseCommitId = this.findBaseCommitId(headId, reachableTags, this.lookupPolicy, strategy);
        LinkedHashSet commits = new LinkedHashSet();
        DistanceCalculator distanceCalculator = DistanceCalculator.create((AnyObjectId)headId, this.repository, maxDepth);
        if (headId.getName().equals(baseCommitId.getName())) {
            return new Commit(baseCommitId, 0, GitUtils.tagsOf(normals, baseCommitId), GitUtils.tagsOf(lights, baseCommitId));
        }
        return distanceCalculator.distanceTo(baseCommitId).map(distance -> new Commit(baseCommitId, (int)distance, GitUtils.tagsOf(normals, baseCommitId), GitUtils.tagsOf(lights, baseCommitId))).orElse(null);
    }

    private ArrayList<Ref> keepOnlyAnnotatedTags(List<Ref> reachableTags) {
        return reachableTags.stream().filter(r -> GitUtils.isAnnotated(r)).collect(Collectors.toCollection(ArrayList::new));
    }

    private ObjectId findBaseCommitId(ObjectId headId, List<Ref> reachableTags, LookupPolicy lookupPolicy, VersionStrategy strategy) {
        switch (lookupPolicy) {
            case MAX: {
                Comparator versionTagComparator = (r1, r2) -> {
                    Version v1 = strategy.versionFromTag((Ref)r1);
                    Version v2 = strategy.versionFromTag((Ref)r2);
                    return v1.compareTo(v2);
                };
                return reachableTags.stream().max(versionTagComparator).map(this.refToObjectIdFunction).orElseThrow(() -> new IllegalStateException(String.format("could not find max version tag", new Object[0])));
            }
            case LATEST: {
                return this.latestObjectIdOfTags(reachableTags, this.refToObjectIdFunction);
            }
            case NEAREST: {
                DistanceCalculator dc = DistanceCalculator.create((AnyObjectId)headId, this.repository);
                Map<Integer, List<Ref>> tagsByDistance = reachableTags.stream().collect(Collectors.groupingBy(r -> dc.distanceTo(this.refToObjectIdFunction.apply((Ref)r)).get()));
                Integer minimumDistance = Collections.min(tagsByDistance.keySet());
                List<Ref> tagsAtMinimumDistance = tagsByDistance.get(minimumDistance);
                if (tagsAtMinimumDistance.size() == 1) {
                    return this.refToObjectIdFunction.apply(tagsAtMinimumDistance.get(0));
                }
                if (LookupPolicy.LATEST.equals((Object)lookupPolicy)) {
                    tagsAtMinimumDistance = this.keepOnlyAnnotatedTags(tagsAtMinimumDistance);
                }
                return this.latestObjectIdOfTags(tagsAtMinimumDistance, this.refToObjectIdFunction);
            }
        }
        throw new IllegalStateException(String.format("[%s] lookup policy is not implmented", new Object[]{lookupPolicy}));
    }

    private ObjectId latestObjectIdOfTags(List<Ref> reachableTags, Function<Ref, ObjectId> refToObjectIdFunction) {
        try (TagDateExtractor dateExtractor = new TagDateExtractor(this.repository);){
            ObjectId objectId = reachableTags.stream().map(r -> new Pair<Ref, Date>((Ref)r, dateExtractor.dateOfRef((Ref)r))).max(Comparator.comparing(p -> (Date)p.getRight())).map(p -> (Ref)p.getLeft()).map(refToObjectIdFunction).orElseThrow(() -> new IllegalStateException(String.format("could not find most recent tag", new Object[0])));
            return objectId;
        }
    }

    private List<Ref> filterReachableTags(ObjectId headId, List<Ref> allVersionTags) throws IOException {
        ArrayList<Ref> filtered = new ArrayList<Ref>();
        try (RevWalk walk = new RevWalk(this.repository);){
            walk.markStart(walk.parseCommit((AnyObjectId)headId));
            for (RevCommit revCommit : walk) {
                ObjectId commitId = revCommit.getId();
                Predicate<Ref> tagCorresponds = r -> commitId.getName().equals(this.refToObjectIdFunction.apply((Ref)r).getName());
                allVersionTags.stream().filter(tagCorresponds).forEach(filtered::add);
            }
        }
        return filtered;
    }

    private Ref peel(Ref tag) {
        try {
            return this.repository.getRefDatabase().peel(tag);
        }
        catch (IOException e) {
            return tag;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.repository != null) {
            this.repository.close();
        }
    }

    @Override
    public GitVersionCalculator setAutoIncrementPatch(boolean value) {
        this.autoIncrementPatch = value;
        return this;
    }

    @Override
    public GitVersionCalculator setNonQualifierBranches(String nonQualifierBranches) {
        LinkedList<BranchingPolicy> branchPolicies = new LinkedList<BranchingPolicy>();
        if (nonQualifierBranches != null && !"".equals(nonQualifierBranches.trim())) {
            for (String branch : nonQualifierBranches.split(",")) {
                branchPolicies.add(BranchingPolicy.fixedBranchName(branch, Collections.singletonList(BranchingPolicy.BranchNameTransformations.IGNORE.name())));
            }
        }
        return this.setQualifierBranchingPolicies(branchPolicies);
    }

    @Override
    public GitVersionCalculator setQualifierBranchingPolicies(BranchingPolicy ... policies) {
        return this.setQualifierBranchingPolicies(Arrays.asList(policies));
    }

    @Override
    public GitVersionCalculator setQualifierBranchingPolicies(List<BranchingPolicy> policies) {
        if (policies != null) {
            this.qualifierBranchingPolicies = new LinkedList<BranchingPolicy>(policies);
        }
        this.computationRequired = true;
        return this;
    }

    @Override
    public GitVersionCalculator setUseDistance(boolean useDistance) {
        this.useDistance = useDistance;
        this.computationRequired = true;
        return this;
    }

    @Override
    public GitVersionCalculator setUseDirty(boolean useDirty) {
        this.useDirty = useDirty;
        this.computationRequired = true;
        return this;
    }

    @Override
    public GitVersionCalculator setUseLongFormat(boolean useLongFormat) {
        this.useLongFormat = useLongFormat;
        this.computationRequired = true;
        return this;
    }

    @Override
    public GitVersionCalculator setUseGitCommitId(boolean useGitCommitId) {
        this.useGitCommitId = useGitCommitId;
        this.computationRequired = true;
        return this;
    }

    @Override
    public GitVersionCalculator setUseGitCommitTimestamp(boolean useGitCommitTimestamp) {
        this.useGitCommitTimestamp = useGitCommitTimestamp;
        this.computationRequired = true;
        return this;
    }

    @Override
    public GitVersionCalculator setUseDefaultBranchingPolicy(boolean useDefaultBranchingPolicy) {
        this.useDefaultBranchingPolicy = useDefaultBranchingPolicy;
        this.computationRequired = true;
        return this;
    }

    @Override
    public GitVersionCalculator setGitCommitIdLength(int gitCommitIdLength) {
        if (gitCommitIdLength < 8 || gitCommitIdLength > 40) {
            throw new IllegalStateException("GitCommitIdLength must be between 8 & 40");
        }
        this.gitCommitIdLength = gitCommitIdLength;
        this.computationRequired = true;
        return this;
    }

    @Override
    public GitVersionCalculator setMavenLike(boolean mavenLike) {
        this.mavenLike = mavenLike;
        this.computationRequired = true;
        return this;
    }

    @Override
    public GitVersionCalculator setFindTagVersionPattern(String pattern) {
        this.findTagVersionPattern = Pattern.compile(pattern);
        this.computationRequired = true;
        return this;
    }

    @Override
    public Optional<String> meta(Metadatas meta) {
        if (this.metadatas == null) {
            this.getVersion();
        }
        return this.metadatas.meta(meta);
    }

    @Override
    public GitVersionCalculator setStrategy(Strategies s) {
        this.versionStrategy = Objects.requireNonNull(s, "provided strategy cannot be null");
        this.computationRequired = true;
        return this;
    }

    @Override
    public GitVersionCalculator setTagVersionPattern(String pattern) {
        this.tagVersionPattern = pattern;
        this.computationRequired = true;
        return this;
    }

    @Override
    public GitVersionCalculator setVersionPattern(String pattern) {
        this.versionPattern = pattern;
        this.computationRequired = true;
        return this;
    }

    @Override
    public GitVersionCalculator setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        this.computationRequired = true;
        return this;
    }

    @Override
    public GitVersionCalculator setLookupPolicy(LookupPolicy policy) {
        this.lookupPolicy = policy;
        this.computationRequired = true;
        return this;
    }

    @Override
    public GitVersionCalculator setUseSnapshot(boolean useSnapshot) {
        this.useSnapshot = useSnapshot;
        return this;
    }
}

