/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.Check;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;
import java.util.Map;

final class MapItemCheck<K, V>
implements Check<Map<K, V>> {
    private final K key;
    private final Check<? super V> check;

    MapItemCheck(K key, Check<? super V> check) {
        this.key = key;
        this.check = check;
    }

    @Override
    public Result evaluate(Map<K, V> data, ResultFactory factory) {
        V value = data.get(this.key);
        Result result = this.check.evaluate(value, factory);
        return factory.named(this.key, result, result.passed());
    }

    public String toString() {
        return this.key + ": " + this.check;
    }
}

