/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.BasicChecks;
import fluent.validation.Check;
import fluent.validation.CheckDsl;
import fluent.validation.Transformation;
import fluent.validation.TransformationBuilder;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;
import java.util.function.Function;

public abstract class AbstractCheckDsl<L, D>
implements CheckDsl<L, D> {
    private final Check<? super D> check;
    private final Function<Check<D>, L> factory;

    protected AbstractCheckDsl(Check<? super D> check, Function<Check<D>, L> factory) {
        this.check = check;
        this.factory = factory;
    }

    protected AbstractCheckDsl(Function<Check<D>, L> factory) {
        this(BasicChecks.anything(), factory);
    }

    @Override
    public L with(Check<? super D> check) {
        return this.factory.apply(this.check.and(check));
    }

    @Override
    public <V> TransformationBuilder<V, L> withField(String name, Transformation<? super D, V> transformation) {
        return condition -> this.with(BasicChecks.has(name, transformation).matching(condition));
    }

    @Override
    public <V> TransformationBuilder<V, L> withField(Transformation<? super D, V> transformation) {
        return this.withField(transformation.getMethodName(), transformation);
    }

    @Override
    public L or() {
        return this.factory.apply(this.check.or(BasicChecks.anything()));
    }

    @Override
    public Result evaluate(D data, ResultFactory factory) {
        return this.check.evaluate(data, factory);
    }

    public String toString() {
        return this.check.toString();
    }
}

