/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.BasicChecks;
import fluent.validation.Check;
import java.math.BigDecimal;

public final class NumericChecks {
    private static final Double DEFAULT_TOLERANCE = Double.parseDouble(System.getProperty("check.default.tolerance", "0.000001"));

    private NumericChecks() {
    }

    public static Check<Double> closeTo(double operand, double precision) {
        return BasicChecks.check(data -> Math.abs(operand - data) < precision, "<" + operand + " \u00b1" + precision + ">");
    }

    public static Check<Float> closeTo(float operand, float precision) {
        return BasicChecks.check(data -> Math.abs(operand - data.floatValue()) < precision, operand + " \u00b1" + precision);
    }

    public static Check<BigDecimal> closeTo(BigDecimal operand, BigDecimal precision) {
        return BasicChecks.check(data -> operand.subtract((BigDecimal)data).abs().compareTo(precision) < 0, operand + " \u00b1" + precision);
    }

    public static Check<Double> equalTo(Double expectedValue) {
        return expectedValue == null ? BasicChecks.sameInstance(null) : NumericChecks.closeTo(expectedValue, DEFAULT_TOLERANCE);
    }

    public static Check<Float> equalTo(Float expectedValue) {
        return expectedValue == null ? BasicChecks.sameInstance(null) : NumericChecks.closeTo(expectedValue.floatValue(), DEFAULT_TOLERANCE.floatValue());
    }

    public static Check<BigDecimal> equalTo(BigDecimal expectedValue) {
        return expectedValue == null ? BasicChecks.sameInstance(null) : NumericChecks.closeTo(expectedValue, BigDecimal.valueOf(DEFAULT_TOLERANCE));
    }
}

