/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.BasicChecks;
import fluent.validation.Check;
import fluent.validation.ResultSetCheckInAnyOrder;
import fluent.validation.ResultSetCheckInOrder;
import fluent.validation.Transformation;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Collection;

public final class DatabaseChecks {
    private static final Check<ResultSet> HAS_MORE_RECORDS = DatabaseChecks.sqlCheck("has more records", ResultSet::next, BasicChecks.equalTo(true));
    private static final Check<ResultSet> HAS_NO_MORE_RECORDS = DatabaseChecks.sqlCheck("has no more records", ResultSet::next, BasicChecks.equalTo(false));

    private DatabaseChecks() {
    }

    public static Check<ResultSet> hasMoreRecords() {
        return HAS_MORE_RECORDS;
    }

    public static Check<ResultSet> hasNoMoreRecords() {
        return HAS_NO_MORE_RECORDS;
    }

    public static Check<ResultSet> resultSetEqualTo(Collection<Check<? super ResultSet>> checks) {
        return new ResultSetCheckInOrder(checks, true, true);
    }

    public static Check<ResultSet> resultSetEqualInAnyOrderTo(Collection<Check<? super ResultSet>> checks) {
        return new ResultSetCheckInAnyOrder(checks, true, true);
    }

    public static Check<ResultSet> resultSetStartsWith(Collection<Check<? super ResultSet>> checks) {
        return new ResultSetCheckInOrder(checks, false, true);
    }

    public static Check<ResultSet> resultSetStartsInAnyOrderWith(Collection<Check<? super ResultSet>> checks) {
        return new ResultSetCheckInAnyOrder(checks, false, true);
    }

    public static Check<ResultSet> resultSetContains(Collection<Check<? super ResultSet>> checks) {
        return new ResultSetCheckInOrder(checks, false, false);
    }

    public static Check<ResultSet> resultSetContainsInAnyOrder(Collection<Check<? super ResultSet>> checks) {
        return new ResultSetCheckInAnyOrder(checks, false, false);
    }

    public static <R> Check<ResultSet> sqlCheck(String name, Transformation<ResultSet, R> function, Check<? super R> check) {
        return BasicChecks.compose(name, function, check);
    }

    public static <R> Check<ResultSet> sqlCheck(int position, Transformation<ResultSet, R> function, Check<? super R> check) {
        return DatabaseChecks.sqlCheck("column [" + position + "]", function, check);
    }

    public static <T> Check<ResultSet> column(String label, Class<T> type, Check<? super T> check) {
        return DatabaseChecks.sqlCheck(label, (ResultSet resultSet) -> resultSet.getObject(label, type), check);
    }

    public static <T> Check<ResultSet> column(int position, Class<T> type, Check<? super T> check) {
        return DatabaseChecks.sqlCheck(position, (ResultSet resultSet) -> resultSet.getObject(position, type), check);
    }

    public static Check<ResultSet> intColumn(String label, Check<? super Integer> check) {
        return DatabaseChecks.sqlCheck(label, (ResultSet resultSet) -> resultSet.getInt(label), check);
    }

    public static Check<ResultSet> intColumn(int position, Check<? super Integer> check) {
        return DatabaseChecks.sqlCheck(position, (ResultSet resultSet) -> resultSet.getInt(position), check);
    }

    public static Check<ResultSet> booleanColumn(String label, Check<? super Boolean> check) {
        return DatabaseChecks.sqlCheck(label, (ResultSet resultSet) -> resultSet.getBoolean(label), check);
    }

    public static Check<ResultSet> booleanColumn(int position, Check<? super Boolean> check) {
        return DatabaseChecks.sqlCheck(position, (ResultSet resultSet) -> resultSet.getBoolean(position), check);
    }

    public static Check<ResultSet> stringColumn(String label, Check<? super String> check) {
        return DatabaseChecks.sqlCheck(label, (ResultSet resultSet) -> resultSet.getString(label), check);
    }

    public static Check<ResultSet> stringColumn(int position, Check<? super String> check) {
        return DatabaseChecks.sqlCheck(position, (ResultSet resultSet) -> resultSet.getString(position), check);
    }

    public static Check<ResultSet> doubleColumn(String label, Check<? super Double> check) {
        return DatabaseChecks.sqlCheck(label, (ResultSet resultSet) -> resultSet.getDouble(label), check);
    }

    public static Check<ResultSet> doubleColumn(int position, Check<? super Double> check) {
        return DatabaseChecks.sqlCheck(position, (ResultSet resultSet) -> resultSet.getDouble(position), check);
    }

    public static Check<ResultSet> byteColumn(String label, Check<? super Byte> check) {
        return DatabaseChecks.sqlCheck(label, (ResultSet resultSet) -> resultSet.getByte(label), check);
    }

    public static Check<ResultSet> byteColumn(int position, Check<? super Byte> check) {
        return DatabaseChecks.sqlCheck(position, (ResultSet resultSet) -> resultSet.getByte(position), check);
    }

    public static Check<ResultSet> bytesColumn(String label, Check<? super byte[]> check) {
        return DatabaseChecks.sqlCheck(label, (ResultSet resultSet) -> resultSet.getBytes(label), check);
    }

    public static Check<ResultSet> bytesColumn(int position, Check<? super byte[]> check) {
        return DatabaseChecks.sqlCheck(position, (ResultSet resultSet) -> resultSet.getBytes(position), check);
    }

    public static Check<ResultSet> metadata(Check<? super ResultSetMetaData> check) {
        return DatabaseChecks.sqlCheck("metadata", ResultSet::getMetaData, check);
    }

    public static <V> Check<ResultSetMetaData> metadataCheck(String name, Transformation<ResultSetMetaData, V> function, Check<? super V> check) {
        return BasicChecks.compose(name, function, check);
    }

    public static Check<ResultSetMetaData> columnCount(int expectedValue) {
        return DatabaseChecks.metadataCheck("column count", ResultSetMetaData::getColumnCount, BasicChecks.equalTo(expectedValue));
    }

    public static Check<ResultSetMetaData> columnName(int position, String expectedName) {
        return DatabaseChecks.metadataCheck("column " + position + " name", r -> r.getColumnName(position), BasicChecks.equalTo(expectedName));
    }

    public static <T> Check<CallableStatement> outParameter(int position, Class<T> type, Check<? super T> check) {
        return BasicChecks.compose("", c -> c.getObject(position, type), check);
    }

    public static Check<PreparedStatement> executeQuery(Check<? super ResultSet> check) {
        return BasicChecks.has("", PreparedStatement::executeQuery).matching(check);
    }
}

