/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.And;
import fluent.validation.Anything;
import fluent.validation.Check;
import fluent.validation.CheckBuilder;
import fluent.validation.CheckDsl;
import fluent.validation.DoubleCheck;
import fluent.validation.NamedCheck;
import fluent.validation.NegativeCheck;
import fluent.validation.Or;
import fluent.validation.Predicate;
import fluent.validation.PredicateCheck;
import fluent.validation.ThrowingCheck;
import fluent.validation.Transformation;
import fluent.validation.TransformedCheck;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;

public final class BasicChecks {
    private static final Check<Object> IS_NULL = BasicChecks.sameInstance(null);
    private static final Check<Object> NOT_NULL = BasicChecks.not(IS_NULL);
    private static final Check<Object> ANYTHING = new Anything<Object>();

    private BasicChecks() {
    }

    public static <D> Check<D> nullableCondition(Predicate<D> predicate, String expectationDescription) {
        return new PredicateCheck<D>(expectationDescription, predicate);
    }

    public static <D> Check<D> require(Check<? super D> requirement, Check<? super D> check) {
        return new DoubleCheck<D>(requirement, check);
    }

    public static <D> Check<D> requireNotNull(Check<D> check) {
        return BasicChecks.require(BasicChecks.notNull(), check);
    }

    public static <D> Check<D> check(Predicate<D> predicate, String expectationDescription) {
        return BasicChecks.requireNotNull(BasicChecks.nullableCondition(predicate, expectationDescription));
    }

    public static <D> Check<D> not(Check<D> positiveCheck) {
        return new NegativeCheck<D>(positiveCheck);
    }

    public static <D> Check<D> not(D positiveValue) {
        return BasicChecks.not(BasicChecks.equalTo(positiveValue));
    }

    public static <D> Check<D> oneOf(Collection<D> alternatives) {
        return BasicChecks.nullableCondition(alternatives::contains, "One of " + alternatives);
    }

    @SafeVarargs
    public static <D> Check<D> oneOf(D ... alternatives) {
        return BasicChecks.oneOf(new HashSet<D>(Arrays.asList(alternatives)));
    }

    private static <D> Check<D> multipleOperands(Iterable<Check<? super D>> operands, boolean andOperator) {
        Iterator<Check<D>> iterator = operands.iterator();
        if (!iterator.hasNext()) {
            return BasicChecks.nullableCondition(data -> andOperator, "empty " + (andOperator ? "allOf" : "anyOf") + " formula");
        }
        Check<? super D> next = iterator.next();
        while (iterator.hasNext()) {
            next = andOperator ? new And<D>(next, iterator.next()) : new Or<D>(next, iterator.next());
        }
        return next;
    }

    public static <D> Check<D> anyOf(Iterable<Check<? super D>> operands) {
        return BasicChecks.multipleOperands(operands, false);
    }

    @SafeVarargs
    public static <D> Check<D> anyOf(Check<? super D> ... operands) {
        return BasicChecks.anyOf(Arrays.asList(operands));
    }

    public static <D> Check<D> allOf(Iterable<Check<? super D>> operands) {
        return BasicChecks.multipleOperands(operands, true);
    }

    @SafeVarargs
    public static <D> Check<D> allOf(Check<? super D> ... operands) {
        return BasicChecks.allOf(Arrays.asList(operands));
    }

    public static <D> Check<D> equalTo(D expectedValue) {
        return expectedValue == null ? BasicChecks.sameInstance(null) : BasicChecks.nullableCondition(expectedValue::equals, "<" + expectedValue + ">");
    }

    public static <D> Check<D> is(D expectedValue) {
        return BasicChecks.equalTo(expectedValue);
    }

    public static Check<Object> isNull() {
        return IS_NULL;
    }

    public static Check<Object> notNull() {
        return NOT_NULL;
    }

    public static Check<Object> anything() {
        return ANYTHING;
    }

    public static <D> Check<D> sameInstance(D expectedInstance) {
        return BasicChecks.nullableCondition(data -> data == expectedInstance, "<" + expectedInstance + ">");
    }

    private static Check<Object> instanceOf(String prefix, Class<?> expectedClass) {
        return BasicChecks.nullableCondition(expectedClass::isInstance, prefix + " " + expectedClass);
    }

    public static Check<Object> instanceOf(Class<?> expectedClass) {
        return BasicChecks.instanceOf("instance of", expectedClass);
    }

    public static Check<Object> isA(Class<?> expectedClass) {
        return BasicChecks.instanceOf("is a", expectedClass);
    }

    public static Check<Object> isAn(Class<?> expectedClass) {
        return BasicChecks.instanceOf("is an", expectedClass);
    }

    public static Check<Object> a(Class<?> expectedClass) {
        return BasicChecks.isA(expectedClass);
    }

    public static Check<Object> an(Class<?> expectedClass) {
        return BasicChecks.isAn(expectedClass);
    }

    public static Check<Object> sameClass(Class<?> expectedClass) {
        return BasicChecks.has("class", Object::getClass).matching(BasicChecks.equalTo(expectedClass));
    }

    public static <D> Check<D[]> emptyArray() {
        return BasicChecks.nullableCondition(data -> Objects.isNull(data) || ((Object[])data).length == 0, "is empty array");
    }

    public static <D, V> Check<D> transform(Transformation<? super D, V> transformation, Check<? super V> check) {
        return new TransformedCheck<D, V>(transformation, check);
    }

    public static <D, V> Check<D> compose(String name, Transformation<? super D, V> transformation, Check<? super V> check) {
        return new NamedCheck<D>(name, BasicChecks.transform(transformation, check));
    }

    public static <D, V> CheckBuilder<V, Check<D>> has(String name, Transformation<? super D, V> transformation) {
        return condition -> BasicChecks.requireNotNull(BasicChecks.compose(name, transformation, condition));
    }

    public static <D, V> CheckBuilder<V, Check<D>> nullableHas(String name, Transformation<? super D, V> transformation) {
        return condition -> BasicChecks.compose(name, transformation, condition);
    }

    public static <V> CheckBuilder<V, Check<V>> as(Class<V> type) {
        return condition -> BasicChecks.require(BasicChecks.instanceOf(type), BasicChecks.compose("as " + type.getSimpleName(), type::cast, condition));
    }

    public static Check<Throwable> message(Check<? super String> check) {
        return BasicChecks.compose("message", Throwable::getMessage, check);
    }

    public static ThrowingCheck throwing(Check<? super Throwable> check) {
        return new ThrowingCheck(check);
    }

    public static ThrowingCheck throwing(Class<? extends Throwable> condition) {
        return BasicChecks.throwing(BasicChecks.a(condition));
    }

    public static <D> Check<D> createBuilder() {
        return new Anything();
    }

    public static <D> Check<D> createBuilderWith(Check<D> check) {
        return check;
    }

    public static <D> Check<D> which(Check<D> check) {
        return BasicChecks.createBuilderWith(check);
    }

    public static <D> CheckDsl<D> dsl() {
        return new CheckDsl();
    }
}

