/*
 * Decompiled with CFR 0.152.
 */
package fluent.validation;

import fluent.validation.Check;
import fluent.validation.result.Result;
import fluent.validation.result.ResultFactory;
import java.util.Arrays;

final class And<D>
extends Check<D> {
    private final Check<? super D> left;
    private final Check<? super D> right;

    And(Check<? super D> left, Check<? super D> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public Result evaluate(D data, ResultFactory factory) {
        Result leftResult = this.left.evaluate(data, factory);
        Result rightResult = this.right.evaluate(data, factory);
        return factory.aggregation("", " and ", Arrays.asList(leftResult, rightResult), leftResult.passed() && rightResult.passed());
    }

    @Override
    public String toString() {
        return this.left + " and " + this.right;
    }
}

