/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ResourceValue;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import edu.umd.cs.findbugs.ba.ResourceValueFrameModelingVisitor;
import edu.umd.cs.findbugs.detect.FindOpenStream;
import edu.umd.cs.findbugs.detect.Stream;
import edu.umd.cs.findbugs.detect.StreamResourceTracker;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public class StreamFrameModelingVisitor
extends ResourceValueFrameModelingVisitor {
    private StreamResourceTracker resourceTracker;
    private Stream stream;
    private Location location;

    public StreamFrameModelingVisitor(ConstantPoolGen cpg, StreamResourceTracker resourceTracker, Stream stream) {
        super(cpg);
        this.resourceTracker = resourceTracker;
        this.stream = stream;
    }

    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock) throws DataflowAnalysisException {
        this.location = new Location(handle, basicBlock);
        Instruction ins = handle.getInstruction();
        ConstantPoolGen cpg = this.getCPG();
        ResourceValueFrame frame = (ResourceValueFrame)this.getFrame();
        int status = -1;
        boolean created = false;
        Location creationPoint = this.stream.getLocation();
        if (handle == creationPoint.getHandle() && basicBlock == creationPoint.getBasicBlock()) {
            if (this.stream.isOpenOnCreation()) {
                status = 1;
                this.stream.setOpenLocation(this.location);
                this.resourceTracker.addStreamOpenLocation(this.location, this.stream);
            } else {
                status = 4;
            }
            created = true;
        } else if (this.resourceTracker.isResourceOpen(basicBlock, handle, cpg, this.stream, frame)) {
            status = 1;
            this.stream.setOpenLocation(this.location);
            this.resourceTracker.addStreamOpenLocation(this.location, this.stream);
        } else if (this.resourceTracker.isResourceClose(basicBlock, handle, cpg, this.stream, frame)) {
            status = 3;
        }
        this.analyzeInstruction(ins);
        if (status != -1) {
            frame.setStatus(status);
            if (created) {
                frame.setValue(frame.getNumSlots() - 1, (Object)ResourceValue.instance());
            }
        }
    }

    protected boolean instanceEscapes(InvokeInstruction inv, int instanceArgNum) {
        boolean escapes;
        boolean bl = escapes = inv.getOpcode() == 184 || instanceArgNum != 0;
        if (FindOpenStream.DEBUG && escapes) {
            System.out.println("ESCAPE at " + this.location);
        }
        if (this.stream.getOpenLocation() != null) {
            this.resourceTracker.addStreamEscape(this.stream, this.location);
        }
        return escapes;
    }
}

