/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ch.Subtypes;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class ResolveAllReferences
extends PreorderVisitor
implements Detector {
    private BugReporter bugReporter;
    Set<String> defined;

    public ResolveAllReferences(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    private void compute() {
        if (this.defined == null) {
            this.defined = new HashSet<String>();
            Subtypes subtypes = AnalysisContext.currentAnalysisContext().getSubtypes();
            Set allClasses = subtypes.getAllClasses();
            Iterator i$ = allClasses.iterator();
            while (i$.hasNext()) {
                JavaClass c = (JavaClass)i$.next();
                this.addAllDefinitions(c);
            }
        }
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void report() {
    }

    public void addAllDefinitions(JavaClass obj) {
        String name;
        int i$;
        String className2 = obj.getClassName();
        this.defined.add(className2);
        Method[] arr$ = obj.getMethods();
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            Method m = arr$[i$];
            if (m.isPrivate()) continue;
            name = this.getMemberName(obj, className2, m.getNameIndex(), m.getSignatureIndex());
            this.defined.add(name);
        }
        arr$ = obj.getFields();
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            Method f = arr$[i$];
            if (f.isPrivate()) continue;
            name = this.getMemberName(obj, className2, f.getNameIndex(), f.getSignatureIndex());
            this.defined.add(name);
        }
    }

    private String getClassName(JavaClass c, int classIndex) {
        String name = c.getConstantPool().getConstantString(classIndex, (byte)7);
        return Subtypes.extractClassName((String)name);
    }

    private String getMemberName(JavaClass c, String className, int memberNameIndex, int signatureIndex) {
        return className + "." + ((ConstantUtf8)c.getConstantPool().getConstant(memberNameIndex, (byte)1)).getBytes() + " : " + ((ConstantUtf8)c.getConstantPool().getConstant(signatureIndex, (byte)1)).getBytes();
    }

    public void visit(JavaClass obj) {
        this.compute();
        ConstantPool cp = obj.getConstantPool();
        Constant[] constants = cp.getConstantPool();
        block2: for (int i = 0; i < constants.length; ++i) {
            Constant co = constants[i];
            if (co instanceof ConstantDouble || co instanceof ConstantLong) {
                ++i;
            }
            if (co instanceof ConstantClass) {
                String ref = this.getClassName(obj, i).replace('/', '.');
                if (!ref.startsWith("java") || this.defined.contains(ref)) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "VR_UNRESOLVABLE_REFERENCE", 2).addClass(obj).addString(ref));
                continue;
            }
            if (co instanceof ConstantFieldref || !(co instanceof ConstantCP)) continue;
            ConstantCP co2 = (ConstantCP)co;
            String className = this.getClassName(obj, co2.getClassIndex()).replace('/', '.');
            ConstantNameAndType nt = (ConstantNameAndType)cp.getConstant(co2.getNameAndTypeIndex());
            String ref = this.getMemberName(obj, className, nt.getNameIndex(), nt.getSignatureIndex());
            if (className.equals(obj.getClassName()) || !this.defined.contains(className) || this.defined.contains(ref)) continue;
            try {
                JavaClass target = Repository.lookupClass((String)className);
                if (target.isInterface() || target.isAbstract()) continue;
                while ((target = target.getSuperClass()) != null && this.defined.contains(target.getClassName())) {
                    String ref2 = this.getMemberName(obj, target.getClassName(), nt.getNameIndex(), nt.getSignatureIndex());
                    if (!this.defined.contains(ref2)) continue;
                    continue block2;
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, "VR_UNRESOLVABLE_REFERENCE", 2).addClass(obj).addString(ref));
                continue;
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
            }
        }
    }
}

