/*
 * Decompiled with CFR 0.152.
 */
package fi.metatavu.kuntaapi.server.rest;

import fi.metatavu.kuntaapi.server.rest.AbstractApi;
import fi.metatavu.kuntaapi.server.rest.model.ElectronicServiceChannel;
import fi.metatavu.kuntaapi.server.rest.model.PhoneServiceChannel;
import fi.metatavu.kuntaapi.server.rest.model.PrintableFormServiceChannel;
import fi.metatavu.kuntaapi.server.rest.model.Service;
import fi.metatavu.kuntaapi.server.rest.model.ServiceLocationServiceChannel;
import fi.metatavu.kuntaapi.server.rest.model.WebPageServiceChannel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;

@Path(value="/services")
@Api(description="the services API")
@Consumes(value={"application/json;charset=utf-8"})
@Produces(value={"application/json;charset=utf-8"})
public abstract class ServicesApi
extends AbstractApi {
    @POST
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Create service", notes="Creates new service", response=Service.class, authorizations={@Authorization(value="basicAuth")}, tags={"Services"})
    @ApiResponses(value={@ApiResponse(code=200, message="Created service", response=Service.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Service.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Service.class), @ApiResponse(code=500, message="Internal server error", response=Service.class)})
    public abstract Response createService(Service var1, @Context Request var2);

    @GET
    @Path(value="/{serviceId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Finds a service by id", notes="Finds service", response=Service.class, authorizations={@Authorization(value="basicAuth")}, tags={"Services"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns a service", response=Service.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Service.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Service.class), @ApiResponse(code=404, message="Resource was not found from the server", response=Service.class), @ApiResponse(code=500, message="Internal server error", response=Service.class)})
    public abstract Response findService(@PathParam(value="serviceId") String var1, @Context Request var2);

    @GET
    @Path(value="/{serviceId}/electronicChannels/{electronicChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="finds ElectronicChannel by electronicChannelId", notes="finds ElectronicChannels by electronicChannelId", response=ElectronicServiceChannel.class, authorizations={@Authorization(value="basicAuth")}, tags={"Services", "ElectronicChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns ElectronicChannel", response=ElectronicServiceChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=ElectronicServiceChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=ElectronicServiceChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=ElectronicServiceChannel.class), @ApiResponse(code=500, message="Internal server error", response=ElectronicServiceChannel.class)})
    public abstract Response findServiceElectronicChannel(@PathParam(value="serviceId") String var1, @PathParam(value="electronicChannelId") String var2, @Context Request var3);

    @GET
    @Path(value="/{serviceId}/phoneChannels/{phoneChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="finds PhoneChannel by phoneChannelId", notes="finds PhoneChannels by phoneChannelId", response=PhoneServiceChannel.class, authorizations={@Authorization(value="basicAuth")}, tags={"Services", "PhoneChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns PhoneChannel", response=PhoneServiceChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=PhoneServiceChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=PhoneServiceChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=PhoneServiceChannel.class), @ApiResponse(code=500, message="Internal server error", response=PhoneServiceChannel.class)})
    public abstract Response findServicePhoneChannel(@PathParam(value="serviceId") String var1, @PathParam(value="phoneChannelId") String var2, @Context Request var3);

    @GET
    @Path(value="/{serviceId}/printableFormChannels/{printableFormChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="finds PrintableFormChannel by printableFormChannelId", notes="finds PrintableFormChannels by printableFormChannelId", response=PrintableFormServiceChannel.class, authorizations={@Authorization(value="basicAuth")}, tags={"Services", "PrintableFormChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns PrintableFormChannel", response=PrintableFormServiceChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=PrintableFormServiceChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=PrintableFormServiceChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=PrintableFormServiceChannel.class), @ApiResponse(code=500, message="Internal server error", response=PrintableFormServiceChannel.class)})
    public abstract Response findServicePrintableFormChannel(@PathParam(value="serviceId") String var1, @PathParam(value="printableFormChannelId") String var2, @Context Request var3);

    @GET
    @Path(value="/{serviceId}/serviceLocationChannels/{serviceLocationChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="finds ServiceLocationChannel by serviceLocationChannelId", notes="finds ServiceLocationChannels by serviceLocationChannelId", response=ServiceLocationServiceChannel.class, authorizations={@Authorization(value="basicAuth")}, tags={"Services", "ServiceLocationChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns ServiceLocationChannel", response=ServiceLocationServiceChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=ServiceLocationServiceChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=ServiceLocationServiceChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=ServiceLocationServiceChannel.class), @ApiResponse(code=500, message="Internal server error", response=ServiceLocationServiceChannel.class)})
    public abstract Response findServiceServiceLocationChannel(@PathParam(value="serviceId") String var1, @PathParam(value="serviceLocationChannelId") String var2, @Context Request var3);

    @GET
    @Path(value="/{serviceId}/webPageChannels/{webPageChannelId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="finds WebPageChannel by webPageChannelId", notes="finds WebPageChannels by webPageChannelId", response=WebPageServiceChannel.class, authorizations={@Authorization(value="basicAuth")}, tags={"Services", "WebPageChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns WebPageChannel", response=WebPageServiceChannel.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=WebPageServiceChannel.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=WebPageServiceChannel.class), @ApiResponse(code=404, message="Resource was not found from the server", response=WebPageServiceChannel.class), @ApiResponse(code=500, message="Internal server error", response=WebPageServiceChannel.class)})
    public abstract Response findServiceWebPageChannel(@PathParam(value="serviceId") String var1, @PathParam(value="webPageChannelId") String var2, @Context Request var3);

    @GET
    @Path(value="/{serviceId}/electronicChannels")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists ElectronicChannels by serviceId", notes="Lists ElectronicChannels by serviceId", response=ElectronicServiceChannel.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={"Services", "ElectronicChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns array of ElectronicChannels", response=ElectronicServiceChannel.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=ElectronicServiceChannel.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=ElectronicServiceChannel.class, responseContainer="List"), @ApiResponse(code=404, message="Resource was not found from the server", response=ElectronicServiceChannel.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=ElectronicServiceChannel.class, responseContainer="List")})
    public abstract Response listServiceElectronicChannels(@PathParam(value="serviceId") String var1, @QueryParam(value="firstResult") Long var2, @QueryParam(value="maxResults") Long var3, @Context Request var4);

    @GET
    @Path(value="/{serviceId}/phoneChannels")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists PhoneChannels by serviceId", notes="Lists PhoneChannels by serviceId", response=PhoneServiceChannel.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={"Services", "PhoneChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns array of PhoneChannels", response=PhoneServiceChannel.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=PhoneServiceChannel.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=PhoneServiceChannel.class, responseContainer="List"), @ApiResponse(code=404, message="Resource was not found from the server", response=PhoneServiceChannel.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=PhoneServiceChannel.class, responseContainer="List")})
    public abstract Response listServicePhoneChannels(@PathParam(value="serviceId") String var1, @QueryParam(value="firstResult") Long var2, @QueryParam(value="maxResults") Long var3, @Context Request var4);

    @GET
    @Path(value="/{serviceId}/printableFormChannels")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists PrintableFormChannels by serviceId", notes="Lists PrintableFormChannels by serviceId", response=PrintableFormServiceChannel.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={"Services", "PrintableFormChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns array of PrintableFormChannels", response=PrintableFormServiceChannel.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=PrintableFormServiceChannel.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=PrintableFormServiceChannel.class, responseContainer="List"), @ApiResponse(code=404, message="Resource was not found from the server", response=PrintableFormServiceChannel.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=PrintableFormServiceChannel.class, responseContainer="List")})
    public abstract Response listServicePrintableFormChannels(@PathParam(value="serviceId") String var1, @QueryParam(value="firstResult") Long var2, @QueryParam(value="maxResults") Long var3, @Context Request var4);

    @GET
    @Path(value="/{serviceId}/serviceLocationChannels")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists ServiceLocationChannels by serviceId", notes="Lists ServiceLocationChannels by serviceId", response=ServiceLocationServiceChannel.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={"Services", "ServiceLocationChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns array of ServiceLocationChannels", response=ServiceLocationServiceChannel.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=ServiceLocationServiceChannel.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=ServiceLocationServiceChannel.class, responseContainer="List"), @ApiResponse(code=404, message="Resource was not found from the server", response=ServiceLocationServiceChannel.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=ServiceLocationServiceChannel.class, responseContainer="List")})
    public abstract Response listServiceServiceLocationChannels(@PathParam(value="serviceId") String var1, @QueryParam(value="firstResult") Long var2, @QueryParam(value="maxResults") Long var3, @Context Request var4);

    @GET
    @Path(value="/{serviceId}/webPageChannels")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Lists WebPageChannels by serviceId", notes="Lists WebPageChannels by serviceId", response=WebPageServiceChannel.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={"Services", "WebPageChannels"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns array of WebPageChannels", response=WebPageServiceChannel.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=WebPageServiceChannel.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=WebPageServiceChannel.class, responseContainer="List"), @ApiResponse(code=404, message="Resource was not found from the server", response=WebPageServiceChannel.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=WebPageServiceChannel.class, responseContainer="List")})
    public abstract Response listServiceWebPageChannels(@PathParam(value="serviceId") String var1, @QueryParam(value="firstResult") Long var2, @QueryParam(value="maxResults") Long var3, @Context Request var4);

    @GET
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Service list", notes="Lists services", response=Service.class, responseContainer="List", authorizations={@Authorization(value="basicAuth")}, tags={"Services"})
    @ApiResponses(value={@ApiResponse(code=200, message="An array of services", response=Service.class, responseContainer="List"), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Service.class, responseContainer="List"), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Service.class, responseContainer="List"), @ApiResponse(code=404, message="Resource was not found from the server", response=Service.class, responseContainer="List"), @ApiResponse(code=500, message="Internal server error", response=Service.class, responseContainer="List")})
    public abstract Response listServices(@QueryParam(value="organizationId") String var1, @QueryParam(value="search") String var2, @QueryParam(value="sortBy") String var3, @QueryParam(value="sortDir") String var4, @QueryParam(value="firstResult") Long var5, @QueryParam(value="maxResults") Long var6, @QueryParam(value="electronicServiceChannelId") String var7, @QueryParam(value="phoneServiceChannelId") String var8, @QueryParam(value="printableFormServiceChannelId") String var9, @QueryParam(value="serviceLocationServiceChannelId") String var10, @QueryParam(value="webPageServiceChannelId") String var11, @Context Request var12);

    @PUT
    @Path(value="/{serviceId}")
    @Consumes(value={"application/json;charset=utf-8"})
    @Produces(value={"application/json;charset=utf-8"})
    @ApiOperation(value="Updates service", notes="Updates service", response=Service.class, authorizations={@Authorization(value="basicAuth")}, tags={"Services"})
    @ApiResponses(value={@ApiResponse(code=200, message="Returns an updated service", response=Service.class), @ApiResponse(code=400, message="Invalid request was sent to the server", response=Service.class), @ApiResponse(code=403, message="Attempted to make a call with unauthorized client", response=Service.class), @ApiResponse(code=404, message="Resource was not found from the server", response=Service.class), @ApiResponse(code=500, message="Internal server error", response=Service.class)})
    public abstract Response updateService(@PathParam(value="serviceId") String var1, Service var2, @Context Request var3);
}

