/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.extension.command;

import com.atlassian.jgitflow.core.BranchType;
import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.command.JGitFlowCommand;
import com.atlassian.jgitflow.core.exception.JGitFlowExtensionException;
import com.atlassian.jgitflow.core.extension.ExtensionCommand;
import com.atlassian.jgitflow.core.extension.ExtensionFailStrategy;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.VersionType;
import com.atlassian.maven.plugins.jgitflow.helper.BranchHelper;
import com.atlassian.maven.plugins.jgitflow.helper.PomUpdater;
import com.atlassian.maven.plugins.jgitflow.helper.ProjectHelper;
import com.atlassian.maven.plugins.jgitflow.provider.ContextProvider;
import com.atlassian.maven.plugins.jgitflow.provider.JGitFlowProvider;
import com.atlassian.maven.plugins.jgitflow.provider.ProjectCacheKey;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.jgit.api.Git;

@Component(role=UpdatePomsWithSnapshotsCommand.class)
public class UpdatePomsWithSnapshotsCommand
implements ExtensionCommand {
    @Requirement
    private ContextProvider contextProvider;
    @Requirement
    private JGitFlowProvider jGitFlowProvider;
    @Requirement
    private PomUpdater pomUpdater;
    @Requirement
    private ProjectHelper projectHelper;
    @Requirement
    private BranchHelper branchHelper;

    public void execute(GitFlowConfiguration configuration, Git git, JGitFlowCommand gitFlowCommand) throws JGitFlowExtensionException {
        ProjectCacheKey cacheKey = null;
        VersionType versionType = null;
        String versionSuffix = "";
        String unprefixedBranchName = "";
        try {
            BranchType branchType = this.branchHelper.getCurrentBranchType();
            ReleaseContext ctx = this.contextProvider.getContext();
            JGitFlow flow = this.jGitFlowProvider.gitFlow();
            switch (branchType) {
                case RELEASE: {
                    cacheKey = ProjectCacheKey.RELEASE_START_LABEL;
                    versionType = VersionType.RELEASE;
                    versionSuffix = ctx.getReleaseBranchVersionSuffix();
                    break;
                }
                case HOTFIX: {
                    cacheKey = ProjectCacheKey.HOTFIX_LABEL;
                    versionType = VersionType.HOTFIX;
                    versionSuffix = "";
                    break;
                }
                default: {
                    throw new JGitFlowExtensionException("Unsupported branch type '" + branchType.name() + "' while running " + this.getClass().getSimpleName() + " command");
                }
            }
            Preconditions.checkNotNull((Object)((Object)cacheKey));
            Preconditions.checkNotNull((Object)((Object)versionType));
            unprefixedBranchName = this.branchHelper.getUnprefixedCurrentBranchName();
            List<MavenProject> branchProjects = this.branchHelper.getProjectsForCurrentBranch();
            this.pomUpdater.addSnapshotToPomVersions(cacheKey, versionType, versionSuffix, branchProjects);
            this.projectHelper.commitAllPoms(flow.git(), branchProjects, ctx.getScmCommentPrefix() + "updating poms for " + unprefixedBranchName + " branch with snapshot versions" + ctx.getScmCommentSuffix());
        }
        catch (Exception e) {
            throw new JGitFlowExtensionException("Error updating poms with snapshot versions for " + unprefixedBranchName + " branch: " + e.getMessage(), (Throwable)e);
        }
    }

    public ExtensionFailStrategy failStrategy() {
        return ExtensionFailStrategy.ERROR;
    }
}

