/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow;

import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import jline.ConsoleReader;
import jline.Terminal;
import jline.UnixTerminal;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.components.interactivity.AbstractInputHandler;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

@Component(role=InputHandler.class, hint="console")
public class ConsoleInputHandler
extends AbstractInputHandler
implements Initializable,
Disposable {
    private final Console console = System.console();
    private ConsoleReader jline;

    public ConsoleInputHandler() {
        if (null == this.console) {
            try {
                this.jline = new ConsoleReader();
            }
            catch (IOException e) {
                this.jline = null;
            }
        }
    }

    public void setCygwinTerminal() {
        try {
            this.jline = new ConsoleReader((InputStream)new FileInputStream(FileDescriptor.in), (Writer)new PrintWriter(new OutputStreamWriter((OutputStream)System.out, System.getProperty("jline.WindowsTerminal.output.encoding", System.getProperty("file.encoding")))), null, (Terminal)new UnixTerminal());
        }
        catch (IOException e) {
            this.jline = null;
        }
    }

    public void dispose() {
        if (this.noConsole()) {
            return;
        }
        if (null != this.console) {
            try {
                this.console.reader().close();
            }
            catch (IOException e) {
                this.getLogger().error("Error closing input stream must be ignored", (Throwable)e);
            }
        }
    }

    public void initialize() throws InitializationException {
    }

    public String readLine() throws IOException {
        if (null != this.console) {
            return this.console.readLine();
        }
        if (null != this.jline) {
            return this.jline.readLine();
        }
        return "";
    }

    public String readPassword() throws IOException {
        if (null != this.console) {
            return new String(this.console.readPassword());
        }
        if (null != this.jline) {
            return this.jline.readLine(new Character('*'));
        }
        return "";
    }

    private boolean noConsole() {
        return null == this.console && null == this.jline;
    }
}

