/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.manager;

import com.atlassian.jgitflow.core.BranchType;
import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.exception.JGitFlowException;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.VersionType;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.extension.ReleaseStartPluginExtension;
import com.atlassian.maven.plugins.jgitflow.helper.MavenExecutionHelper;
import com.atlassian.maven.plugins.jgitflow.helper.PomUpdater;
import com.atlassian.maven.plugins.jgitflow.helper.ProjectHelper;
import com.atlassian.maven.plugins.jgitflow.manager.AbstractFlowReleaseManager;
import com.atlassian.maven.plugins.jgitflow.provider.BranchLabelProvider;
import com.atlassian.maven.plugins.jgitflow.provider.ProjectCacheKey;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Requirement;

public abstract class AbstractProductionBranchManager
extends AbstractFlowReleaseManager {
    private final BranchType branchType;
    @Requirement
    protected MavenExecutionHelper mavenExecutionHelper;
    @Requirement
    protected ProjectHelper projectHelper;
    @Requirement
    protected BranchLabelProvider labelProvider;
    @Requirement
    protected PomUpdater pomUpdater;
    @Requirement
    protected ReleaseStartPluginExtension extension;

    public AbstractProductionBranchManager(BranchType branchType) {
        this.branchType = branchType;
    }

    public String getStartLabelAndRunPreflight(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session) throws JGitFlowException, MavenJGitFlowException {
        this.runPreflight(ctx, reactorProjects, session);
        JGitFlow flow = this.jGitFlowProvider.gitFlow();
        String branchName = null;
        VersionType versionType = null;
        ProjectCacheKey cacheKey = null;
        switch (this.branchType) {
            case RELEASE: {
                branchName = flow.getDevelopBranchName();
                versionType = VersionType.RELEASE;
                cacheKey = ProjectCacheKey.RELEASE_START_LABEL;
                break;
            }
            case HOTFIX: {
                branchName = flow.getMasterBranchName();
                versionType = VersionType.HOTFIX;
                cacheKey = ProjectCacheKey.HOTFIX_LABEL;
            }
        }
        Preconditions.checkNotNull(branchName);
        Preconditions.checkNotNull((Object)((Object)versionType));
        Preconditions.checkNotNull((Object)((Object)cacheKey));
        List<MavenProject> branchProjects = this.checkoutAndGetProjects.run(branchName).getProjects();
        this.verifyInitialVersionState.run(this.branchType, branchProjects);
        return this.labelProvider.getNextVersionLabel(versionType, cacheKey, branchProjects);
    }

    public String getFinishLabelAndRunPreflight(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session) throws JGitFlowException, MavenJGitFlowException {
        this.runPreflight(ctx, reactorProjects, session);
        return this.labelProvider.getCurrentProductionVersionLabel(this.branchType);
    }
}

