/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.Context;
import eu.toolchain.scribe.DatabindOptions;
import eu.toolchain.scribe.Decoded;
import eu.toolchain.scribe.Decoder;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.Encoder;
import eu.toolchain.scribe.EncoderFactory;
import eu.toolchain.scribe.EntityResolver;
import eu.toolchain.scribe.Flags;
import eu.toolchain.scribe.Mapping;
import eu.toolchain.scribe.Option;
import eu.toolchain.scribe.StreamEncoder;
import eu.toolchain.scribe.StreamEncoderFactory;
import eu.toolchain.scribe.TypeMatcher;
import eu.toolchain.scribe.detector.MappingDetector;
import eu.toolchain.scribe.detector.Match;
import eu.toolchain.scribe.detector.MatchPriority;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class OptionalMapping<T>
implements Mapping {
    private final Mapping component;
    private final Function<T, Boolean> isPresent;
    private final Function<T, Object> get;
    private final Function<Object, T> of;
    private final Supplier<T> empty;

    public static <T> MappingDetector forType(Class<T> optionalType, Function<T, Boolean> isPresent, Function<T, Object> get, Function<Object, T> of, Supplier<T> empty) {
        TypeMatcher matcher = TypeMatcher.type(optionalType, (TypeMatcher[])new TypeMatcher[]{TypeMatcher.any()});
        return (resolver, type) -> {
            if (matcher.matches(type)) {
                Mapping component = type.getTypeParameter(0).map(arg_0 -> ((EntityResolver)resolver).mapping(arg_0)).get();
                return Stream.of(new OptionalMapping(component, isPresent, get, of, empty)).map(Match.withPriority((MatchPriority)MatchPriority.HIGH));
            }
            return Stream.empty();
        };
    }

    public JavaType getType() {
        return this.component.getType();
    }

    public <Target, Source> Optional<Encoder<Target, Source>> newEncoder(EntityResolver resolver, Flags flags, EncoderFactory<Target> factory) {
        Function<Encoder, OptionalEncoder> encoder = resolver.isOptionPresent((Option)DatabindOptions.OPTIONAL_EMPTY_AS_NULL) ? p -> new OptionalEncoder<Target, Source>((Encoder)p){

            public void encodeOptionally(Context path, Source instance, Consumer<Target> callback) {
                callback.accept(this.encode(path, instance));
            }
        } : p -> new OptionalEncoder<Target, Source>((Encoder)p){

            public void encodeOptionally(Context path, Source instance, Consumer<Target> callback) {
                Object o = instance;
                if (((Boolean)OptionalMapping.this.isPresent.apply(o)).booleanValue()) {
                    callback.accept(this.parent.encode(path, OptionalMapping.this.get.apply(o)));
                }
            }
        };
        return this.component.newEncoder(resolver, flags, factory).map(encoder);
    }

    public <Target, Source> Optional<StreamEncoder<Target, Source>> newStreamEncoder(EntityResolver resolver, Flags flags, StreamEncoderFactory<Target> factory) {
        Function<StreamEncoder, OptionalStreamEncoder> encoder = resolver.isOptionPresent((Option)DatabindOptions.OPTIONAL_EMPTY_AS_NULL) ? p -> new OptionalStreamEncoder<Target, Source>((StreamEncoder)p){

            public void streamEncodeOptionally(Context path, Source instance, Target target, Consumer<Runnable> callback) {
                callback.accept(() -> this.streamEncode(path, instance, target));
            }
        } : p -> new OptionalStreamEncoder<Target, Source>((StreamEncoder)p){

            public void streamEncodeOptionally(Context path, Source instance, Target target, Consumer<Runnable> callback) {
                Object o = instance;
                if (((Boolean)OptionalMapping.this.isPresent.apply(o)).booleanValue()) {
                    callback.accept(() -> this.parent.streamEncode(path, OptionalMapping.this.get.apply(o), target));
                }
            }
        };
        return this.component.newStreamEncoder(resolver, flags, factory).map(encoder);
    }

    public <Target, Source> Optional<Decoder<Target, Source>> newDecoder(EntityResolver resolver, Flags flags, DecoderFactory<Target> factory) {
        return this.component.newDecoder(resolver, flags, factory).map(parent -> new OptionalDecoder(parent));
    }

    @ConstructorProperties(value={"component", "isPresent", "get", "of", "empty"})
    public OptionalMapping(Mapping component, Function<T, Boolean> isPresent, Function<T, Object> get, Function<Object, T> of, Supplier<T> empty) {
        this.component = component;
        this.isPresent = isPresent;
        this.get = get;
        this.of = of;
        this.empty = empty;
    }

    public Mapping getComponent() {
        return this.component;
    }

    public Function<T, Boolean> getIsPresent() {
        return this.isPresent;
    }

    public Function<T, Object> getGet() {
        return this.get;
    }

    public Function<Object, T> getOf() {
        return this.of;
    }

    public Supplier<T> getEmpty() {
        return this.empty;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OptionalMapping)) {
            return false;
        }
        OptionalMapping other = (OptionalMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Mapping this$component = this.getComponent();
        Mapping other$component = other.getComponent();
        if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
            return false;
        }
        Function<T, Boolean> this$isPresent = this.getIsPresent();
        Function<T, Boolean> other$isPresent = other.getIsPresent();
        if (this$isPresent == null ? other$isPresent != null : !this$isPresent.equals(other$isPresent)) {
            return false;
        }
        Function<T, Object> this$get = this.getGet();
        Function<T, Object> other$get = other.getGet();
        if (this$get == null ? other$get != null : !this$get.equals(other$get)) {
            return false;
        }
        Function<Object, T> this$of = this.getOf();
        Function<Object, T> other$of = other.getOf();
        if (this$of == null ? other$of != null : !this$of.equals(other$of)) {
            return false;
        }
        Supplier<T> this$empty = this.getEmpty();
        Supplier<T> other$empty = other.getEmpty();
        return !(this$empty == null ? other$empty != null : !this$empty.equals(other$empty));
    }

    public boolean canEqual(Object other) {
        return other instanceof OptionalMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Mapping $component = this.getComponent();
        result = result * 59 + ($component == null ? 0 : $component.hashCode());
        Function<T, Boolean> $isPresent = this.getIsPresent();
        result = result * 59 + ($isPresent == null ? 0 : $isPresent.hashCode());
        Function<T, Object> $get = this.getGet();
        result = result * 59 + ($get == null ? 0 : $get.hashCode());
        Function<Object, T> $of = this.getOf();
        result = result * 59 + ($of == null ? 0 : $of.hashCode());
        Supplier<T> $empty = this.getEmpty();
        result = result * 59 + ($empty == null ? 0 : $empty.hashCode());
        return result;
    }

    public String toString() {
        return "OptionalMapping(component=" + this.getComponent() + ", isPresent=" + this.getIsPresent() + ", get=" + this.getGet() + ", of=" + this.getOf() + ", empty=" + this.getEmpty() + ")";
    }

    class OptionalDecoder<Target, Source>
    implements Decoder<Target, T> {
        private final Decoder<Target, Source> parent;

        public Decoded<T> decode(Context path, Target instance) {
            return this.parent.decode(path, instance).handle(OptionalMapping.this.of, OptionalMapping.this.empty);
        }

        public Decoded<T> decodeOptionally(Context path, Decoded<Target> instance) {
            return instance.flatMap(v -> this.parent.decode(path, v).map(OptionalMapping.this.of)).handleAbsent(OptionalMapping.this.empty);
        }

        @ConstructorProperties(value={"parent"})
        public OptionalDecoder(Decoder<Target, Source> parent) {
            this.parent = parent;
        }

        public Decoder<Target, Source> getParent() {
            return this.parent;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OptionalDecoder)) {
                return false;
            }
            OptionalDecoder other = (OptionalDecoder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Decoder<Target, Source> this$parent = this.getParent();
            Decoder<Target, Source> other$parent = other.getParent();
            return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
        }

        public boolean canEqual(Object other) {
            return other instanceof OptionalDecoder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Decoder<Target, Source> $parent = this.getParent();
            result = result * 59 + ($parent == null ? 0 : $parent.hashCode());
            return result;
        }

        public String toString() {
            return "OptionalMapping.OptionalDecoder(parent=" + this.getParent() + ")";
        }
    }

    abstract class OptionalStreamEncoder<Target, Source>
    implements StreamEncoder<Target, Source> {
        protected final StreamEncoder<Target, Source> parent;

        public void streamEncode(Context path, Source instance, Target target) {
            Source o = instance;
            if (((Boolean)OptionalMapping.this.isPresent.apply(o)).booleanValue()) {
                this.parent.streamEncode(path, OptionalMapping.this.get.apply(o), target);
            } else {
                this.parent.streamEncodeEmpty(path, target);
            }
        }

        public void streamEncodeEmpty(Context path, Target target) {
            this.parent.streamEncodeEmpty(path, target);
        }

        @ConstructorProperties(value={"parent"})
        public OptionalStreamEncoder(StreamEncoder<Target, Source> parent) {
            this.parent = parent;
        }
    }

    abstract class OptionalEncoder<Target, Source>
    implements Encoder<Target, Source> {
        protected final Encoder<Target, Source> parent;

        public Target encode(Context path, Source instance) {
            Source o = instance;
            if (((Boolean)OptionalMapping.this.isPresent.apply(o)).booleanValue()) {
                return (Target)this.parent.encode(path, OptionalMapping.this.get.apply(o));
            }
            return (Target)this.parent.encodeEmpty(path);
        }

        public Target encodeEmpty(Context path) {
            return (Target)this.parent.encodeEmpty(path);
        }

        @ConstructorProperties(value={"parent"})
        public OptionalEncoder(Encoder<Target, Source> parent) {
            this.parent = parent;
        }
    }
}

