/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.Context;
import eu.toolchain.scribe.Encoder;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;

class EntityEncodeValueEncoder<Target, Source>
implements Encoder<Target, Source> {
    private final JavaType.Method valueMethod;
    private final Encoder<Target, Source> parent;

    public Target encode(Context path, Source instance) {
        Object value;
        try {
            value = this.valueMethod.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw path.error("failed to get value", (Throwable)e);
        }
        return (Target)this.parent.encode(path, value);
    }

    public Target encodeEmpty(Context path) {
        return (Target)this.parent.encodeEmpty(path);
    }

    @ConstructorProperties(value={"valueMethod", "parent"})
    public EntityEncodeValueEncoder(JavaType.Method valueMethod, Encoder<Target, Source> parent) {
        this.valueMethod = valueMethod;
        this.parent = parent;
    }

    public JavaType.Method getValueMethod() {
        return this.valueMethod;
    }

    public Encoder<Target, Source> getParent() {
        return this.parent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityEncodeValueEncoder)) {
            return false;
        }
        EntityEncodeValueEncoder other = (EntityEncodeValueEncoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaType.Method this$valueMethod = this.getValueMethod();
        JavaType.Method other$valueMethod = other.getValueMethod();
        if (this$valueMethod == null ? other$valueMethod != null : !this$valueMethod.equals(other$valueMethod)) {
            return false;
        }
        Encoder<Target, Source> this$parent = this.getParent();
        Encoder<Target, Source> other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
    }

    public boolean canEqual(Object other) {
        return other instanceof EntityEncodeValueEncoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaType.Method $valueMethod = this.getValueMethod();
        result = result * 59 + ($valueMethod == null ? 0 : $valueMethod.hashCode());
        Encoder<Target, Source> $parent = this.getParent();
        result = result * 59 + ($parent == null ? 0 : $parent.hashCode());
        return result;
    }

    public String toString() {
        return "EntityEncodeValueEncoder(valueMethod=" + this.getValueMethod() + ", parent=" + this.getParent() + ")";
    }
}

