/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.EncodeValue;
import eu.toolchain.scribe.Encoder;
import eu.toolchain.scribe.EncoderFactory;
import eu.toolchain.scribe.EntityEncodeValueEncoder;
import eu.toolchain.scribe.EntityEncodeValueStreamEncoder;
import eu.toolchain.scribe.EntityResolver;
import eu.toolchain.scribe.Flags;
import eu.toolchain.scribe.Mapping;
import eu.toolchain.scribe.StreamEncoder;
import eu.toolchain.scribe.StreamEncoderFactory;
import eu.toolchain.scribe.detector.EncodeValueDetector;
import eu.toolchain.scribe.detector.Match;
import eu.toolchain.scribe.detector.MatchPriority;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.stream.Stream;

public class EntityEncodeValue
implements EncodeValue {
    private final JavaType sourceType;
    private final Mapping targetMapping;
    private final JavaType.Method valueMethod;

    public <Target, Source> Optional<Encoder<Target, Source>> newEncoder(EntityResolver resolver, EncoderFactory<Target> factory) {
        return this.targetMapping.newEncoder(resolver, Flags.empty(), factory).map(parent -> new EntityEncodeValueEncoder(this.valueMethod, parent));
    }

    public <Target, Source> Optional<StreamEncoder<Target, Source>> newStreamEncoder(EntityResolver resolver, StreamEncoderFactory<Target> factory) {
        return this.targetMapping.newStreamEncoder(resolver, Flags.empty(), factory).map(parent -> new EntityEncodeValueStreamEncoder(this.valueMethod, parent));
    }

    public static EncodeValueDetector forAnnotation(Class<? extends Annotation> annotation) {
        return (resolver, sourceType) -> sourceType.findByAnnotation(JavaType::getMethods, annotation).filter(m -> m.isPublic() && !m.isStatic()).flatMap(m -> {
            if (m.getParameters().size() != 0) {
                throw new IllegalArgumentException(String.format("@%s method must have no parameters: %s", annotation.getSimpleName(), m));
            }
            Mapping targetMapping = resolver.mapping(m.getReturnType());
            return Stream.of(new EntityEncodeValue(sourceType, targetMapping, (JavaType.Method)m));
        }).map(Match.withPriority((MatchPriority)MatchPriority.HIGH));
    }

    @ConstructorProperties(value={"sourceType", "targetMapping", "valueMethod"})
    public EntityEncodeValue(JavaType sourceType, Mapping targetMapping, JavaType.Method valueMethod) {
        this.sourceType = sourceType;
        this.targetMapping = targetMapping;
        this.valueMethod = valueMethod;
    }

    public JavaType getSourceType() {
        return this.sourceType;
    }

    public Mapping getTargetMapping() {
        return this.targetMapping;
    }

    public JavaType.Method getValueMethod() {
        return this.valueMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityEncodeValue)) {
            return false;
        }
        EntityEncodeValue other = (EntityEncodeValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaType this$sourceType = this.getSourceType();
        JavaType other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
            return false;
        }
        Mapping this$targetMapping = this.getTargetMapping();
        Mapping other$targetMapping = other.getTargetMapping();
        if (this$targetMapping == null ? other$targetMapping != null : !this$targetMapping.equals(other$targetMapping)) {
            return false;
        }
        JavaType.Method this$valueMethod = this.getValueMethod();
        JavaType.Method other$valueMethod = other.getValueMethod();
        return !(this$valueMethod == null ? other$valueMethod != null : !this$valueMethod.equals(other$valueMethod));
    }

    public boolean canEqual(Object other) {
        return other instanceof EntityEncodeValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaType $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 0 : $sourceType.hashCode());
        Mapping $targetMapping = this.getTargetMapping();
        result = result * 59 + ($targetMapping == null ? 0 : $targetMapping.hashCode());
        JavaType.Method $valueMethod = this.getValueMethod();
        result = result * 59 + ($valueMethod == null ? 0 : $valueMethod.hashCode());
        return result;
    }

    public String toString() {
        return "EntityEncodeValue(sourceType=" + this.getSourceType() + ", targetMapping=" + this.getTargetMapping() + ", valueMethod=" + this.getValueMethod() + ")";
    }
}

