/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.Context;
import eu.toolchain.scribe.Decoded;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.EntityDecoder;
import eu.toolchain.scribe.EntityFieldDecoder;
import eu.toolchain.scribe.EntityFieldsDecoder;
import eu.toolchain.scribe.InstanceBuilder;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;

public class DefaultEntityDecoder<Target>
implements EntityDecoder<Target, Object> {
    private final List<EntityFieldDecoder<Target, Object>> fields;
    private final InstanceBuilder instanceBuilder;
    private final DecoderFactory<Target> factory;

    public Decoded<Object> decode(EntityFieldsDecoder<Target> decoder, Context path) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (EntityFieldDecoder<Target, Object> m : this.fields) {
            Context p = path.push(m.getName());
            arguments.add(decoder.decodeField(m, p).orElseThrow(() -> p.error("missing required field")));
        }
        try {
            return Decoded.of((Object)this.instanceBuilder.newInstance(arguments));
        }
        catch (Exception e) {
            throw path.error("Could not build instance using " + this.instanceBuilder, (Throwable)e);
        }
    }

    public Decoded<Object> decode(Context path, Target instance) {
        return this.factory.newEntityDecoder(instance).flatMap(d -> this.decode((EntityFieldsDecoder<Target>)d, path));
    }

    @ConstructorProperties(value={"fields", "instanceBuilder", "factory"})
    public DefaultEntityDecoder(List<EntityFieldDecoder<Target, Object>> fields, InstanceBuilder instanceBuilder, DecoderFactory<Target> factory) {
        this.fields = fields;
        this.instanceBuilder = instanceBuilder;
        this.factory = factory;
    }

    public List<EntityFieldDecoder<Target, Object>> getFields() {
        return this.fields;
    }

    public InstanceBuilder getInstanceBuilder() {
        return this.instanceBuilder;
    }

    public DecoderFactory<Target> getFactory() {
        return this.factory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultEntityDecoder)) {
            return false;
        }
        DefaultEntityDecoder other = (DefaultEntityDecoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<EntityFieldDecoder<Target, Object>> this$fields = this.getFields();
        List<EntityFieldDecoder<Target, Object>> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        InstanceBuilder this$instanceBuilder = this.getInstanceBuilder();
        InstanceBuilder other$instanceBuilder = other.getInstanceBuilder();
        if (this$instanceBuilder == null ? other$instanceBuilder != null : !this$instanceBuilder.equals(other$instanceBuilder)) {
            return false;
        }
        DecoderFactory<Target> this$factory = this.getFactory();
        DecoderFactory<Target> other$factory = other.getFactory();
        return !(this$factory == null ? other$factory != null : !this$factory.equals(other$factory));
    }

    public boolean canEqual(Object other) {
        return other instanceof DefaultEntityDecoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<EntityFieldDecoder<Target, Object>> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 0 : ((Object)$fields).hashCode());
        InstanceBuilder $instanceBuilder = this.getInstanceBuilder();
        result = result * 59 + ($instanceBuilder == null ? 0 : $instanceBuilder.hashCode());
        DecoderFactory<Target> $factory = this.getFactory();
        result = result * 59 + ($factory == null ? 0 : $factory.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultEntityDecoder(fields=" + this.getFields() + ", instanceBuilder=" + this.getInstanceBuilder() + ", factory=" + this.getFactory() + ")";
    }
}

