/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.Context;
import eu.toolchain.scribe.Decoded;
import eu.toolchain.scribe.Decoder;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;

public class ConstructorEntityDecodeValueDecoder<Target, Source>
implements Decoder<Target, Source> {
    private final JavaType.Constructor constructor;
    private final Decoder<Target, Source> parent;

    public Decoded<Source> decode(Context path, Target instance) {
        return this.parent.decode(path, instance).map(value -> {
            try {
                return this.constructor.newInstance(new Object[]{value});
            }
            catch (Exception e) {
                throw path.error("failed to get value", (Throwable)e);
            }
        });
    }

    @ConstructorProperties(value={"constructor", "parent"})
    public ConstructorEntityDecodeValueDecoder(JavaType.Constructor constructor, Decoder<Target, Source> parent) {
        this.constructor = constructor;
        this.parent = parent;
    }

    public JavaType.Constructor getConstructor() {
        return this.constructor;
    }

    public Decoder<Target, Source> getParent() {
        return this.parent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstructorEntityDecodeValueDecoder)) {
            return false;
        }
        ConstructorEntityDecodeValueDecoder other = (ConstructorEntityDecodeValueDecoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JavaType.Constructor this$constructor = this.getConstructor();
        JavaType.Constructor other$constructor = other.getConstructor();
        if (this$constructor == null ? other$constructor != null : !this$constructor.equals(other$constructor)) {
            return false;
        }
        Decoder<Target, Source> this$parent = this.getParent();
        Decoder<Target, Source> other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
    }

    public boolean canEqual(Object other) {
        return other instanceof ConstructorEntityDecodeValueDecoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaType.Constructor $constructor = this.getConstructor();
        result = result * 59 + ($constructor == null ? 0 : $constructor.hashCode());
        Decoder<Target, Source> $parent = this.getParent();
        result = result * 59 + ($parent == null ? 0 : $parent.hashCode());
        return result;
    }

    public String toString() {
        return "ConstructorEntityDecodeValueDecoder(constructor=" + this.getConstructor() + ", parent=" + this.getParent() + ")";
    }
}

