/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.BuilderEntityFieldDecoder;
import eu.toolchain.scribe.Context;
import eu.toolchain.scribe.Decoded;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.EntityDecoder;
import eu.toolchain.scribe.EntityFieldsDecoder;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;
import java.util.List;

public class BuilderEntityDecoder<Target>
implements EntityDecoder<Target, Object> {
    private final List<BuilderEntityFieldDecoder<Target>> fields;
    private final JavaType.Method newInstance;
    private final JavaType.Method build;
    private final DecoderFactory<Target> factory;

    public Decoded<Object> decode(EntityFieldsDecoder<Target> encoder, Context path) {
        Object builder;
        try {
            builder = this.newInstance.invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to create instance forAnnotation builder (" + this.newInstance + ")", e);
        }
        for (BuilderEntityFieldDecoder<Target> m : this.fields) {
            Context p = path.push(m.getName());
            Object value = encoder.decodeField(m, p).orElseThrow(() -> p.error("missing required field"));
            try {
                m.setter().invoke(builder, new Object[]{value});
            }
            catch (Exception e) {
                throw p.error("Failed to invoke builder method " + m.getName() + " with argument (" + value + ")", (Throwable)e);
            }
        }
        try {
            return Decoded.of((Object)this.build.invoke(builder, new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not build instance using " + this.build, e);
        }
    }

    public Decoded<Object> decode(Context path, Target instance) {
        return this.factory.newEntityDecoder(instance).flatMap(d -> this.decode((EntityFieldsDecoder<Target>)d, path));
    }

    @ConstructorProperties(value={"fields", "newInstance", "build", "factory"})
    public BuilderEntityDecoder(List<BuilderEntityFieldDecoder<Target>> fields, JavaType.Method newInstance, JavaType.Method build, DecoderFactory<Target> factory) {
        this.fields = fields;
        this.newInstance = newInstance;
        this.build = build;
        this.factory = factory;
    }

    public List<BuilderEntityFieldDecoder<Target>> getFields() {
        return this.fields;
    }

    public JavaType.Method getNewInstance() {
        return this.newInstance;
    }

    public JavaType.Method getBuild() {
        return this.build;
    }

    public DecoderFactory<Target> getFactory() {
        return this.factory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuilderEntityDecoder)) {
            return false;
        }
        BuilderEntityDecoder other = (BuilderEntityDecoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<BuilderEntityFieldDecoder<Target>> this$fields = this.getFields();
        List<BuilderEntityFieldDecoder<Target>> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        JavaType.Method this$newInstance = this.getNewInstance();
        JavaType.Method other$newInstance = other.getNewInstance();
        if (this$newInstance == null ? other$newInstance != null : !this$newInstance.equals(other$newInstance)) {
            return false;
        }
        JavaType.Method this$build = this.getBuild();
        JavaType.Method other$build = other.getBuild();
        if (this$build == null ? other$build != null : !this$build.equals(other$build)) {
            return false;
        }
        DecoderFactory<Target> this$factory = this.getFactory();
        DecoderFactory<Target> other$factory = other.getFactory();
        return !(this$factory == null ? other$factory != null : !this$factory.equals(other$factory));
    }

    public boolean canEqual(Object other) {
        return other instanceof BuilderEntityDecoder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<BuilderEntityFieldDecoder<Target>> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 0 : ((Object)$fields).hashCode());
        JavaType.Method $newInstance = this.getNewInstance();
        result = result * 59 + ($newInstance == null ? 0 : $newInstance.hashCode());
        JavaType.Method $build = this.getBuild();
        result = result * 59 + ($build == null ? 0 : $build.hashCode());
        DecoderFactory<Target> $factory = this.getFactory();
        result = result * 59 + ($factory == null ? 0 : $factory.hashCode());
        return result;
    }

    public String toString() {
        return "BuilderEntityDecoder(fields=" + this.getFields() + ", newInstance=" + this.getNewInstance() + ", build=" + this.getBuild() + ", factory=" + this.getFactory() + ")";
    }
}

