/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.scribe;

import eu.toolchain.scribe.BuilderEntityDecoder;
import eu.toolchain.scribe.BuilderEntityFieldDecoder;
import eu.toolchain.scribe.BuilderEntityFieldEncoder;
import eu.toolchain.scribe.BuilderEntityFieldMapping;
import eu.toolchain.scribe.BuilderEntityFieldStreamEncoder;
import eu.toolchain.scribe.ClassEncoding;
import eu.toolchain.scribe.DecoderFactory;
import eu.toolchain.scribe.EncoderFactory;
import eu.toolchain.scribe.EntityDecoder;
import eu.toolchain.scribe.EntityEncoder;
import eu.toolchain.scribe.EntityResolver;
import eu.toolchain.scribe.EntityStreamEncoder;
import eu.toolchain.scribe.FieldReader;
import eu.toolchain.scribe.Flags;
import eu.toolchain.scribe.Mapping;
import eu.toolchain.scribe.ReadFieldsEntityEncoder;
import eu.toolchain.scribe.ReadFieldsEntityStreamEncoder;
import eu.toolchain.scribe.StreamEncoderFactory;
import eu.toolchain.scribe.detector.Match;
import eu.toolchain.scribe.detector.MatchPriority;
import eu.toolchain.scribe.reflection.AccessibleType;
import eu.toolchain.scribe.reflection.Annotations;
import eu.toolchain.scribe.reflection.JavaType;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

public class BuilderClassEncoding
implements ClassEncoding {
    private final List<BuilderEntityFieldMapping> fields;
    private final JavaType.Method newInstance;
    private final JavaType.Method build;

    public <Target> EntityEncoder<Target, Object> newEntityEncoder(EntityResolver resolver, EncoderFactory<Target> factory) {
        ArrayList fields = new ArrayList();
        for (BuilderEntityFieldMapping field : this.fields) {
            BuilderEntityFieldEncoder<Target> fieldEncoder = field.newEntityFieldEncoder(resolver, factory).orElseThrow(() -> new IllegalArgumentException("Unable to apply encoding for field (" + field + ")"));
            fields.add(new ReadFieldsEntityEncoder.Field(fieldEncoder, field.getReader()));
        }
        return new ReadFieldsEntityEncoder<Target>(Collections.unmodifiableList(fields), factory);
    }

    public <Target> EntityStreamEncoder<Target, Object> newEntityStreamEncoder(EntityResolver resolver, StreamEncoderFactory<Target> factory) {
        ArrayList fields = new ArrayList();
        for (BuilderEntityFieldMapping field : this.fields) {
            BuilderEntityFieldStreamEncoder<Target> encoder = field.newEntityFieldStreamEncoder(resolver, factory).orElseThrow(() -> new IllegalArgumentException("Unable to apply encoding for field (" + field + ")"));
            fields.add(new ReadFieldsEntityStreamEncoder.ReadFieldsEntityField(encoder, field.getReader()));
        }
        return new ReadFieldsEntityStreamEncoder(Collections.unmodifiableList(fields), factory);
    }

    public <Target> EntityDecoder<Target, Object> newEntityDecoder(EntityResolver resolver, DecoderFactory<Target> factory) {
        ArrayList<BuilderEntityFieldDecoder<Target>> fields = new ArrayList<BuilderEntityFieldDecoder<Target>>();
        for (BuilderEntityFieldMapping field : this.fields) {
            fields.add(field.newEntityFieldDecoder(resolver, factory).orElseThrow(() -> new IllegalArgumentException("Unable to apply encoding for field (" + field + ")")));
        }
        return new BuilderEntityDecoder(Collections.unmodifiableList(fields), this.newInstance, this.build, factory);
    }

    public static Stream<Match<ClassEncoding>> detect(EntityResolver resolver, JavaType type) {
        return type.getMethod("builder", new JavaType[0]).filter(AccessibleType::isStatic).map(newInstance -> {
            ArrayList fields = new ArrayList();
            JavaType returnType = newInstance.getReturnType();
            JavaType.Method builderBuild = (JavaType.Method)returnType.getMethod("build", new JavaType[0]).findFirst().orElseThrow(() -> new IllegalArgumentException("Method build() missing on type (" + returnType + ")"));
            if (!builderBuild.getReturnType().equals((Object)type)) {
                throw new IllegalArgumentException(builderBuild + " returns (" + builderBuild.getReturnType() + ") instead forAnnotation expected (" + type + ")");
            }
            type.getFields().filter(f -> !f.isStatic()).forEach(field -> {
                JavaType propertyType = field.getFieldType();
                FieldReader reader = (FieldReader)resolver.detectFieldReader(type, field.getName(), propertyType).orElseThrow(() -> new IllegalArgumentException("Can't figure out how to read (" + type + ") field (" + field.getName() + ")"));
                JavaType.Method setter = (JavaType.Method)returnType.getMethod(field.getName(), new JavaType[]{propertyType}).findFirst().orElseThrow(() -> new IllegalArgumentException("Builder does not have method " + returnType + "#" + field.getName() + "(" + propertyType + ")"));
                Annotations annotations = reader.annotations().merge(Annotations.of((Stream)field.getAnnotationStream()));
                String fieldName = resolver.detectFieldName(type, annotations).orElseGet(() -> ((JavaType.Field)field).getName());
                Mapping m = resolver.mapping(reader.fieldType(), annotations);
                Flags flags = resolver.detectFieldFlags(reader.fieldType(), annotations);
                fields.add(new BuilderEntityFieldMapping(fieldName, m, reader, setter, flags));
            });
            return new BuilderClassEncoding(Collections.unmodifiableList(fields), (JavaType.Method)newInstance, builderBuild);
        }).map(Match.withPriority((MatchPriority)MatchPriority.LOW));
    }

    @ConstructorProperties(value={"fields", "newInstance", "build"})
    public BuilderClassEncoding(List<BuilderEntityFieldMapping> fields, JavaType.Method newInstance, JavaType.Method build) {
        this.fields = fields;
        this.newInstance = newInstance;
        this.build = build;
    }

    public List<BuilderEntityFieldMapping> getFields() {
        return this.fields;
    }

    public JavaType.Method getNewInstance() {
        return this.newInstance;
    }

    public JavaType.Method getBuild() {
        return this.build;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuilderClassEncoding)) {
            return false;
        }
        BuilderClassEncoding other = (BuilderClassEncoding)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<BuilderEntityFieldMapping> this$fields = this.getFields();
        List<BuilderEntityFieldMapping> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        JavaType.Method this$newInstance = this.getNewInstance();
        JavaType.Method other$newInstance = other.getNewInstance();
        if (this$newInstance == null ? other$newInstance != null : !this$newInstance.equals(other$newInstance)) {
            return false;
        }
        JavaType.Method this$build = this.getBuild();
        JavaType.Method other$build = other.getBuild();
        return !(this$build == null ? other$build != null : !this$build.equals(other$build));
    }

    public boolean canEqual(Object other) {
        return other instanceof BuilderClassEncoding;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<BuilderEntityFieldMapping> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 0 : ((Object)$fields).hashCode());
        JavaType.Method $newInstance = this.getNewInstance();
        result = result * 59 + ($newInstance == null ? 0 : $newInstance.hashCode());
        JavaType.Method $build = this.getBuild();
        result = result * 59 + ($build == null ? 0 : $build.hashCode());
        return result;
    }

    public String toString() {
        return "BuilderClassEncoding(fields=" + this.getFields() + ", newInstance=" + this.getNewInstance() + ", build=" + this.getBuild() + ")";
    }
}

