/*
 * Decompiled with CFR 0.152.
 */
package eu.miaplatform.service.environment;

import eu.miaplatform.service.environment.EnvVariable;
import eu.miaplatform.service.environment.InvalidEnvConfigurationException;
import java.util.HashMap;
import java.util.Map;

public class EnvConfiguration {
    private Map<String, String> envVariables;
    private static final String LIST_SEPARATOR = ",";
    private static EnvConfiguration envConfigurationInstance = null;
    private static final String MISSING_ENV_VARIABLE_MESSAGE = "Required environment variable not found: %s.";

    private EnvConfiguration() {
    }

    public static EnvConfiguration getInstance() {
        if (envConfigurationInstance == null) {
            envConfigurationInstance = new EnvConfiguration();
        }
        return envConfigurationInstance;
    }

    public static void parseEnvironment(EnvVariable[] schema) throws InvalidEnvConfigurationException {
        Map<String, String> envVariables = EnvConfiguration.customPluginRequiredVariables();
        for (EnvVariable envVariable : schema) {
            if (System.getenv(envVariable.getKey()) != null) {
                envVariables.put(envVariable.getKey(), System.getenv(envVariable.getKey()));
                continue;
            }
            if (envVariable.isRequired()) {
                throw new InvalidEnvConfigurationException(String.format(MISSING_ENV_VARIABLE_MESSAGE, envVariable.getKey()));
            }
            if (envVariable.getDefaultValue() == null) continue;
            envVariables.put(envVariable.getKey(), envVariable.getDefaultValue());
        }
        EnvConfiguration.getInstance().setEnvVariables(envVariables);
    }

    public static void parseEnvironment() throws InvalidEnvConfigurationException {
        Map<String, String> envVariables = EnvConfiguration.customPluginRequiredVariables();
        EnvConfiguration.getInstance().setEnvVariables(envVariables);
    }

    private static Map<String, String> customPluginRequiredVariables() throws InvalidEnvConfigurationException {
        HashMap<String, String> requiredEnvVariables = new HashMap<String, String>();
        requiredEnvVariables.put("USERID_HEADER_KEY", EnvConfiguration.getRequired("USERID_HEADER_KEY"));
        requiredEnvVariables.put("GROUPS_HEADER_KEY", EnvConfiguration.getRequired("GROUPS_HEADER_KEY"));
        requiredEnvVariables.put("CLIENTTYPE_HEADER_KEY", EnvConfiguration.getRequired("CLIENTTYPE_HEADER_KEY"));
        requiredEnvVariables.put("BACKOFFICE_HEADER_KEY", EnvConfiguration.getRequired("BACKOFFICE_HEADER_KEY"));
        requiredEnvVariables.put("MICROSERVICE_GATEWAY_SERVICE_NAME", EnvConfiguration.getRequired("MICROSERVICE_GATEWAY_SERVICE_NAME"));
        return requiredEnvVariables;
    }

    private static String getRequired(String envKey) throws InvalidEnvConfigurationException {
        String value = System.getenv(envKey);
        if (value == null || value.isEmpty()) {
            throw new InvalidEnvConfigurationException(String.format(MISSING_ENV_VARIABLE_MESSAGE, envKey));
        }
        return value;
    }

    public String get(String envKey) {
        return this.envVariables.get(envKey);
    }

    public Map<String, String> getEnvVariables() {
        return this.envVariables;
    }

    public void setEnvVariables(Map<String, String> envVariables) {
        this.envVariables = envVariables;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnvConfiguration)) {
            return false;
        }
        EnvConfiguration other = (EnvConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$envVariables = this.getEnvVariables();
        Map<String, String> other$envVariables = other.getEnvVariables();
        return !(this$envVariables == null ? other$envVariables != null : !((Object)this$envVariables).equals(other$envVariables));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnvConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $envVariables = this.getEnvVariables();
        result = result * 59 + ($envVariables == null ? 43 : ((Object)$envVariables).hashCode());
        return result;
    }

    public String toString() {
        return "EnvConfiguration(envVariables=" + this.getEnvVariables() + ")";
    }
}

