/*
 * Decompiled with CFR 0.152.
 */
package eu.miaplatform.decorators;

import eu.miaplatform.decorators.AbortChainResponse;
import eu.miaplatform.decorators.DecoratorResponse;
import eu.miaplatform.decorators.constants.DecoratorConstants;
import eu.miaplatform.decorators.postdecorators.ChangeOriginalResponse;
import eu.miaplatform.decorators.postdecorators.LeaveOriginalResponseUnmodified;
import eu.miaplatform.decorators.postdecorators.PostDecoratorRequest;
import eu.miaplatform.decorators.predecorators.ChangeOriginalRequest;
import eu.miaplatform.decorators.predecorators.LeaveOriginalRequestUnmodified;
import eu.miaplatform.decorators.predecorators.PreDecoratorRequest;
import java.io.Serializable;
import java.util.Map;

public class DecoratorResponseFactory {
    public static DecoratorResponse makePreDecoratorResponse(PreDecoratorRequest preDecoratorRequest) {
        if (preDecoratorRequest == null) {
            return new LeaveOriginalRequestUnmodified();
        }
        return new ChangeOriginalRequest(preDecoratorRequest.getRequest());
    }

    public static DecoratorResponse makePostDecoratorResponse(PostDecoratorRequest postDecoratorRequest) {
        if (postDecoratorRequest == null) {
            return new LeaveOriginalResponseUnmodified();
        }
        return new ChangeOriginalResponse(postDecoratorRequest.getResponse());
    }

    public static DecoratorResponse abortChain(int finalStatusCode) {
        DecoratorResponse body = DecoratorResponse.builder().statusCode(finalStatusCode).build();
        return new AbortChainResponse(body, DecoratorConstants.DEFAULT_HEADERS);
    }

    public static DecoratorResponse abortChain(int finalStatusCode, Serializable finalBody, Map<String, String> finalHeaders) {
        DecoratorResponse body = DecoratorResponse.builder().statusCode(finalStatusCode).body(finalBody).build();
        return new AbortChainResponse(body, finalHeaders);
    }
}

