/*
 * Decompiled with CFR 0.152.
 */
package eu.miaplatform.crud.library.sync;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import eu.miaplatform.crud.library.CRUD;
import eu.miaplatform.crud.library.CRUDError;
import eu.miaplatform.crud.library.CRUDObject;
import eu.miaplatform.crud.library.GET;
import eu.miaplatform.crud.library.GsonFactory;
import eu.miaplatform.crud.library.PATCH;
import eu.miaplatform.crud.library.POST;
import eu.miaplatform.crud.library.QueryBuilder;
import eu.miaplatform.crud.library.annotations.CollectionAnnotation;
import eu.miaplatform.crud.library.enums.State;
import eu.miaplatform.crud.library.sync.DatabaseSync;
import eu.miaplatform.crud.library.sync.Sync$WhenMappings;
import eu.miaplatform.crud.library.sync.Syncable;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u0004\u0018\u00010\b\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\fH\u0002J/\u0010\r\u001a\u00020\u000e2\"\u0010\u000b\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\f0\u000f\"\n\u0012\u0006\b\u0001\u0012\u00020\n0\f\u00a2\u0006\u0002\u0010\u0010J.\u0010\r\u001a\u00020\u000e2&\u0010\u0011\u001a\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\f0\u0012j\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\f`\u0013J*\u0010\u0014\u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J/\u0010\u0017\u001a\u00020\u000e2\"\u0010\u000b\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\f0\u000f\"\n\u0012\u0006\b\u0001\u0012\u00020\n0\f\u00a2\u0006\u0002\u0010\u0010J.\u0010\u0017\u001a\u00020\u000e2&\u0010\u0011\u001a\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\f0\u0012j\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\f`\u0013J8\u0010\u0018\u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0016\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u0002H\t0\u0012j\b\u0012\u0004\u0012\u0002H\t`\u0013H\u0002J8\u0010\u001a\u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u0002H\t0\u0012j\b\u0012\u0004\u0012\u0002H\t`\u0013H\u0002J8\u0010\u001c\u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u0002H\t0\u0012j\b\u0012\u0004\u0012\u0002H\t`\u0013H\u0002J(\u0010\u001e\u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\n2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u0002H\t0\u0012j\b\u0012\u0004\u0012\u0002H\t`\u0013J(\u0010 \u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\n2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u0002H\t0\u0012j\b\u0012\u0004\u0012\u0002H\t`\u0013J(\u0010!\u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\n2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u0002H\t0\u0012j\b\u0012\u0004\u0012\u0002H\t`\u0013J(\u0010\"\u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\n2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u0002H\t0\u0012j\b\u0012\u0004\u0012\u0002H\t`\u0013J(\u0010#\u001a\u00020\u000e\"\b\b\u0000\u0010\t*\u00020\n2\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u0002H\t0\u0012j\b\u0012\u0004\u0012\u0002H\t`\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Leu/miaplatform/crud/library/sync/Sync;", "", "crud", "Leu/miaplatform/crud/library/CRUD;", "db", "Leu/miaplatform/crud/library/sync/DatabaseSync;", "(Leu/miaplatform/crud/library/CRUD;Leu/miaplatform/crud/library/sync/DatabaseSync;)V", "getCollectionNameFromAnnotation", "", "T", "Leu/miaplatform/crud/library/sync/Syncable;", "clazz", "Ljava/lang/Class;", "pull", "", "", "([Ljava/lang/Class;)V", "classes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "pullCollectionUpdates", "maxUpdatedAt", "Ljava/util/Date;", "push", "pushChangeStateInCollection", "objectsToChangeState", "pushObjectsInCollection", "objectsToPush", "pushUpdatesInCollection", "objectsToUpdate", "toDeleted", "objects", "toDraft", "toPublic", "toPush", "toTrash", "mia-service-java-library"})
public final class Sync {
    private final CRUD crud;
    private final DatabaseSync db;

    public final void pull(Class<? extends Syncable> ... clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        ArrayList<Class<? extends Syncable>> classesArrayList = new ArrayList<Class<? extends Syncable>>();
        Collections.addAll((Collection)classesArrayList, Arrays.copyOf(clazz, clazz.length));
        this.pull(classesArrayList);
    }

    public final void pull(@NotNull ArrayList<Class<? extends Syncable>> classes) {
        Intrinsics.checkParameterIsNotNull(classes, (String)"classes");
        Iterator<Class<? extends Syncable>> iterator = classes.iterator();
        while (iterator.hasNext()) {
            Class<? extends Syncable> clazz;
            Class<? extends Syncable> clazz2 = clazz = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"clazz");
            Date maxUpdatedAt = this.db.getMaxUpdatedAt(clazz2);
            this.pullCollectionUpdates(clazz, maxUpdatedAt);
        }
    }

    public final void push(Class<? extends Syncable> ... clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        ArrayList<Class<? extends Syncable>> classesArrayList = new ArrayList<Class<? extends Syncable>>();
        Collections.addAll((Collection)classesArrayList, Arrays.copyOf(clazz, clazz.length));
        this.push(classesArrayList);
    }

    /*
     * WARNING - void declaration
     */
    public final void push(@NotNull ArrayList<Class<? extends Syncable>> classes) {
        Map map;
        void $receiver$iv$iv;
        Iterable $receiver$iv2;
        Object element$iv$iv;
        void $receiver$iv$iv3;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(classes, (String)"classes");
        Iterable iterable = $receiver$iv = (Iterable)this.db.getObjectsToPush(classes);
        Map map2 = new LinkedHashMap();
        Iterator<Object> iterator = $receiver$iv$iv3.iterator();
        while (iterator.hasNext()) {
            Object object;
            Map $receiver$iv$iv$iv = map2;
            element$iv$iv = iterator.next();
            Syncable it = (Syncable)element$iv$iv;
            Class<?> key$iv$iv = it.getClass();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map objectToPushGrouped = map2;
        Iterable iterable2 = $receiver$iv2 = (Iterable)this.db.getObjectsToUpdate(classes);
        Object destination$iv$iv2 = new LinkedHashMap();
        element$iv$iv = iterable2.iterator();
        while (element$iv$iv.hasNext()) {
            Object object;
            Object $receiver$iv$iv$iv = destination$iv$iv2;
            Object element$iv$iv2 = element$iv$iv.next();
            Syncable it = (Syncable)element$iv$iv2;
            Class<?> key$iv$iv = it.getClass();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv2);
        }
        Map objectToUpdateGrouped = destination$iv$iv2;
        Iterable iterable3 = this.db.getObjectsToChangeState(classes);
        destination$iv$iv2 = iterable3;
        Map destination$iv$iv3 = new LinkedHashMap();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Map $receiver$iv$iv$iv = destination$iv$iv3;
            Object element$iv$iv3 = iterator2.next();
            Syncable it = (Syncable)element$iv$iv3;
            Class<?> key$iv$iv = it.getClass();
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv3);
        }
        Map objectToChangeStateGrouped = destination$iv$iv3;
        if (!objectToPushGrouped.isEmpty()) {
            map = objectToPushGrouped;
            for (Map.Entry entry : map.entrySet()) {
                Object v = entry.getValue();
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.ArrayList<eu.miaplatform.crud.library.sync.Syncable> /* = java.util.ArrayList<eu.miaplatform.crud.library.sync.Syncable> */");
                }
                this.pushObjectsInCollection((Class)entry.getKey(), (ArrayList)v);
            }
        }
        if (!objectToUpdateGrouped.isEmpty()) {
            map = objectToUpdateGrouped;
            for (Map.Entry entry : map.entrySet()) {
                Object v = entry.getValue();
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.ArrayList<eu.miaplatform.crud.library.sync.Syncable> /* = java.util.ArrayList<eu.miaplatform.crud.library.sync.Syncable> */");
                }
                this.pushUpdatesInCollection((Class)entry.getKey(), (ArrayList)v);
            }
        }
        if (!objectToChangeStateGrouped.isEmpty()) {
            map = objectToChangeStateGrouped;
            for (Map.Entry entry : map.entrySet()) {
                Object v = entry.getValue();
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.ArrayList<eu.miaplatform.crud.library.sync.Syncable> /* = java.util.ArrayList<eu.miaplatform.crud.library.sync.Syncable> */");
                }
                this.pushChangeStateInCollection((Class)entry.getKey(), (ArrayList)v);
            }
        }
    }

    public final <T extends Syncable> void toPush(@NotNull ArrayList<T> objects) {
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        if (!objects.isEmpty()) {
            for (Syncable element : objects) {
                element.setObjectState(State.ToPush);
                this.db.update(element);
            }
        }
    }

    public final <T extends Syncable> void toPublic(@NotNull ArrayList<T> objects) {
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        if (!objects.isEmpty()) {
            for (Syncable element : objects) {
                String string = element.getObjectState();
                State newState = Intrinsics.areEqual((Object)string, (Object)State.Pub.getValue()) ? State.Pub : (Intrinsics.areEqual((Object)string, (Object)State.Draft.getValue()) ? State.ToPub : (Intrinsics.areEqual((Object)string, (Object)State.Trash.getValue()) ? State.Trash : (Intrinsics.areEqual((Object)string, (Object)State.Deleted.getValue()) ? State.Deleted : State.ToPub)));
                element.setObjectState(newState);
                this.db.update(element);
            }
        }
    }

    public final <T extends Syncable> void toTrash(@NotNull ArrayList<T> objects) {
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        if (!objects.isEmpty()) {
            for (Syncable element : objects) {
                String string = element.getObjectState();
                State newState = Intrinsics.areEqual((Object)string, (Object)State.Pub.getValue()) ? State.ToTrash : (Intrinsics.areEqual((Object)string, (Object)State.Draft.getValue()) ? State.ToTrash : (Intrinsics.areEqual((Object)string, (Object)State.Trash.getValue()) ? State.Trash : (Intrinsics.areEqual((Object)string, (Object)State.Deleted.getValue()) ? State.ToTrash : State.ToTrash)));
                element.setObjectState(newState);
                this.db.update(element);
            }
        }
    }

    public final <T extends Syncable> void toDeleted(@NotNull ArrayList<T> objects) {
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        if (!objects.isEmpty()) {
            for (Syncable element : objects) {
                String string = element.getObjectState();
                State newState = Intrinsics.areEqual((Object)string, (Object)State.Pub.getValue()) ? State.Pub : (Intrinsics.areEqual((Object)string, (Object)State.Draft.getValue()) ? State.Draft : (Intrinsics.areEqual((Object)string, (Object)State.Trash.getValue()) ? State.ToDeleted : (Intrinsics.areEqual((Object)string, (Object)State.Deleted.getValue()) ? State.Deleted : State.ToDeleted)));
                element.setObjectState(newState);
                this.db.update(element);
            }
        }
    }

    public final <T extends Syncable> void toDraft(@NotNull ArrayList<T> objects) {
        Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
        if (!objects.isEmpty()) {
            for (Syncable element : objects) {
                String string = element.getObjectState();
                State newState = Intrinsics.areEqual((Object)string, (Object)State.Pub.getValue()) ? State.ToDraft : (Intrinsics.areEqual((Object)string, (Object)State.Draft.getValue()) ? State.Draft : (Intrinsics.areEqual((Object)string, (Object)State.Trash.getValue()) ? State.ToDraft : (Intrinsics.areEqual((Object)string, (Object)State.Deleted.getValue()) ? State.Deleted : State.ToDraft)));
                element.setObjectState(newState);
                this.db.update(element);
            }
        }
    }

    private final <T extends Syncable> void pushObjectsInCollection(Class<T> clazz, ArrayList<T> objectsToPush) {
        CharSequence charSequence;
        String collectionName = this.getCollectionNameFromAnnotation(clazz);
        if (collectionName != null && !((charSequence = (CharSequence)collectionName).length() == 0)) {
            try {
                POST post = this.crud.post(collectionName);
                ArrayList<String> ids = post.sync(objectsToPush, (State)null);
                GET get = this.crud.get(collectionName, (QueryBuilder)null);
                if (ids != null && !ids.isEmpty()) {
                    Iterator<String> iterator = ids.iterator();
                    while (iterator.hasNext()) {
                        String id;
                        String string = id = iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
                        Syncable obj = (Syncable)get.sync(string, clazz);
                        if (obj == null) continue;
                        this.db.insert(obj);
                    }
                }
                this.db.delete(objectsToPush);
            }
            catch (Exception e) {
                throw (Throwable)e;
            }
        } else {
            throw (Throwable)new CRUDError("No collection name");
        }
    }

    private final <T extends Syncable> void pushUpdatesInCollection(Class<T> clazz, ArrayList<T> objectsToUpdate) {
        CharSequence charSequence;
        String collectionName = this.getCollectionNameFromAnnotation(clazz);
        if (collectionName != null && !((charSequence = (CharSequence)collectionName).length() == 0)) {
            for (Syncable objUpdate : objectsToUpdate) {
                CharSequence charSequence2 = objUpdate.getObjectId();
                if (charSequence2 == null || charSequence2.length() == 0) {
                    throw (Throwable)new CRUDError("No glsDriverId for update object");
                }
                try {
                    Map map;
                    PATCH patch = this.crud.patch(collectionName);
                    JsonElement jsonElement = GsonFactory.Companion.newGsonInstance().toJsonTree((Object)objUpdate);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"GsonFactory.newGsonInsta\u2026e().toJsonTree(objUpdate)");
                    JsonObject jsonObject = jsonElement.getAsJsonObject();
                    Type type2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
                    Object object = GsonFactory.Companion.newGsonInstance().fromJson((JsonElement)jsonObject, type2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"GsonFactory.newGsonInsta\u2026romJson(jsonObject, type)");
                    Map map2 = map = (Map)object;
                    for (Map.Entry element : map2.entrySet()) {
                        map2 = element.getValue();
                        if (map2 instanceof String) {
                            Object v = element.getValue();
                            if (v == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                            }
                            patch.update((Serializable)((Object)((String)v)), (String)element.getKey());
                            continue;
                        }
                        if (map2 instanceof Integer) {
                            Object v = element.getValue();
                            if (v == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
                            }
                            patch.update((Serializable)((Integer)v), (String)element.getKey());
                            continue;
                        }
                        if (map2 instanceof Long) {
                            Object v = element.getValue();
                            if (v == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                            }
                            patch.update((Serializable)((Long)v), (String)element.getKey());
                            continue;
                        }
                        if (map2 instanceof Float) {
                            Object v = element.getValue();
                            if (v == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                            }
                            patch.update((Serializable)((Float)v), (String)element.getKey());
                            continue;
                        }
                        if (map2 instanceof Double) {
                            Object v = element.getValue();
                            if (v == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
                            }
                            patch.update((Serializable)((Double)v), (String)element.getKey());
                            continue;
                        }
                        if (!(map2 instanceof Date)) continue;
                        Object v = element.getValue();
                        if (v == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.util.Date");
                        }
                        patch.update((Serializable)((Object)CRUDObject.INSTANCE.toISO8601((Date)v)), (String)element.getKey());
                    }
                    String string = objUpdate.getObjectId();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    patch.sync(string);
                    this.db.update(objUpdate);
                }
                catch (Exception e) {
                    throw (Throwable)e;
                }
            }
        } else {
            throw (Throwable)new CRUDError("No collection name");
        }
    }

    private final <T extends Syncable> void pushChangeStateInCollection(Class<T> clazz, ArrayList<T> objectsToChangeState) {
        CharSequence charSequence;
        String collectionName = this.getCollectionNameFromAnnotation(clazz);
        if (collectionName != null && !((charSequence = (CharSequence)collectionName).length() == 0)) {
            block5: for (Syncable objChangeState : objectsToChangeState) {
                CharSequence charSequence2 = objChangeState.getObjectId();
                if ((charSequence2 == null || charSequence2.length() == 0) && ((charSequence2 = (CharSequence)objChangeState.getObjectState()) == null || charSequence2.length() == 0)) {
                    throw (Throwable)new CRUDError("No object glsDriverId or valid state to change state");
                }
                try {
                    POST post = this.crud.post(collectionName);
                    String string = objChangeState.getObjectState();
                    State state2 = Intrinsics.areEqual((Object)string, (Object)State.ToPub.getValue()) ? State.Pub : (Intrinsics.areEqual((Object)string, (Object)State.ToDraft.getValue()) ? State.Draft : (Intrinsics.areEqual((Object)string, (Object)State.ToTrash.getValue()) ? State.Trash : State.Deleted));
                    String string2 = objChangeState.getObjectId();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    post.syncChangeState(string2, state2);
                    switch (Sync$WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                        case 1: {
                            objChangeState.setObjectState(State.Pub);
                            this.db.update(objChangeState);
                            continue block5;
                        }
                    }
                    this.db.delete(objChangeState);
                }
                catch (Exception e) {
                    throw (Throwable)e;
                }
            }
        } else {
            throw (Throwable)new CRUDError("No collection name");
        }
    }

    private final <T extends Syncable> void pullCollectionUpdates(Class<T> clazz, Date maxUpdatedAt) {
        CharSequence charSequence;
        String collectionName = this.getCollectionNameFromAnnotation(clazz);
        if (collectionName != null && !((charSequence = (CharSequence)collectionName).length() == 0)) {
            try {
                GET getTotal = this.crud.get(collectionName, (QueryBuilder)null);
                Integer totalCount = getTotal.syncCount();
                if (totalCount != null && totalCount == 0) {
                    return;
                }
                QueryBuilder updatedAtQuery = maxUpdatedAt != null ? new QueryBuilder().greater(CRUDObject.INSTANCE.getUPDATED_AT_KEY$mia_service_java_library(), (Serializable)((Object)CRUDObject.INSTANCE.toISO8601(maxUpdatedAt))) : null;
                GET overAllGet = this.crud.get(collectionName, updatedAtQuery);
                overAllGet.state(CollectionsKt.arrayListOf((Object[])new State[]{State.Pub, State.Draft, State.Deleted, State.Trash}));
                Integer updatesCount = overAllGet.syncCount();
                ArrayList objectsToUpdate = new ArrayList();
                if (updatesCount != null && updatesCount > 0) {
                    ArrayList<T> resultObjects;
                    int limit = 100;
                    int pageIndex = 0;
                    do {
                        GET getUpdate = this.crud.get(collectionName, updatedAtQuery);
                        getUpdate.state(CollectionsKt.arrayListOf((Object[])new State[]{State.Pub, State.Draft, State.Deleted, State.Trash}));
                        getUpdate.limit(limit);
                        getUpdate.skip(limit * pageIndex);
                        resultObjects = getUpdate.sync(clazz);
                        if (resultObjects != null && !resultObjects.isEmpty()) {
                            objectsToUpdate.addAll(resultObjects);
                        }
                        ++pageIndex;
                    } while (resultObjects != null && resultObjects.size() == limit);
                }
                this.db.update(objectsToUpdate);
            }
            catch (Exception e) {
                throw (Throwable)e;
            }
        } else {
            throw (Throwable)new CRUDError("No collection name");
        }
    }

    private final <T extends Syncable> String getCollectionNameFromAnnotation(Class<T> clazz) {
        CharSequence charSequence;
        CollectionAnnotation collectionAnnotation = clazz.getAnnotation(CollectionAnnotation.class);
        String declaredCollectionName = null;
        if (collectionAnnotation != null && ((declaredCollectionName = collectionAnnotation.collectionName()) == null || (charSequence = (CharSequence)declaredCollectionName).length() == 0)) {
            declaredCollectionName = collectionAnnotation.value();
        }
        return declaredCollectionName;
    }

    public Sync(@NotNull CRUD crud, @NotNull DatabaseSync db) {
        Intrinsics.checkParameterIsNotNull((Object)crud, (String)"crud");
        Intrinsics.checkParameterIsNotNull((Object)db, (String)"db");
        this.crud = crud;
        this.db = db;
    }
}

