/*
 * Decompiled with CFR 0.152.
 */
package eu.lundegaard.commons.util;

import eu.lundegaard.commons.util.DateUtil;
import java.time.LocalDateTime;
import java.util.Date;

public class Stopwatch {
    private static final long NO_TIME = -1L;
    private static final long MILLIS_IN_SECOND = 1000L;
    private static final long MILLIS_IN_MINUTE = 60000L;
    private final long startTime;
    private long elapsedTime = -1L;

    private Stopwatch() {
        this.startTime = System.currentTimeMillis();
    }

    private Stopwatch(Date startDate) {
        this.startTime = startDate.getTime();
    }

    public static Stopwatch start() {
        return new Stopwatch();
    }

    public static Stopwatch startedAt(Date startDateTime) {
        return new Stopwatch(startDateTime);
    }

    public static Stopwatch startedAt(LocalDateTime startDateTime) {
        return new Stopwatch(DateUtil.toDate(startDateTime));
    }

    public long stop() {
        this.elapsedTime = System.currentTimeMillis() - this.startTime;
        return this.elapsedTime;
    }

    public long elapsedTime() {
        return this.elapsedTime == -1L ? System.currentTimeMillis() - this.startTime : this.elapsedTime;
    }

    public String pretty() {
        long time = this.elapsedTime();
        if (time > 180000L) {
            return Long.toString(time / 60000L) + "m";
        }
        if (time > 3000L) {
            return Long.toString(time / 1000L) + "s";
        }
        return Long.toString(time) + "ms";
    }
}

